/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.person;

import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.drive.business.accessrequest.AccessRequestService;
import de.justsoftware.drive.business.event.PersonUpdatedEvent;
import de.justsoftware.drive.business.person.PersonService;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.person.PersonDAO;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class PersonServiceImpl
implements PersonService {
    private final PersonDAO _personDAO;
    private final AccessRequestService _accessRequestService;

    @Autowired
    public PersonServiceImpl(PersonDAO personDAO, AccessRequestService accessRequestService) {
        this._personDAO = personDAO;
        this._accessRequestService = accessRequestService;
    }

    public ImmutableMap<PersonId, PersonBO> getPersonsByIds(Set<PersonId> personIds) {
        return this._personDAO.getPersons(personIds);
    }

    @Subscribe
    public void onPersonUpdated(PersonUpdatedEvent e) {
        EntryStream.from((Map)this.getPersonsByIds((Set)e.getPersonIds())).filter((id, person) -> person.isDeleted()).forEach((id, person) -> this._accessRequestService.cancelAllRequestsForUser(id));
    }
}

