/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.migrationwiki;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.business.migrationwiki.WikiMigrationResultPublisher;
import de.justsoftware.drive.business.migrationwiki.document.WikiMigrationDocumentTreeModificationService;
import de.justsoftware.drive.business.migrationwiki.model.DocumentMigrationResult;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class WikiDocumentMigrationService {
    private static final Logger LOG = LoggerFactory.getLogger(WikiDocumentMigrationService.class);
    private final SharesService _shareService;
    private final WikiMigrationDocumentTreeModificationService _treeModificationService;
    private final WikiMigrationResultPublisher _resultPublisher;
    private final FileService _fileService;
    private final ItemWriteService _itemWriteService;
    private final ChangeModificationService _changeModificationService;
    private final DocumentService _documentService;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public WikiDocumentMigrationService(SharesService shareService, WikiMigrationDocumentTreeModificationService treeModificationService, WikiMigrationResultPublisher resultPublisher, FileService fileService, ItemWriteService itemWriteService, ChangeModificationService changeModificationService, DocumentService documentService, TransactionSupport transactionSupport) {
        this._shareService = shareService;
        this._treeModificationService = treeModificationService;
        this._resultPublisher = resultPublisher;
        this._fileService = fileService;
        this._itemWriteService = itemWriteService;
        this._changeModificationService = changeModificationService;
        this._documentService = documentService;
        this._transactionSupport = transactionSupport;
    }

    public void moveFileToItem(DocumentId documentToMove, ItemId targetItem) {
        FileVersionBO currentFileVersion = this._fileService.getLastFileVersion(documentToMove, PublishedFilter.PUBLISHED_OR_PRIVATE);
        if (currentFileVersion == null) {
            LOG.error("Could not find a file version for the given documentId: {}. Ignoring migration request", (Object)documentToMove);
            return;
        }
        if (this._documentService.isDeleted(documentToMove, PublishedFilter.PUBLISHED_OR_PRIVATE)) {
            LOG.info("The given document {} has already been deleted. ", (Object)documentToMove);
            return;
        }
        PersonId owner = currentFileVersion.getOwner();
        DocumentId targetRootFolder = this.getOrCreateTargetRootFolder(targetItem);
        DocumentId copiedDocument = this._treeModificationService.copyToNewRoot(documentToMove, targetRootFolder);
        this._treeModificationService.deleteDocument(documentToMove, owner);
        DocumentMigrationResult migrationResult = new DocumentMigrationResult(documentToMove, copiedDocument, targetItem);
        this._transactionSupport.doAfterTransaction(() -> this._resultPublisher.publishWikiDocumentMigrationResult(migrationResult));
    }

    @Nonnull
    private DocumentId getOrCreateTargetRootFolder(ItemId targetItem) {
        PersonId systemUserId = new PersonId(0L);
        DocumentId rootFolder = (DocumentId)this._shareService.getRootFolderIds(Set.of(targetItem)).get((Object)targetItem);
        if (rootFolder != null) {
            return rootFolder;
        }
        ItemCreateModel itemCreateModel = new ItemCreateModel(targetItem, "", null, true);
        this._itemWriteService.storeItem((Map)ImmutableMap.of((Object)targetItem, (Object)itemCreateModel));
        this._changeModificationService.createRootFoldersIfNecessary(Map.of(targetItem, systemUserId));
        return Objects.requireNonNull((DocumentId)this._shareService.getRootFolderIds(Set.of(targetItem)).get((Object)targetItem), "Failed to create new item for chosen targetItem " + targetItem.toString());
    }
}

