/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.document.ItemLockedException;
import de.justsoftware.drive.business.file.FileStorageService;
import de.justsoftware.drive.business.item.ItemPurgeService;
import de.justsoftware.drive.business.search.SearchIndexQueueProducer;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.file.FileVersionMapper;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.jdoc.rest.model.ExternalDocumentId;
import de.justsoftware.jdoc.rest.service.client.DocumentManager;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
class ItemPurgeServiceImpl
implements ItemPurgeService {
    private static final Logger LOG = LoggerFactory.getLogger(ItemPurgeServiceImpl.class);
    private static final double MB_FACTOR = 1000000.0;
    private final ItemDAO _itemDAO;
    private final DocumentDAO _documentDAO;
    private final SubFolderDAO _subFolderDAO;
    private final DocumentVersionDAO _documentVersionDAO;
    private final TransactionSupport _transactionSupport;
    private final ItemLockService _itemLockService;
    private final ChangeDAO _changeDAO;
    private final DocumentManager _documentManager;
    private final FileStorageService _fileStorageService;
    private final FileVersionPreviewDAO _fileVersionPreviewDAO;
    private final DocumentManager _justDocuments;
    private final FolderVersionDAO _folderVersionDAO;
    private final FileVersionDAO _fileVersionDAO;
    private final SearchIndexQueueProducer _searchIndexQueueProducer;

    public ItemPurgeServiceImpl(DocumentDAO documentDAO, SubFolderDAO subFolderDAO, DocumentVersionDAO documentVersionDAO, TransactionSupport transactionSupport, ItemLockService itemLockService, ChangeDAO changeDAO, DocumentManager documentManager, FileStorageService fileStorageService, FileVersionMapper fileVersionMapper, FileVersionPreviewDAO fileVersionPreviewDAO, ItemDAO itemDAO, DocumentManager justDocuments, FolderVersionDAO folderVersionDAO, FileVersionDAO fileVersionDAO, SearchIndexQueueProducer searchIndexQueueProducer) {
        this._documentDAO = documentDAO;
        this._subFolderDAO = subFolderDAO;
        this._documentVersionDAO = documentVersionDAO;
        this._transactionSupport = transactionSupport;
        this._itemLockService = itemLockService;
        this._changeDAO = changeDAO;
        this._documentManager = documentManager;
        this._fileStorageService = fileStorageService;
        this._fileVersionPreviewDAO = fileVersionPreviewDAO;
        this._itemDAO = itemDAO;
        this._justDocuments = justDocuments;
        this._folderVersionDAO = folderVersionDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._searchIndexQueueProducer = searchIndexQueueProducer;
    }

    @Nonnull
    public Set<ItemId> purge(Set<ItemId> items) {
        if (!this._justDocuments.isAvailable()) {
            LOG.error("Trying to purge items, but Judo is not available. No items are purged.");
            return Set.of();
        }
        if (!this._fileStorageService.isFileStorageAvailable()) {
            LOG.error("Trying to purge items, but file storage is not available. Not items are purged.");
            return Set.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)items.size());
        items = this._itemDAO.filterDeleted(items);
        items = this._itemDAO.filterChildFree(items);
        this._searchIndexQueueProducer.onItemPurged(items);
        for (ItemId itemId : items) {
            try {
                List allVersionsForItem = this._fileVersionDAO.getAllVersionsForItem(itemId);
                Set onlyReferencedByItem = this._fileVersionDAO.getExclusiveStorageIdsForItem(itemId);
                this._itemLockService.acquireAndExecute(itemId, this.purgeDataFromDatabaseFor(itemId, onlyReferencedByItem));
                this.deleteFromStorageServer(allVersionsForItem, onlyReferencedByItem);
                this.deleteFromJudoServer(onlyReferencedByItem);
                DoubleSummaryStatistics statistics = allVersionsForItem.stream().mapToDouble(bo -> (double)bo.getFileSize() / 1000000.0).summaryStatistics();
                builder.add((Object)itemId);
                if (statistics.getCount() > 0L) {
                    LOG.info("Deleted {} files for item '{}'. Potentially freeing up {} MB.", new Object[]{statistics.getCount(), itemId, Math.floor(statistics.getSum())});
                    continue;
                }
                LOG.info("No files found for item '{}'.", (Object)itemId);
            }
            catch (ItemLockedException e) {
                LOG.error("Could not lock item '{}'. Nothing will be deleted for the item this time.", (Object)itemId);
            }
        }
        return builder.build();
    }

    @Nonnull
    private Supplier<Boolean> purgeDataFromDatabaseFor(ItemId itemId, Set<StorageId> exclusiveStorageIds) {
        return () -> (Boolean)this._transactionSupport.doInTransaction(() -> {
            this._documentDAO.prepareDeleteItem(itemId);
            this._subFolderDAO.deleteAllForItem(itemId);
            this._fileVersionDAO.deleteAllFromItem(itemId);
            Set documentVersionIds = this._documentVersionDAO.getAllDocumentsForItem(itemId);
            this._changeDAO.deleteChanges(documentVersionIds);
            this._folderVersionDAO.deleteByIds(documentVersionIds);
            this._documentDAO.deleteAllWithoutVersions();
            this._itemDAO.deleteItems(Set.of(itemId));
            this._fileVersionPreviewDAO.deletePreviews(exclusiveStorageIds);
            return true;
        });
    }

    private void deleteFromJudoServer(Set<StorageId> storageIds) {
        ImmutableMap previewInfos = this._fileVersionPreviewDAO.getPreviewInfos(storageIds);
        Set externalDocumentIds = previewInfos.values().stream().map(FilePreviewInfoBO::getPreviewId).filter(Objects::nonNull).map(p -> new ExternalDocumentId((String)p.getId())).collect(Collectors.toUnmodifiableSet());
        this._documentManager.deleteDocuments(externalDocumentIds);
    }

    private void deleteFromStorageServer(List<FileVersionBO> allVersionsForItem, Set<StorageId> onlyReferencedByItem) {
        ImmutableListMultimap asMap = Multimaps.index(allVersionsForItem, FileVersionBO::getStorageId);
        Multimap deleteStorageIds = Multimaps.filterKeys((Multimap)asMap, onlyReferencedByItem::contains);
        this._fileStorageService.deleteFilesWithTransactionLog(deleteStorageIds, FileStorageService.DeletionMode.FORCE_DELETE_REFERENCED_FILES);
    }
}

