/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import de.justsoftware.drive.business.document.ByteSourceWithFilename;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.file.FileStorageService;
import de.justsoftware.drive.common.file.model.FileInfo;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileStorageServiceImpl
implements FileStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(FileStorageServiceImpl.class);
    private final FileStorageDAO _fileStorageDAO;
    private final FileVersionDAO _fileVersionDAO;

    @Autowired
    public FileStorageServiceImpl(FileStorageDAO fileStorageDAO, FileVersionDAO fileVersionDAO) {
        this._fileStorageDAO = fileStorageDAO;
        this._fileVersionDAO = fileVersionDAO;
    }

    public boolean isFileStorageAvailable() {
        return this._fileStorageDAO.isAvailable();
    }

    public FileInfo storeFile(ByteSourceWithFilename source) {
        String mimeType = FileMetaInfoUtil.getMimeType((String)source.getFilename(), (String)((String)source.getMimeType().orNull()));
        String fileExtension = FileMetaInfoUtil.getFileExtension((String)source.getFilename(), (String)mimeType);
        StorageId storageId = this._fileStorageDAO.store(fileExtension, source.getByteSource());
        return new FileInfo(storageId, source.getFilename(), mimeType, source.size());
    }

    public Set<StorageId> deleteFilesWithTransactionLog(Multimap<StorageId, FileVersionBO> files, FileStorageService.DeletionMode deletionMode) {
        Set deletedStorageIds = this.deleteFilesSilently(files.keySet(), deletionMode);
        Multimaps.filterKeys(files, deletedStorageIds::contains).forEach((storageId, file) -> LOG.info("Deleted file {}-'{}'-{} -{} -> {}", new Object[]{file.getItemId(), file.getName(), file.getOwner(), file.getVersion(), storageId}));
        return deletedStorageIds;
    }

    public Set<StorageId> deleteFilesSilently(Set<StorageId> storageIds) {
        return this.deleteFilesSilently(storageIds, FileStorageService.DeletionMode.SAFE);
    }

    @Nonnull
    private Set<StorageId> deleteFilesSilently(Set<StorageId> storageIds, FileStorageService.DeletionMode deletionMode) {
        HashSet<StorageId> deletedStorageIds = new HashSet<StorageId>(storageIds.size());
        Set stillReferenced = deletionMode == FileStorageService.DeletionMode.SAFE ? this._fileVersionDAO.getReferencedStorageIds(storageIds) : Collections.emptySet();
        for (StorageId storageId : storageIds) {
            if (stillReferenced.contains(storageId)) continue;
            try {
                this._fileStorageDAO.delete(storageId);
                deletedStorageIds.add(storageId);
            }
            catch (RuntimeException e) {
                LOG.error("unable to delete file " + storageId, (Throwable)e);
            }
        }
        return Set.copyOf(deletedStorageIds);
    }
}

