/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.document.ItemLockedException;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class ItemLockServiceImpl
implements ItemLockService {
    private static final Logger LOG = LoggerFactory.getLogger(ItemLockServiceImpl.class);
    private static final String ZOOKEEPER_PATH_PREFIX = "/just/drive/itemLock/";
    private final int _timeOutSeconds;
    private final int _numberOfLocks;
    private final CuratorFramework _zookeeperClient;
    private final DocumentVersionDAO _documentVersionDAO;

    @Autowired
    public ItemLockServiceImpl(DocumentVersionDAO documentVersionDAO, CuratorFramework zookeeperClient, @Value(value="${just.drive.itemLock.timeout:10}") int timeOutSeconds, @Value(value="${just.drive.itemLock.lockcount:101}") int lockcount) {
        this._documentVersionDAO = documentVersionDAO;
        this._zookeeperClient = zookeeperClient;
        this._timeOutSeconds = Math.max(timeOutSeconds, 1);
        this._numberOfLocks = Math.max(lockcount, 1);
    }

    public <R> R acquireAndExecute(@Nullable ItemId itemId, Supplier<R> f) {
        return (R)this.acquireAndExecute(Collections.singleton(itemId), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R acquireAndExecute(Set<ItemId> itemIds, Supplier<R> f) {
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this._timeOutSeconds);
        ImmutableSetMultimap lockIds = (ImmutableSetMultimap)itemIds.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(arg_0 -> this.lockId(arg_0), Optional::ofNullable));
        LinkedList<Runnable> releases = new LinkedList<Runnable>();
        try {
            Iterable sortedLockIds = lockIds.keySet().stream().sorted()::iterator;
            for (Integer lockId : sortedLockIds) {
                boolean lockAcquired;
                long timeOutMillis = end - System.currentTimeMillis();
                if (timeOutMillis < 1L) {
                    throw new ItemLockedException();
                }
                InterProcessMutex mutex = new InterProcessMutex(this._zookeeperClient, ZOOKEEPER_PATH_PREFIX + lockId);
                try {
                    lockAcquired = mutex.acquire(timeOutMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    LOG.warn(String.format("Catched Exception while acquiring lock %s for item %s, ignoring the lock, but expect errors!", lockId, lockIds.get((Object)lockId)), (Throwable)e);
                    R r = f.get();
                    releases.forEach(Runnable::run);
                    return r;
                }
                if (!lockAcquired) {
                    throw new ItemLockedException();
                }
                releases.addFirst(() -> {
                    try {
                        mutex.release();
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Catched Exception during release of lock %s for items %s, expect further errors!", lockId, lockIds.get((Object)lockId)), (Throwable)e);
                    }
                });
            }
            Iterator<Object> iterator = f.get();
            return (R)iterator;
        }
        finally {
            releases.forEach(Runnable::run);
        }
    }

    @VisibleForTesting
    int lockId(@Nullable ItemId itemId) {
        if (itemId == null) {
            return 0;
        }
        return Math.floorMod(itemId.hashCode(), this._numberOfLocks);
    }

    public <R> R acquireAndExecute(DocumentId documentId, Supplier<R> f) {
        ItemId itemId = (ItemId)this._documentVersionDAO.getItemIdsOfDocument((Set)ImmutableSet.of((Object)documentId)).get((Object)documentId);
        return (R)this.acquireAndExecute(itemId, f);
    }

    public <R> R acquireAndExecute(DocumentVersionId documentVersionId, Supplier<R> f) {
        ItemId itemId = (ItemId)this._documentVersionDAO.getItemIdsOfDocumentVersions((Set)ImmutableSet.of((Object)documentVersionId)).get((Object)documentVersionId);
        return (R)this.acquireAndExecute(itemId, f);
    }
}

