/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.document.DocumentMigrationService;
import de.justsoftware.drive.business.document.DocumentTreeModificationService;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.drive.business.event.DocumentMetadataChangedEvent;
import de.justsoftware.drive.business.event.FilesCreatedEvent;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.file.model.FilePreviewStatus;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.filepersistence.common.FilePersistenceException;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.file.FileVersionPreviewCreateModel;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentMigrationServiceImpl
implements DocumentMigrationService {
    private final FileStorageDAO _fileStorageDAO;
    private final DocumentDAO _documentDAO;
    private final FileVersionDAO _fileVersionDAO;
    private final DocumentTreeModificationService _documentTreeModificationService;
    private final ChangeModificationService _changeModificationService;
    private final FileVersionPreviewDAO _previewDAO;
    private final FolderVersionDAO _folderVersionDAO;
    private final EventBus _eventBus;
    private final ItemWriteService _itemWriteService;

    @Autowired
    public DocumentMigrationServiceImpl(FileStorageDAO fileStorageDAO, DocumentTreeModificationService documentTreeModificationServie, FileVersionDAO fileVersionDAO, DocumentDAO documentDAO, ChangeModificationService changeModificationService, FileVersionPreviewDAO previewDAO, FolderVersionDAO folderVersionDAO, EventBus eventBus, ItemWriteService itemWriteService) {
        this._fileStorageDAO = fileStorageDAO;
        this._documentTreeModificationService = documentTreeModificationServie;
        this._fileVersionDAO = fileVersionDAO;
        this._documentDAO = documentDAO;
        this._changeModificationService = changeModificationService;
        this._previewDAO = previewDAO;
        this._folderVersionDAO = folderVersionDAO;
        this._eventBus = eventBus;
        this._itemWriteService = itemWriteService;
    }

    public void addFilesFromMigration(Iterable<DocumentMigrationService.MigrationFile> filesIterable, Consumer<Runnable> afterCommitCallbackConsumer) {
        FluentIterable files = FluentIterable.from(filesIterable);
        ImmutableSet versionIds = files.transform(f -> f._documentVersionId).toSet();
        ImmutableMap existingVersions = this._fileVersionDAO.getByIds((Set)versionIds);
        ImmutableSet documentIdsToProcess = files.transform(f -> f._documentId).toSet();
        ImmutableSet existingDocumentIds = ImmutableSet.copyOf((Collection)this._documentDAO.getDocumentsById((Set)documentIdsToProcess).keySet());
        HashMap newVersionsMap = new HashMap();
        if (!this._fileStorageDAO.isAvailable()) {
            MIGRATION_LOG.error("skipping migration as storage server is not available");
        }
        files.forEach(file -> {
            if (existingVersions.containsKey((Object)file._documentVersionId)) {
                MIGRATION_LOG.warn("version already migrated {}", (Object)file._documentVersionId);
                return;
            }
            boolean createNewFile = !existingDocumentIds.contains((Object)file._documentId) && !newVersionsMap.containsKey(file._documentId);
            Optional migratedVersion = this.migrateFile(file, createNewFile, afterCommitCallbackConsumer);
            if (migratedVersion.isPresent()) {
                newVersionsMap.put(file._documentId, (DocumentVersionId)migratedVersion.get());
            }
        });
        HashMap parentMap = new HashMap();
        files.forEach(f -> {
            if (f._grandmaItemId != null) {
                parentMap.put(f._parentId, Optional.of((Object)f._grandmaItemId));
            }
        });
        this._itemWriteService.setParents((Map)ImmutableMap.copyOf(parentMap));
        this._eventBus.post((Object)new FilesCreatedEvent(ImmutableMap.copyOf(newVersionsMap)));
    }

    @Nonnull
    private Optional<StorageId> migrateFileStorage(DocumentMigrationService.MigrationFile file) {
        String fileExtension = FileMetaInfoUtil.getFileExtension((String)file._fileName, (String)file._mimeType);
        try {
            return Optional.of((Object)this._fileStorageDAO.moveExistingFile(fileExtension, file._storageServerPath));
        }
        catch (FilePersistenceException e) {
            if (file._restoreFromVersionId.isPresent()) {
                DocumentVersionId restoreFromId = (DocumentVersionId)file._restoreFromVersionId.get();
                FileVersionBO restoredFrom = (FileVersionBO)this._fileVersionDAO.getByIds((Set)ImmutableSet.of((Object)restoreFromId)).get((Object)restoreFromId);
                if (restoredFrom != null) {
                    MIGRATION_LOG.info("reusing storageId from {}", (Object)restoreFromId);
                    return Optional.of((Object)restoredFrom.getStorageId());
                }
            } else {
                MIGRATION_LOG.warn("error from storage server {} - {}", (Object)file._originId, (Object)e.getMessage());
            }
            return Optional.absent();
        }
    }

    @Nonnull
    private Optional<DocumentVersionId> migrateFile(DocumentMigrationService.MigrationFile file, boolean createNewFile, Consumer<Runnable> afterCommitCallbackConsumer) {
        MIGRATION_LOG.info("migrating {} - {}, {}, {}", new Object[]{file._documentId, file._documentVersionId, file._version, file._originId});
        Optional optStorageId = this.migrateFileStorage(file);
        if (!optStorageId.isPresent()) {
            MIGRATION_LOG.warn("skipping file {} due to storage error", (Object)file._originId);
            return Optional.absent();
        }
        StorageId storageId = (StorageId)optStorageId.get();
        if (file._previewId != null && (file._restoreFromVersionId == null || this._previewDAO.getPreviewInfos((Set)ImmutableSet.of((Object)storageId)).get((Object)storageId) == null)) {
            this._previewDAO.create(new FileVersionPreviewCreateModel(storageId, file._previewId, FilePreviewStatus.QUEUED));
        }
        ChangeBO change = this._changeModificationService.getOrCreateNewestChange(file._parentId, file._owner, PublishedFilter.PUBLISHED_OR_PRIVATE, "DOCUMENT_TO_DRIVE_MIGRATION");
        DocumentVersionId parentFolderVersionId = change.getId();
        DocumentId parentFolderId = ((FolderVersionBO)Preconditions.checkNotNull((Object)((FolderVersionBO)this._folderVersionDAO.getFolderVersionsByIds((Set)ImmutableSet.of((Object)parentFolderVersionId)).get((Object)parentFolderVersionId)))).getDocumentId();
        return createNewFile ? Optional.of((Object)this._documentTreeModificationService.addNewFileFromMigration(file, storageId, parentFolderId, afterCommitCallbackConsumer)) : Optional.of((Object)this._documentTreeModificationService.addNewFileVersionFromMigration(file, storageId, parentFolderId, afterCommitCallbackConsumer));
    }

    public int updateMetadata(Iterable<DocumentMigrationService.MigrationMetadata> metadata) {
        ImmutableSet existingDocumentIds;
        ImmutableSet documentIds = FluentIterable.from(metadata).transform(m -> m._documentId).toSet();
        if (!documentIds.equals((Object)(existingDocumentIds = this._documentDAO.getDocumentsById((Set)documentIds).keySet()))) {
            MIGRATION_LOG.error("got metadata for non existing documentIds! {}", (Object)Sets.difference((Set)documentIds, (Set)existingDocumentIds));
        }
        ImmutableSet existingMetadata = FluentIterable.from(metadata).filter(m -> existingDocumentIds.contains((Object)m._documentId)).toSet();
        existingMetadata.forEach(meta -> this._documentDAO.updateMetadata(meta._documentId, meta._description, meta._keywords));
        this._eventBus.post((Object)new DocumentMetadataChangedEvent((Set)existingDocumentIds));
        return existingMetadata.size();
    }

    public boolean migrationPossible() {
        return this._fileStorageDAO.isAvailable();
    }
}

