/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import com.google.common.base.Strings;
import de.justsoftware.drive.business.common.ZookeeperUtil;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.unit.DataSize;

@ParametersAreNonnullByDefault
@Service
public class ZookeeperConfigurationService {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperConfigurationService.class);
    private static final String RE_INDEX_SEARCH_ON_UPDATE = "/just/config/common/reIndexSearchOnUpdate";
    private static final String UPLOAD_MAX_FILE_SIZE = "/just/drive/uploadMaxFileSize";
    private static final DataSize FALLBACK_UPLOAD_MAX_FILE_SIZE = DataSize.ofMegabytes((long)250L);
    private final NodeCache _reIndexSearchOnUpdate;
    private final NodeCache _uploadMaxFileSize;

    @Autowired
    public ZookeeperConfigurationService(CuratorFramework framework) {
        this._reIndexSearchOnUpdate = ZookeeperUtil.createNodeCache((CuratorFramework)framework, (String)RE_INDEX_SEARCH_ON_UPDATE);
        this._uploadMaxFileSize = ZookeeperUtil.createNodeCache((CuratorFramework)framework, (String)UPLOAD_MAX_FILE_SIZE);
    }

    @PreDestroy
    public void destroy() {
        try {
            this._reIndexSearchOnUpdate.close();
        }
        catch (IOException e) {
            LOG.warn("Error when closing NodeCache instance.", (Throwable)e);
        }
    }

    public boolean shouldReIndexSearchOnUpdate() {
        return ZookeeperUtil.getBooleanFromNodeCache((String)RE_INDEX_SEARCH_ON_UPDATE, (NodeCache)this._reIndexSearchOnUpdate, (boolean)true);
    }

    @Nonnull
    public DataSize getUploadMaxFileSize() {
        return ZookeeperUtil.getStringFromNodeCache((String)UPLOAD_MAX_FILE_SIZE, (NodeCache)this._uploadMaxFileSize).map(Strings::emptyToNull).map(DataSize::parse).orElse(FALLBACK_UPLOAD_MAX_FILE_SIZE);
    }

    public void addUploadMaxFileSizeChangeListener(Consumer<DataSize> changeListener) {
        this._uploadMaxFileSize.getListenable().addListener(() -> changeListener.accept(this.getUploadMaxFileSize()));
    }
}

