/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.search.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.batch.search.SearchVisibilityService;
import de.justsoftware.drive.batch.search.impl.SearchVisibilityServiceImpl;
import de.justsoftware.drive.business.authorization.AuthorizationService;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.ornot.BoolExpr;
import de.justsoftware.ornot.EvalContext;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import de.justsoftware.toolbox.stream.EntryCollectors;
import de.justsoftware.toolbox.stream.EntryStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class SearchVisibilityServiceImpl
implements SearchVisibilityService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchVisibilityServiceImpl.class);
    @VisibleForTesting
    final AuthorizationService _authorizationService;
    @VisibleForTesting
    final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public SearchVisibilityServiceImpl(AuthorizationService authorizationService, PermissionRequestConnector permissionRequestConnector) {
        this._authorizationService = authorizationService;
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public ImmutableTable<ItemId, StaticAction, ImmutableSet<Role>> loadVisibilities(SetMultimap<ItemId, StaticAction> itemsAndActions) {
        ImmutableSetMultimap visibilitiesForShares = this.loadVisibilitiesForShares(itemsAndActions);
        SetMultimap itemsAndActionsWithoutShares = Multimaps.filterKeys(itemsAndActions, itemId -> !ItemType.SHARE.equals((Object)itemId.getType()));
        ImmutableTable permissions = this._authorizationService.loadPermissions(itemsAndActionsWithoutShares);
        ImmutableSet.Builder rolesToLoad = ImmutableSet.builder();
        EvalContext rolesCollectContext = expr -> {
            rolesToLoad.add((Object)((Role)expr.getValue()));
            return expr;
        };
        permissions.values().forEach(p -> p.eval(rolesCollectContext));
        ImmutableSetMultimap personsWithRoles = this._authorizationService.getPersonWithRoles((Set)rolesToLoad.build());
        ItemRolesToProfileRolesEvalContext itemRolesToProfileRolesEvalContext = new ItemRolesToProfileRolesEvalContext(personsWithRoles);
        return (ImmutableTable)EntryStream.from(itemsAndActions).collect(ImmutableTable.toImmutableTable(Map.Entry::getKey, Map.Entry::getValue, arg_0 -> SearchVisibilityServiceImpl.lambda$loadVisibilities$3(visibilitiesForShares, permissions, (EvalContext)itemRolesToProfileRolesEvalContext, arg_0)));
    }

    @Nonnull
    private ImmutableSetMultimap<ItemId, Role> loadVisibilitiesForShares(SetMultimap<ItemId, StaticAction> itemsAndActions) {
        ImmutableSet shareRelatedActions = (ImmutableSet)EntryStream.from(itemsAndActions).filterKey(item -> ItemType.SHARE.equals((Object)item.getType())).filterValue(arg_0 -> StaticAction.DOCUMENT_READ.equals(arg_0)).mapKey(AbstractId::getId).keys().collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap shareVisibilities = this._permissionRequestConnector.visibility((Iterable)shareRelatedActions);
        return (ImmutableSetMultimap)EntryStream.from((Multimap)shareVisibilities).mapKey(ItemId::new).mapValue(Role::valueOf).collect(EntryCollectors.toImmutableSetMultimap());
    }

    private static /* synthetic */ ImmutableSet lambda$loadVisibilities$3(ImmutableSetMultimap visibilitiesForShares, ImmutableTable permissions, EvalContext itemRolesToProfileRolesEvalContext, Map.Entry entry) {
        ItemId itemId = (ItemId)entry.getKey();
        StaticAction action = (StaticAction)entry.getValue();
        if (ItemType.SHARE.equals((Object)itemId.getType())) {
            if (StaticAction.DOCUMENT_READ.equals((Object)action)) {
                return visibilitiesForShares.get((Object)itemId);
            }
        } else {
            BoolExpr noItemRolesExpr = (BoolExpr)permissions.get((Object)itemId, (Object)action);
            if (noItemRolesExpr != null) {
                return (ImmutableSet)noItemRolesExpr.eval(itemRolesToProfileRolesEvalContext).accept((BoolExpr.Visitor)new ExtractRoleSetVisitor(noItemRolesExpr, itemId));
            }
        }
        return ImmutableSet.of();
    }
}

