/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.search.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import de.justsoftware.drive.batch.search.IndexerData;
import de.justsoftware.drive.batch.search.SearchIndexDataService;
import de.justsoftware.drive.batch.search.SearchIndexFieldGroup;
import de.justsoftware.drive.batch.search.SearchIndexPublisher;
import de.justsoftware.drive.batch.search.SolrDocumentWrapper;
import de.justsoftware.drive.batch.search.impl.DriveSearchIndexUpdateException;
import de.justsoftware.drive.batch.search.impl.MultiOperationUpdateRequest;
import de.justsoftware.drive.batch.search.impl.SearchIndexBatchServiceImpl;
import de.justsoftware.drive.batch.search.impl.SearchIndexConfiguration;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.persistence.search.SearchIndexQueueDAO;
import de.justsoftware.drive.persistence.search.model.SearchIndexQueueEntryBO;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import de.justsoftware.permission.client.rest.PermissionRequestFailedExeception;
import de.justsoftware.toolbox.clock.Clock;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.http.ParseException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class SearchIndexBatchServiceImpl {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexBatchServiceImpl.class);
    private static final long MAX_WAIT_ON_ERROR_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final long WAIT_ON_ERROR_MILLIS_STEP = TimeUnit.SECONDS.toMillis(1L);
    private final SearchIndexQueueDAO _searchIndexQueueDAO;
    private final SolrClient _writeSolrClient;
    private final SearchIndexConfiguration _indexConfig;
    private final Clock _clock;
    private final AtomicBoolean _solrAvailable = new AtomicBoolean(true);
    private final SearchIndexDataService _searchIndexDataService;
    private final SearchIndexPublisher _searchIndexPublisher;

    @Autowired
    public SearchIndexBatchServiceImpl(SearchIndexQueueDAO searchIndexQueueDAO, SearchIndexDataService searchIndexDataService, @Qualifier(value="writeSolrClient") SolrClient writeSolrClient, Clock clock, SearchIndexConfiguration searchIndexConfiguration, SearchIndexPublisher searchIndexPublisher) {
        this._searchIndexQueueDAO = searchIndexQueueDAO;
        this._searchIndexDataService = searchIndexDataService;
        this._writeSolrClient = writeSolrClient;
        this._clock = clock;
        this._indexConfig = searchIndexConfiguration;
        this._searchIndexPublisher = searchIndexPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedDelayString="${just.drive.search.queue.delay:2000}")
    public void updateSearchIndex() {
        List entries;
        if (!this._searchIndexQueueDAO.hasEntries(this._clock.now().minusMinutes(this._indexConfig.getMaxMinutesInProcess()))) {
            return;
        }
        if (!this.isSolrAvailable()) {
            LOG.warn("Indexing currently not possible because required systems are not available. Retrying later...");
            return;
        }
        int processErrorCount = 0;
        do {
            StopWatch stopwatch = new StopWatch("update search index -  batchSize: " + this._indexConfig.getFetchsize());
            stopwatch.start("load entries from db");
            entries = this._searchIndexQueueDAO.getEntries(this._clock.now(), this._clock.now().minusMinutes(this._indexConfig.getMaxMinutesInProcess()), this._indexConfig.getFetchsize());
            stopwatch.stop();
            if (entries.isEmpty()) continue;
            boolean skipEntryDeletion = false;
            try {
                stopwatch.start("process entries");
                ImmutableSetMultimap documents = SearchIndexBatchServiceImpl.entriesToIndexTypeMap((List)entries);
                this.indexDocuments(documents, this._searchIndexDataService.getIndexData((SetMultimap)documents));
                stopwatch.stop();
                processErrorCount = 0;
            }
            catch (PermissionRequestFailedExeception e) {
                LOG.warn("Failed to index items from the search index queue, permission service request fails. Index entries will be kept and indexed again.", (Throwable)e);
                skipEntryDeletion = true;
            }
            catch (DriveSearchIndexUpdateException | RuntimeException e) {
                LOG.error("Failed to (re-)index the documents fetched from the search index queue! Index of these documents will be skipped!", e);
            }
            finally {
                if (skipEntryDeletion) {
                    this._searchIndexQueueDAO.unmarkEntriesInProgress(entries.stream().map(SearchIndexQueueEntryBO::getId).collect(Collectors.toSet()));
                    try {
                        Thread.sleep(SearchIndexBatchServiceImpl.sleepTime((int)(++processErrorCount)));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    this._searchIndexQueueDAO.delete((Set)FluentIterable.from((Iterable)entries).transform(SearchIndexQueueEntryBO::getId).toSet());
                    LOG.info(stopwatch.prettyPrint());
                }
            }
        } while (entries.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void indexDocuments(ImmutableSetMultimap<DocumentId, SearchIndexType> documents, IndexerData indexData) throws DriveSearchIndexUpdateException {
        ImmutableSetMultimap errors;
        ImmutableSetMultimap.Builder errorCollector = ImmutableSetMultimap.builder();
        try {
            ImmutableMap.Builder solrDocumentsBuilder = ImmutableMap.builder();
            documents.asMap().forEach((documentId, indexTypes) -> {
                DocumentVersionBO documentVersion = indexData.getCurrentDocumentVersion(documentId);
                if (documentVersion != null) {
                    ImmutableSet fieldGroups = SearchIndexFieldGroup.forIndexType((Iterable)indexTypes);
                    solrDocumentsBuilder.put(documentId, (Object)SearchIndexBatchServiceImpl.update((DocumentVersionBO)documentVersion, (IndexerData)indexData, (ImmutableSet)fieldGroups));
                    fieldGroups.forEach(f -> f.publish(documentVersion, this._searchIndexPublisher));
                }
            });
            ImmutableMap solrDocuments = solrDocumentsBuilder.build();
            Sets.SetView documentsToDelete = Sets.difference((Set)documents.keySet(), (Set)solrDocuments.keySet());
            try {
                ImmutableList documentsToDeleteList;
                MultiOperationUpdateRequest req = new MultiOperationUpdateRequest();
                ImmutableList solrDocumentList = ImmutableList.copyOf((Collection)solrDocuments.values());
                if (!solrDocumentList.isEmpty()) {
                    req.add((Collection)solrDocumentList);
                }
                if (!(documentsToDeleteList = FluentIterable.from((Iterable)documentsToDelete).transform(DocumentId::toSearchId).toSet().asList()).isEmpty()) {
                    req.deleteById((List)documentsToDeleteList);
                }
                if (!solrDocumentList.isEmpty() || !documentsToDelete.isEmpty()) {
                    req.process(this._writeSolrClient);
                }
            }
            catch (IOException | ParseException | SolrServerException | SolrException e) {
                LOG.warn("got exception during bulk solr update, falling back to single update", e);
                this.retryIndex(solrDocuments, (arg_0, arg_1) -> ((ImmutableSetMultimap.Builder)errorCollector).put(arg_0, arg_1));
                this.retryDelete((Set)documentsToDelete, (arg_0, arg_1) -> ((ImmutableSetMultimap.Builder)errorCollector).put(arg_0, arg_1));
            }
        }
        finally {
            try {
                this._writeSolrClient.commit(false, true, this._indexConfig.isUseSoftCommit());
            }
            catch (IOException | ParseException | SolrServerException | SolrException e) {
                LOG.error("Failed to commit solr updates", e);
            }
        }
        if (!(errors = errorCollector.build()).isEmpty()) {
            throw new DriveSearchIndexUpdateException(errors);
        }
    }

    private static long sleepTime(int errorCount) {
        long current = WAIT_ON_ERROR_MILLIS_STEP;
        for (int i = 1; i < errorCount; ++i) {
            if ((current += current) <= MAX_WAIT_ON_ERROR_MILLIS) continue;
            return MAX_WAIT_ON_ERROR_MILLIS;
        }
        return current;
    }

    private void retryDelete(Set<DocumentId> documentsToDelete, BiConsumer<DocumentId, Exception> errorCollector) {
        for (DocumentId delete : documentsToDelete) {
            try {
                this._writeSolrClient.deleteById(delete.toSearchId());
            }
            catch (IOException | ParseException | SolrServerException | SolrException singleTry) {
                errorCollector.accept(delete, (Exception)singleTry);
            }
        }
    }

    private void retryIndex(ImmutableMap<DocumentId, SolrInputDocument> solrDocuments, BiConsumer<DocumentId, Exception> errorCollector) {
        solrDocuments.forEach((documentId, solrDocument) -> {
            try {
                this._writeSolrClient.add(solrDocument);
            }
            catch (IOException | ParseException | SolrServerException | SolrException singleTry) {
                errorCollector.accept((DocumentId)documentId, (Exception)singleTry);
            }
        });
    }

    @CheckForNull
    private static List<String> nullableList(@Nullable Iterable<String> values) {
        if (values == null || Iterables.isEmpty(values)) {
            return null;
        }
        return Lists.newArrayList(values);
    }

    @Nonnull
    private static SolrInputDocument update(DocumentVersionBO documentVersion, IndexerData indexData, ImmutableSet<SearchIndexFieldGroup> fieldGroups) {
        SolrInputDocument solrDocument = new SolrInputDocument(new String[0]);
        solrDocument.setField("id", (Object)documentVersion.getDocumentId().toSearchId());
        1 solrDocumentWrapper = new /* Unavailable Anonymous Inner Class!! */;
        fieldGroups.forEach(arg_0 -> SearchIndexBatchServiceImpl.lambda$update$3((SolrDocumentWrapper)solrDocumentWrapper, documentVersion, indexData, arg_0));
        return solrDocument;
    }

    @Nonnull
    private static ImmutableSetMultimap<DocumentId, SearchIndexType> entriesToIndexTypeMap(List<SearchIndexQueueEntryBO> entries) {
        return (ImmutableSetMultimap)entries.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(SearchIndexQueueEntryBO::getDocumentId, SearchIndexQueueEntryBO::getIndexType));
    }

    private boolean isSolrAvailable() {
        block2: {
            try {
                this._writeSolrClient.ping();
                this._solrAvailable.set(true);
            }
            catch (IOException | RuntimeException | SolrServerException e) {
                if (!this._solrAvailable.getAndSet(false)) break block2;
                LOG.error("Reindexing not possible. Solr server is not ready ({})", (Object)e.getMessage());
            }
        }
        return this._solrAvailable.get();
    }

    private static /* synthetic */ void lambda$update$3(SolrDocumentWrapper solrDocumentWrapper, DocumentVersionBO documentVersion, IndexerData indexData, SearchIndexFieldGroup field) {
        field.setValues(solrDocumentWrapper, documentVersion, indexData);
    }
}

