/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.change.impl;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.business.change.HistoryCompactorJobStarter;
import de.justsoftware.drive.business.change.HistoryCompactorService;
import de.justsoftware.drive.business.common.ZookeeperUtil;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class HistoryCompactorJobSchedulerService
implements InitializingBean,
HistoryCompactorJobStarter {
    private static final Logger LOG = LoggerFactory.getLogger(HistoryCompactorJobSchedulerService.class);
    private static final String DRIVE_HISTORY_COMPACTOR_CRON = "/just/drive/historyCompactorCron";
    private final TaskScheduler _taskScheduler;
    private final HistoryCompactorService _historyCompactorService;
    private final CuratorFramework _curatorFramework;
    @Nullable
    private NodeCache _cronExpressionCache;
    @Nullable
    private ScheduledFuture<?> _scheduledJob;

    @Autowired
    public HistoryCompactorJobSchedulerService(TaskScheduler taskScheduler, HistoryCompactorService historyCompactorService, CuratorFramework curatorFramework) {
        this._taskScheduler = taskScheduler;
        this._historyCompactorService = historyCompactorService;
        this._curatorFramework = curatorFramework;
    }

    @CheckForNull
    @VisibleForTesting
    NodeCache getNodeCache() {
        return ZookeeperUtil.createNodeCache((CuratorFramework)this._curatorFramework, (String)DRIVE_HISTORY_COMPACTOR_CRON);
    }

    public void afterPropertiesSet() {
        this._cronExpressionCache = this.getNodeCache();
        if (this._cronExpressionCache == null) {
            LOG.warn("ZookeeperUtil returned null instead of node cache instance. Job won't be scheduled.");
            return;
        }
        this._cronExpressionCache.getListenable().addListener(() -> this.scheduleJob());
        this.scheduleJob();
    }

    public void startNow() {
        if (this._scheduledJob != null && this._scheduledJob.getDelay(TimeUnit.SECONDS) <= 0L && !this._scheduledJob.isDone()) {
            LOG.info("Not starting job now. Another is already running.");
        } else {
            LOG.info("Starting job now.");
            this._scheduledJob = this._taskScheduler.schedule(() -> ((HistoryCompactorService)this._historyCompactorService).compactAllItems(), Date.from(Instant.now()));
        }
    }

    private void scheduleJob() {
        String cronExpression;
        if (this._scheduledJob != null) {
            this._scheduledJob.cancel(false);
            LOG.info("Scheduled job was canceled due to a reschedule.");
        }
        if ((cronExpression = this.getCronExpression()).isEmpty()) {
            LOG.info("Cron expression is empty. Assume that job shouldn't be scheduled.");
            return;
        }
        try {
            LOG.info("Schedule job to merge Drive changes. Cron expression is {}.", (Object)cronExpression);
            CronTrigger trigger = new CronTrigger(cronExpression);
            this._scheduledJob = this._taskScheduler.schedule(() -> ((HistoryCompactorService)this._historyCompactorService).compactAllItems(), (Trigger)trigger);
        }
        catch (IllegalArgumentException e) {
            LOG.error("An illegal argument exception was raised. Make sure the supplied cron expression is valid.", (Throwable)e);
        }
    }

    @Nonnull
    private String getCronExpression() {
        return ZookeeperUtil.getStringFromNodeCache((String)DRIVE_HISTORY_COMPACTOR_CRON, (NodeCache)this._cronExpressionCache).orElse("");
    }
}

