/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.services.converter;

import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.business.DocumentService;
import de.justsoftware.jdoc.services.conversion.exceptions.InvalidShellScriptException;
import de.justsoftware.jdoc.services.conversion.exceptions.ShellScriptExecutionException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.InvalidDocumentIdException;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import de.justsoftware.judo.services.FileCacheService;
import de.justsoftware.judo.services.runner.VideoScriptRunnerService;
import de.justsoftware.judoclient.conversionstatus.ConversionStatusClient;
import de.justsoftware.judoclient.model.ConversionStatus;
import de.justsoftware.judoclient.model.ConversionTask;
import de.justsoftware.judoclient.model.Keyable;
import de.justsoftware.judoclient.model.TaskStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ConverterService {
    private static final Logger LOG = LoggerFactory.getLogger(ConverterService.class);
    private final FileCacheService _fileCacheService;
    private final VideoScriptRunnerService _videoScriptRunnerService;
    private final DocumentService _documentService;
    private final ConversionStatusClient _conversionStatusClient;

    @Autowired
    public ConverterService(FileCacheService fileCacheService, VideoScriptRunnerService videoScriptRunnerService, DocumentService documentService, ConversionStatusClient conversionStatusClient) {
        this._fileCacheService = fileCacheService;
        this._videoScriptRunnerService = videoScriptRunnerService;
        this._documentService = documentService;
        this._conversionStatusClient = conversionStatusClient;
    }

    @Nonnull
    private File downloadToFileCache(ConversionTask conversion) throws IOException {
        return this._fileCacheService.downloadToFileCache(conversion.getId(), conversion.getRemoteUrl());
    }

    private void removeFromFileCache(ConversionTask conversion) {
        try {
            this._fileCacheService.removeFromFileCache(conversion.getId());
        }
        catch (IOException e) {
            LOG.error("Exception when trying to remove file from cache.", (Throwable)e);
        }
    }

    private void convertVideo(File cachedFile, ConversionTask conversion) {
        LOG.debug("Begin video conversion for preview id '{}'.", (Object)conversion.getId());
        try {
            this._conversionStatusClient.dispatch((Keyable)new ConversionStatus(conversion.getId(), TaskStatus.PROCESSING));
            this._videoScriptRunnerService.process(cachedFile, conversion);
            this._conversionStatusClient.dispatch((Keyable)new ConversionStatus(conversion.getId(), TaskStatus.PRESENT));
        }
        catch (InvalidShellScriptException | ShellScriptExecutionException e) {
            LOG.error("Error during video conversion for preview id '" + conversion.getId() + "'.", e);
            this._conversionStatusClient.dispatch((Keyable)new ConversionStatus(conversion.getId(), TaskStatus.ERROR));
        }
        LOG.info("Video with preview id '{}' successfully converted.", (Object)conversion.getId());
    }

    private void convertOther(File cachedFile, ConversionTask conversion) {
        try {
            FileInputStream stream = new FileInputStream(cachedFile);
            DocumentInputStream documentStream = new DocumentInputStream((InputStream)stream, cachedFile.length(), conversion.getMimeType());
            DocumentId previewId = new DocumentId(conversion.getId());
            this._documentService.createDocument(previewId);
            this._documentService.createDocumentFromUpload(previewId, DocumentType.ORIGINAL, documentStream);
        }
        catch (DocumentReadWriteException | FileNotFoundException e) {
            LOG.error("IO error adding conversion task for preview id '{}' to queue.", (Object)conversion.getId(), (Object)e);
        }
        catch (InvalidDocumentIdException e) {
            LOG.error("Error adding conversion task for preview id '{}' to queue. Id is not a UUID.", (Object)conversion.getId(), (Object)e);
        }
    }

    public void startConversion(ConversionTask conversion) throws IOException {
        try {
            File cachedFile = this.downloadToFileCache(conversion);
            if (conversion.getMimeType().startsWith("video/")) {
                this.convertVideo(cachedFile, conversion);
            } else {
                this.convertOther(cachedFile, conversion);
            }
        }
        catch (IOException e) {
            throw new IOException("Downloading the input file from the Storageserver for preview id '" + conversion.getId() + "' produced an error.", e);
        }
        finally {
            this.removeFromFileCache(conversion);
        }
    }
}

