/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.kafka.conversion;

import de.justsoftware.judo.services.converter.ConverterService;
import de.justsoftware.judoclient.model.ConversionTask;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ConversionTaskProcessor
extends AbstractProcessor<String, ConversionTask> {
    private static final Logger LOG = LoggerFactory.getLogger(ConversionTaskProcessor.class);
    private final ConverterService _converterService;

    @Autowired
    public ConversionTaskProcessor(ConverterService converterService) {
        this._converterService = converterService;
    }

    public void process(String key, ConversionTask conversionTask) {
        LOG.debug("Fetched conversion task for preview id '{}' from Kafka.", (Object)conversionTask.getId());
        try {
            this._converterService.startConversion(conversionTask);
            this.context().commit();
        }
        catch (IOException e) {
            LOG.error("The message for preview id '" + conversionTask.getId() + "' caused an exception and is not committed to Kafka. Fix the underlying problem or shift the offset in Kafka manually.", (Throwable)e);
        }
    }

    public void close() {
        try {
            super.close();
        }
        catch (RuntimeException e) {
            LOG.error("Error when closing the kafka stream context.", (Throwable)e);
        }
    }
}

