/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.kafka;

import de.justsoftware.judo.kafka.KafkaConfiguration;
import de.justsoftware.judoclient.conversionstatus.ConversionStatusClient;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducerImpl;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ParametersAreNonnullByDefault
public class KafkaConfiguration {
    @Value(value="${kafka.bootstrapServers:}")
    private String _bootstrapServers;

    @Bean(destroyMethod="close")
    @Nonnull
    public KafkaCleaningProducer<String, String> kafkaCleaningProducer() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("acks", "all");
        props.put("retries", (Object)0);
        props.put("batch.size", (Object)16384);
        props.put("linger.ms", (Object)1);
        props.put("buffer.memory", (Object)0x2000000);
        1 delegate = new /* Unavailable Anonymous Inner Class!! */;
        return new KafkaCleaningProducerImpl((Producer)delegate, arg_0 -> this.createCleaningConsumer(arg_0));
    }

    @Nonnull
    private Consumer<String, ?> createCleaningConsumer(TopicPartition tp) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this._bootstrapServers);
        props.put("enable.auto.commit", "false");
        props.put("auto.offset.reset", "earliest");
        props.put("max.poll.records", (Object)100);
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)props);
    }

    @Bean
    @Nonnull
    public ConversionStatusClient conversionStatusClient(KafkaCleaningProducer<String, String> kafkaProducer) {
        return new ConversionStatusClient(kafkaProducer);
    }
}

