/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.persistence.impl;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionLog;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionLogEntry;
import de.justsoftware.jdoc.model.persistence.conversion.ConversionRequest;
import de.justsoftware.jdoc.services.exceptions.DirectoryCreateFailedException;
import de.justsoftware.jdoc.services.exceptions.DocumentRepositoryPersistenceException;
import de.justsoftware.jdoc.services.monitoring.MonitoredService;
import de.justsoftware.jdoc.services.monitoring.model.HeartbeatStatus;
import de.justsoftware.jdoc.services.persistence.DocumentConversionDAO;
import de.justsoftware.jdoc.services.persistence.impl.FilesystemDAO;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FilesystemConversionDAO
implements DocumentConversionDAO,
MonitoredService,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesystemConversionDAO.class);
    private static final FileFilter JUST_FILES = FileFileFilter.FILE;
    private static final String CONVERSION_LOG_FILE_NAME = "log.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final FilesystemDAO _fs;
    private HeartbeatStatus _serviceStatus;

    @Autowired
    public FilesystemConversionDAO(FilesystemDAO fs) {
        this._fs = fs;
        this._serviceStatus = HeartbeatStatus.OK;
    }

    public void afterPropertiesSet() {
        this._fs.deleteProcessingFolder();
    }

    public HeartbeatStatus getStatus() {
        return this._serviceStatus;
    }

    public String getName() {
        return "Conversion Storage";
    }

    public DocumentStatus getDocumentStatus(DocumentType type, DocumentId documentId) {
        File statusFolder = this._fs.getStatusFolder(documentId, type);
        if (statusFolder.exists()) {
            return this.getDocumentStatusFromStatusFolder(type, documentId, statusFolder);
        }
        return DocumentStatus.NOT_PRESENT;
    }

    @Nonnull
    private DocumentStatus getDocumentStatusFromStatusFolder(DocumentType type, DocumentId documentId, File statusFolder) {
        File[] statusList = statusFolder.listFiles(JUST_FILES);
        if (statusList != null && statusList.length == 1) {
            try {
                return DocumentStatus.valueOf((String)statusList[0].getName());
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LOGGER.error("found unexpected status file:" + statusList[0]);
            }
        } else {
            LOGGER.error("found unexpected status folder content");
        }
        this.setDocumentStatus(type, documentId, DocumentStatus.ERROR);
        return DocumentStatus.ERROR;
    }

    @Nonnull
    private File getStatusFile(DocumentId documentId, DocumentType type, DocumentStatus status) {
        return this._fs.getFile(this._fs.getStatusFolder(documentId, type), status.name());
    }

    public void setDocumentStatus(DocumentType type, DocumentId documentId, DocumentStatus status) {
        this._fs.deleteStatusFolder(documentId, type);
        try {
            FileUtils.writeStringToFile((File)this.getStatusFile(documentId, type, status), (String)"status file", (String)Charsets.UTF_8.name(), (boolean)false);
        }
        catch (IOException fsError) {
            LOGGER.warn("could not update status of document {}, write failed!", (Object)documentId, (Object)fsError);
            this._fs.deleteStatusFolder(documentId, type);
        }
    }

    public void addConversionLogStatus(DocumentType sourceType, DocumentType targetType, DocumentId documentId, DocumentStatus status, String converterName, String converterVersion) {
        this.writeConversionLog(documentId, this.getConversionLog(documentId).add(new ConversionLogEntry(sourceType, targetType, System.currentTimeMillis(), status, converterName, converterVersion)));
    }

    private void writeConversionLog(DocumentId documentId, ConversionLog conversionLog) {
        try {
            this.writeConversionLog(this.getConversionLogFile(documentId), conversionLog);
        }
        catch (DirectoryCreateFailedException e) {
            throw new DocumentRepositoryPersistenceException((Throwable)e);
        }
    }

    public ConversionLog getConversionLog(DocumentId documentId) {
        try {
            return this.getConversionLog(this.getConversionLogFile(documentId));
        }
        catch (DirectoryCreateFailedException e) {
            throw new DocumentRepositoryPersistenceException((Throwable)e);
        }
    }

    public void resetConversionLogStatus(DocumentType targetType, DocumentId documentId) {
        this.writeConversionLog(documentId, new ConversionLog((List)FluentIterable.from((Iterable)this.getConversionLog(documentId).getLog()).filter(Predicates.not((Predicate)ConversionLogEntry.composeTargetFilter((DocumentType)targetType))).toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeConversionLog(File conversionLogFile, ConversionLog conversionLog) {
        try {
            ObjectMapper objectMapper = MAPPER;
            synchronized (objectMapper) {
                MAPPER.writeValue(conversionLogFile, (Object)conversionLog);
            }
            this._serviceStatus = HeartbeatStatus.OK;
            return true;
        }
        catch (JsonGenerationException e) {
            LOGGER.error("json couldn't be created and written to " + conversionLogFile.getAbsolutePath() + ", this is odd!", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        catch (JsonMappingException e) {
            LOGGER.error("json couldn't be created and written to " + conversionLogFile.getAbsolutePath() + ", the mapping is incomplete!", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        catch (IOException e) {
            LOGGER.error("io error while writing to " + conversionLogFile.getAbsolutePath(), (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        this._fs.deleteIfExists(conversionLogFile);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private ConversionLog getConversionLog(File conversionLogFile) {
        if (this._fs.checkFileExists(conversionLogFile)) {
            try {
                ObjectMapper objectMapper = MAPPER;
                synchronized (objectMapper) {
                    ConversionLog log = (ConversionLog)MAPPER.readValue(conversionLogFile, ConversionLog.class);
                    this._serviceStatus = HeartbeatStatus.OK;
                    return log;
                }
            }
            catch (JsonParseException e) {
                LOGGER.error("json couldn't be parsed from " + conversionLogFile.getAbsolutePath() + ", this is odd!", (Throwable)e);
                this._serviceStatus = HeartbeatStatus.ERROR;
            }
            catch (JsonMappingException e) {
                LOGGER.error("json couldn't be parsed from " + conversionLogFile.getAbsolutePath() + ", mapping is not compatible!", (Throwable)e);
                this._serviceStatus = HeartbeatStatus.ERROR;
            }
            catch (IOException e) {
                LOGGER.error("io error while access of " + conversionLogFile.getAbsolutePath(), (Throwable)e);
                this._serviceStatus = HeartbeatStatus.ERROR;
            }
            this._fs.deleteIfExists(conversionLogFile);
        }
        return new ConversionLog((List)ImmutableList.of());
    }

    @Nonnull
    private File getConversionLogFile(DocumentId documentId) throws DirectoryCreateFailedException {
        return new File(this._fs.getOrCreateStatusFolder(documentId), CONVERSION_LOG_FILE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConversionRequest(ConversionRequest conversionRequest) {
        DocumentId documentId = conversionRequest.getDocumentId();
        File queueFile = this._fs.getFile(this._fs.getQueueFolder(), documentId.toString());
        if (queueFile.exists()) {
            return true;
        }
        try {
            ObjectMapper objectMapper = MAPPER;
            synchronized (objectMapper) {
                MAPPER.writeValue(queueFile, (Object)conversionRequest);
            }
            this._serviceStatus = HeartbeatStatus.OK;
            return true;
        }
        catch (JsonGenerationException e) {
            LOGGER.error("json couldn't be created and written to " + queueFile.getAbsolutePath() + ", this is odd!", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        catch (JsonMappingException e) {
            LOGGER.error("json couldn't be created and written to " + queueFile.getAbsolutePath() + ", the mapping is incomplete!", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        catch (IOException e) {
            LOGGER.error("io error while writing to " + queueFile.getAbsolutePath(), (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private ConversionRequest parseConversion(File file) {
        try {
            ObjectMapper objectMapper = MAPPER;
            synchronized (objectMapper) {
                return (ConversionRequest)MAPPER.readValue(file, ConversionRequest.class);
            }
        }
        catch (JsonParseException e) {
            LOGGER.error("json couldn't be parsed from " + file + ", this is odd!", (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOGGER.error("json couldn't be parsed from " + file + ", mapping is not compatible!", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.trace("another queue worker accepted the request " + file + " already.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            LOGGER.error("io error while access of " + file, (Throwable)e);
        }
        this._serviceStatus = HeartbeatStatus.ERROR;
        this._fs.deleteIfExists(file);
        return null;
    }

    public ConversionRequest pullConversionRequest() {
        File[] queued = this._fs.getQueueFolder().listFiles();
        if (queued == null || queued.length == 0) {
            this._serviceStatus = HeartbeatStatus.OK;
            return null;
        }
        Iterable files = Stream.of(queued).sorted(Comparator.comparing(File::lastModified))::iterator;
        HashMap<File, ConversionRequest> conversationRequests = new HashMap<File, ConversionRequest>();
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                this._fs.deleteIfExists(file);
                continue;
            }
            ConversionRequest request = this.parseConversion(file);
            if (request != null && request.getAttemptCount() == 0) {
                return this.conversionRequestFound(file, request);
            }
            conversationRequests.put(file, request);
        }
        Iterable results = conversationRequests.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue, Comparator.comparing(ConversionRequest::getAttemptCount).thenComparing(ConversionRequest::getTimestamp)))::iterator;
        for (Map.Entry e : results) {
            File file = (File)e.getKey();
            if (!file.exists()) continue;
            return this.conversionRequestFound(file, (ConversionRequest)e.getValue());
        }
        return null;
    }

    @Nonnull
    private ConversionRequest conversionRequestFound(File file, ConversionRequest request) {
        this._fs.deleteIfExists(file);
        this._serviceStatus = HeartbeatStatus.OK;
        return request;
    }

    public void resetConversionRequestQueue() {
        this._fs.deleteQueueFolder();
    }

    public boolean hasConversionRequest() {
        return this.getFileCount(this._fs.getQueueFolder()) > 0;
    }

    private int getFileCount(File folder) {
        File[] listFiles = folder.listFiles();
        return listFiles != null ? listFiles.length : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markConversionRequestInProgress(ConversionRequest conversionRequest) {
        DocumentId documentId = conversionRequest.getDocumentId();
        File processingFile = this._fs.getFile(this._fs.getProcessingFolder(), documentId.toString());
        try {
            ObjectMapper objectMapper = MAPPER;
            synchronized (objectMapper) {
                MAPPER.writeValue(processingFile, (Object)conversionRequest);
            }
            this._serviceStatus = HeartbeatStatus.OK;
        }
        catch (JsonGenerationException e) {
            LOGGER.error("json couldn't be created and written to " + processingFile.getAbsolutePath() + ", this is odd!", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        catch (JsonMappingException e) {
            LOGGER.error("json couldn't be created and written to " + processingFile.getAbsolutePath() + ", the mapping is incomplete!", (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
        catch (IOException e) {
            LOGGER.error("io error while writing to " + processingFile.getAbsolutePath(), (Throwable)e);
            this._serviceStatus = HeartbeatStatus.ERROR;
        }
    }

    public void markConversionRequestDone(ConversionRequest conversionRequest) {
        DocumentId documentId = conversionRequest.getDocumentId();
        File processingFile = this._fs.getFile(this._fs.getProcessingFolder(), documentId.toString());
        if (processingFile.exists()) {
            this._fs.deleteIfExists(processingFile);
        }
    }
}

