/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services.business.impl;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentInfo;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import de.justsoftware.jdoc.services.business.DocumentConversionService;
import de.justsoftware.jdoc.services.business.DocumentService;
import de.justsoftware.jdoc.services.exceptions.DocumentNotFoundException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadException;
import de.justsoftware.jdoc.services.exceptions.DocumentReadWriteException;
import de.justsoftware.jdoc.services.exceptions.DocumentResourceNotFoundException;
import de.justsoftware.jdoc.services.persistence.DocumentRepository;
import de.justsoftware.jdoc.util.streams.DocumentInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class DocumentServiceImpl
implements DocumentService {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentServiceImpl.class);
    private final DocumentRepository _repository;
    private final DocumentConversionService _conversionService;

    @Autowired
    public DocumentServiceImpl(DocumentRepository repository, DocumentConversionService conversionService) {
        this._repository = repository;
        this._conversionService = conversionService;
    }

    public boolean hasDocument(DocumentType type, DocumentId documentId) {
        return this._repository.hasDocument(type, documentId);
    }

    public long getDocumentSize(DocumentType type, DocumentId documentId) {
        return this._repository.getDocumentSize(type, documentId);
    }

    public DocumentInputStream getDocumentStream(DocumentId documentId, DocumentType type) throws DocumentNotFoundException, DocumentReadException, DocumentResourceNotFoundException {
        return this._repository.readDocument(type, documentId);
    }

    public DocumentInputStream getDocumentResourceStream(DocumentId documentId, DocumentType type, String relativeResourceName) throws DocumentNotFoundException, DocumentResourceNotFoundException, DocumentReadException {
        return this._repository.readDocumentResource(type, documentId, relativeResourceName);
    }

    public void createDocument(DocumentId documentId) throws DocumentReadWriteException {
        this._repository.createDocument(documentId);
        LOG.debug("document created : " + documentId);
    }

    public void createDocumentFromUpload(DocumentId documentId, DocumentType type, DocumentInputStream documentStream) throws DocumentReadWriteException {
        this._repository.writeDocument(type, documentId, documentStream);
        LOG.debug("document uploaded : " + documentId + " (" + type + ")");
        this._conversionService.setDocumentStatus(type, documentId, DocumentStatus.PRESENT);
    }

    public void createDocumentFromDownload(DocumentId documentId, DocumentType type, URL documentUrl) throws DocumentReadWriteException {
        DocumentInputStream documentStream = null;
        try {
            URLConnection connection = documentUrl.openConnection();
            documentStream = new DocumentInputStream(connection.getInputStream(), (long)connection.getContentLength(), "application/octet-stream");
            this.createDocumentFromUpload(documentId, type, documentStream);
        }
        catch (IOException e) {
            try {
                throw new DocumentReadWriteException("could not download document " + documentId + " from " + documentUrl, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(documentStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)documentStream);
    }

    public DocumentInfo getDocumentInfo(DocumentId documentId) {
        ImmutableMap.Builder documentStatusBuilder = ImmutableMap.builder();
        for (DocumentType type : DocumentType.values()) {
            documentStatusBuilder.put((Object)type, (Object)this._conversionService.getDocumentStatus(type, documentId));
        }
        return new DocumentInfo(documentId, documentStatusBuilder.build());
    }

    public DocumentId deleteDocument(DocumentId documentId) throws DocumentNotFoundException, DocumentReadWriteException {
        this._repository.deleteDocument(documentId);
        LOG.debug("document deleted : " + documentId);
        return documentId;
    }

    public Iterable<DocumentInfo> getAllDocumentInfos() {
        return FluentIterable.from((Iterable)this._repository.getAllDocumentIds()).transform(arg_0 -> this.getDocumentInfo(arg_0)).filter(Predicates.notNull());
    }

    public long getDocumentCount() {
        return this._repository.getDocumentCount();
    }
}

