/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.services;

import de.justsoftware.jdoc.services.exceptions.DirectoryCreateFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class TempFileService
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFileService.class);
    private final String _tempDirectoryPath;

    public TempFileService(@Value(value="${judo.tmpDir}") String tempDirectoryPath) {
        this._tempDirectoryPath = tempDirectoryPath;
    }

    @Nonnull
    public File createTempDirectory() throws DirectoryCreateFailedException {
        Path tempDir = Paths.get(this._tempDirectoryPath, "jdoc", new SimpleDateFormat("yyyy-MM-dd").format(new Date()), UUID.randomUUID().toString());
        try {
            return Files.createDirectories(tempDir, new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new DirectoryCreateFailedException("can't create temporary folder " + tempDir.toAbsolutePath());
        }
    }

    public void cleanupTempDirectory(@Nullable File tempDir) {
        block3: {
            if (tempDir != null && tempDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)tempDir);
                }
                catch (IOException e) {
                    if (FileUtils.deleteQuietly((File)tempDir)) break block3;
                    tempDir.deleteOnExit();
                }
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Path path = Paths.get(this._tempDirectoryPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.info("tmp directory does not exist, trying to create: {}", (Object)path.toString());
            Files.createDirectories(path, new FileAttribute[0]);
            LOGGER.info("creation successfull");
        }
    }
}

