/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.presentation;

import de.justsoftware.jdoc.rest.exceptions.DocumentRepositoryAPIException;
import de.justsoftware.jdoc.rest.model.message.BasicErrorResponse;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@ParametersAreNonnullByDefault
public class DocumentExceptionHandler
extends ResponseEntityExceptionHandler {
    @Nonnull
    private ResponseEntity<BasicErrorResponse> createErrorResponseEntity(HttpStatus status, String message) {
        return new ResponseEntity((Object)new BasicErrorResponse(message), status);
    }

    @Nonnull
    @ExceptionHandler(value={DocumentRepositoryAPIException.class})
    public ResponseEntity<BasicErrorResponse> handleAPIException(DocumentRepositoryAPIException ex) {
        return this.createErrorResponseEntity(HttpStatus.BAD_REQUEST, ex.getMessage());
    }

    @Nonnull
    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<BasicErrorResponse> handleGenericRuntimeException(RuntimeException re) {
        return this.createErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, "Invalid exception handling for error : " + re.getMessage());
    }

    @Nonnull
    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<BasicErrorResponse> handleGenericException(Exception e) {
        return this.createErrorResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR, "Invalid exception handling for error : " + e.getMessage());
    }
}

