/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.jdoc.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.jdoc.model.DocumentId;
import de.justsoftware.jdoc.model.DocumentStatus;
import de.justsoftware.jdoc.model.DocumentType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DocumentInfo {
    private final DocumentId _documentId;
    private final ImmutableMap<DocumentType, DocumentStatus> _documentStatus;

    public DocumentInfo(DocumentId documentId, ImmutableMap<DocumentType, DocumentStatus> documentStatus) {
        this._documentId = documentId;
        this._documentStatus = documentStatus;
    }

    @Nonnull
    public DocumentId getDocumentId() {
        return this._documentId;
    }

    @Nonnull
    public ImmutableMap<DocumentType, DocumentStatus> getDocumentStatus() {
        return this._documentStatus;
    }

    @Nonnull
    public DocumentStatus getDocumentStatus(DocumentType type) {
        return (DocumentStatus)MoreObjects.firstNonNull((Object)((DocumentStatus)this.getDocumentStatus().get((Object)type)), (Object)DocumentStatus.NOT_PRESENT);
    }

    public boolean allStatusPresent() {
        for (DocumentType type : DocumentType.values()) {
            if (DocumentStatus.PRESENT.equals((Object)this.getDocumentStatus(type))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("documentId", (Object)this._documentId).add("documentStatus", (Object)this._documentStatus).toString();
    }
}

