/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.util;

import de.justsoftware.chat.business.model.drive.MultipartFileResource;
import de.justsoftware.chat.exception.NotFoundException;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestOperations;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriComponentsBuilder;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a'\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u001a(\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u001a\u001f\u0010\u0010\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\u00110\u0012\u00a2\u0006\u0002\u0010\u0013\u001a'\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0012\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u000b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0001H\u0086\b\u001a'\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0012\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u000b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\b\u001a3\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0012\"\n\b\u0000\u0010\u0011\u0018\u0001*\u00020\u000b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0086\b\u00a8\u0006\u0019"}, d2={"buildUri", "Ljava/net/URI;", "baseUrl", "", "config", "Lkotlin/Function1;", "Lorg/springframework/web/util/UriComponentsBuilder;", "", "Lkotlin/ExtensionFunctionType;", "createMultipartPayload", "Lorg/springframework/util/MultiValueMap;", "", "name", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "bodyOrNotFound", "T", "Lorg/springframework/http/ResponseEntity;", "(Lorg/springframework/http/ResponseEntity;)Ljava/lang/Object;", "get", "Lorg/springframework/web/client/RestOperations;", "url", "post", "data", "chat-service"})
public final class RestOperationsUtilsKt {
    public static final /* synthetic */ <T> ResponseEntity<T> get(RestOperations $this$get, String url) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean $i$f$get = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        ResponseEntity responseEntity = $this$get.getForEntity(url, Object.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"getForEntity(url, T::class.java)");
        return responseEntity;
    }

    public static final /* synthetic */ <T> ResponseEntity<T> get(RestOperations $this$get, URI url) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean $i$f$get = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        ResponseEntity responseEntity = $this$get.getForEntity(url, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"getForEntity(url, T::class.java)");
        return responseEntity;
    }

    public static final /* synthetic */ <T> ResponseEntity<T> post(RestOperations $this$post, String url, Object data) {
        Intrinsics.checkNotNullParameter((Object)$this$post, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean $i$f$post = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        ResponseEntity responseEntity = $this$post.postForEntity(url, data, Object.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"postForEntity(url, data, T::class.java)");
        return responseEntity;
    }

    public static /* synthetic */ ResponseEntity post$default(RestOperations $this$post_u24default, String url, Object data, int n, Object object) {
        if ((n & 2) != 0) {
            data = null;
        }
        Intrinsics.checkNotNullParameter((Object)$this$post_u24default, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean $i$f$post = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        ResponseEntity responseEntity = $this$post_u24default.postForEntity(url, data, Object.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"postForEntity(url, data, T::class.java)");
        return responseEntity;
    }

    @NotNull
    public static final <T> T bodyOrNotFound(@NotNull ResponseEntity<T> $this$bodyOrNotFound) {
        Intrinsics.checkNotNullParameter($this$bodyOrNotFound, (String)"<this>");
        Object object = $this$bodyOrNotFound.getBody();
        if (object == null) {
            throw new NotFoundException("Empty response body");
        }
        return (T)object;
    }

    @NotNull
    public static final URI buildUri(@NotNull String baseUrl, @NotNull Function1<? super UriComponentsBuilder, Unit> config) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter(config, (String)"config");
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)baseUrl);
        config.invoke((Object)uriComponentsBuilder);
        URI uRI = uriComponentsBuilder.build().toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"fromHttpUrl(baseUrl).apply(config).build().toUri()");
        return uRI;
    }

    @NotNull
    public static final MultiValueMap<String, Object> createMultipartPayload(@NotNull String name, @NotNull List<? extends MultipartFile> files) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        MultiValueMap postData = (MultiValueMap)new LinkedMultiValueMap();
        Iterable $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HttpHeaders httpHeaders;
            MultipartFile file = (MultipartFile)element$iv;
            boolean bl = false;
            HttpHeaders $this$createMultipartPayload_u24lambda_u2d1_u24lambda_u2d0 = httpHeaders = new HttpHeaders();
            boolean bl2 = false;
            if (file.getContentType() != null) {
                $this$createMultipartPayload_u24lambda_u2d1_u24lambda_u2d0.set("Content-Type", file.getContentType());
            }
            HttpHeaders headers = httpHeaders;
            postData.add((Object)name, (Object)new HttpEntity((Object)new MultipartFileResource(file), (MultiValueMap)headers));
        }
        return postData;
    }
}

