/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.kafka.search.UpdateCommonSearchIndexProducer;
import de.justsoftware.chat.kafka.search.UpdateCommonSearchIndexType;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.CommonCoreSearchModelType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 12\u00020\u0001:\u000212B?\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b0\u001aH\u0016J(\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#H\u0012J.\u0010%\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#2\u0018\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b0\u001aH\u0012J.\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0\u001a0#2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u001d0#H\u0012J\b\u0010(\u001a\u00020\u0018H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u001a\u0010*\u001a\u00020\u0018*\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001aH\u0012J\u001a\u0010-\u001a\u00020\u0018*\u00020\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001aH\u0012J\u001a\u0010.\u001a\u00020\u0018*\u00020\u00122\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u001aH\u0012J\u001a\u00100\u001a\u00020\u0018*\u00020\u00122\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 0\u001aH\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u00020\u00128\u0010X\u0091\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/chat/search/SolrIndexService;", "", "commonCoreLeaderSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "updateCommonSearchIndexProducer", "Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexProducer;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/permission/client/rest/PermissionRequestConnector;Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexProducer;Lio/micrometer/core/instrument/MeterRegistry;)V", "commonSolrCore", "Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "getCommonSolrCore$chat_service$annotations", "()V", "getCommonSolrCore$chat_service", "()Lde/justsoftware/chat/search/SolrIndexService$SolrCore;", "indexChatInCommonCore", "", "indexInstructions", "", "Lkotlin/Pair;", "Lde/justsoftware/chat/model/ChatId;", "Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexType;", "loadChatPermissions", "Lcom/google/common/collect/ImmutableSetMultimap;", "", "Lde/justsoftware/permission/client/model/Role;", "optimizedInstruction", "", "Lde/justsoftware/chat/business/model/Chat;", "loadChatsAndOptimizeInstructions", "loadOneOnOneChatPartners", "Lde/justsoftware/chat/business/model/Profile;", "reindexAll", "reindexChatsInCommonCore", "addSolrDocuments", "documents", "Lorg/apache/solr/common/SolrInputDocument;", "addSolrDocumentsIndividually", "deleteSolrDocuments", "ids", "deleteSolrDocumentsIndividually", "Companion", "SolrCore", "chat-service"})
public class SolrIndexService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient commonCoreLeaderSolrClient;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;
    @NotNull
    private final UpdateCommonSearchIndexProducer updateCommonSearchIndexProducer;
    @NotNull
    private final SolrCore commonSolrCore;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String CHAT_APP_ID = "CHAT";

    public SolrIndexService(@Qualifier(value="commonCoreLeaderSolrClient") @NotNull SolrClient commonCoreLeaderSolrClient, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ProfileService profileService, @NotNull PermissionRequestConnector permissionRequestConnector, @NotNull UpdateCommonSearchIndexProducer updateCommonSearchIndexProducer, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)commonCoreLeaderSolrClient, (String)"commonCoreLeaderSolrClient");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        Intrinsics.checkNotNullParameter((Object)updateCommonSearchIndexProducer, (String)"updateCommonSearchIndexProducer");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.commonCoreLeaderSolrClient = commonCoreLeaderSolrClient;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.profileService = profileService;
        this.permissionRequestConnector = permissionRequestConnector;
        this.updateCommonSearchIndexProducer = updateCommonSearchIndexProducer;
        this.commonSolrCore = new SolrCore("common", this.commonCoreLeaderSolrClient, meterRegistry);
    }

    @NotNull
    public SolrCore getCommonSolrCore$chat_service() {
        return this.commonSolrCore;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCommonSolrCore$chat_service$annotations() {
    }

    public void reindexAll() {
        this.commonCoreLeaderSolrClient.deleteByQuery("just_app_id:CHAT");
        this.reindexChatsInCommonCore();
    }

    public void reindexChatsInCommonCore() {
        this.commonCoreLeaderSolrClient.deleteByQuery("type:" + CommonCoreSearchModelType.CHAT.name());
        this.updateCommonSearchIndexProducer.fullIndex(this.chatService.findAllIds());
    }

    /*
     * WARNING - void declaration
     */
    public void indexChatInCommonCore(@NotNull List<? extends Pair<ChatId, ? extends UpdateCommonSearchIndexType>> indexInstructions) {
        Collection<SolrInputDocument> collection;
        Map $this$map$iv;
        ChatId p0;
        boolean bl;
        Collection collection2;
        Object object;
        Map $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv;
        Collection collection3;
        Object item$iv$iv222;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(indexInstructions, (String)"indexInstructions");
        if (indexInstructions.isEmpty()) {
            return;
        }
        Iterable $this$mapToSet$iv2 = indexInstructions;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv2;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo232 = false;
        for (Object item$iv$iv222 : $this$mapTo$iv$iv2) {
            Pair pair = (Pair)item$iv$iv222;
            collection3 = destination$iv$iv;
            boolean bl2 = false;
            ChatId chatId = (ChatId)pair.component1();
            collection3.add(chatId);
        }
        Set chatIds = (Set)destination$iv$iv;
        Map optimizedInstructions = this.loadChatsAndOptimizeInstructions(indexInstructions);
        ImmutableSetMultimap permissions = this.loadChatPermissions(optimizedInstructions);
        Map chatPartners = this.loadOneOnOneChatPartners(optimizedInstructions);
        Iterable $i$f$mapTo232 = optimizedInstructions.keySet();
        collection3 = chatIds;
        boolean $i$f$mapToSet2 = false;
        item$iv$iv222 = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            object = (Chat)t;
            collection2 = destination$iv$iv2;
            bl = false;
            collection2.add(p0.getId());
        }
        Set idsToDeleted = SetsKt.minus((Set)collection3, (Iterable)((Set)destination$iv$iv2));
        $this$mapToSet$iv = idsToDeleted;
        collection2 = this.getCommonSolrCore$chat_service();
        collection3 = this;
        boolean $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            p0 = (ChatId)t;
            collection = destination$iv$iv3;
            bl = false;
            collection.add((SolrInputDocument)p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv3;
        super.deleteSolrDocuments((SolrCore)collection2, (List)collection);
        $this$map$iv = optimizedInstructions;
        collection2 = this.getCommonSolrCore$chat_service();
        collection3 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            SolrInputDocument solrInputDocument;
            object = entry;
            collection = destination$iv$iv3;
            bl = false;
            Chat chat = (Chat)object.getKey();
            UpdateCommonSearchIndexType type = (UpdateCommonSearchIndexType)object.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    List list = (List)chatPartners.get(chat.getId());
                    ImmutableSet immutableSet = permissions.get((Object)chat.getId().toPermissionItemId());
                    Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"permissions[chat.id.toPermissionItemId()]");
                    solrInputDocument = Companion.access$toFullIndexSolrDocument((Companion)Companion, (Chat)chat, (List)list, (Set)((Set)immutableSet));
                    break;
                }
                case 2: {
                    solrInputDocument = Companion.access$toBaseDataUpdateSolrDocument((Companion)Companion, (Chat)chat, (List)((List)chatPartners.get(chat.getId())));
                    break;
                }
                case 3: {
                    ImmutableSet immutableSet = permissions.get((Object)chat.getId().toPermissionItemId());
                    Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"permissions[chat.id.toPermissionItemId()]");
                    solrInputDocument = Companion.access$toPermissionUpdateSolrDocument((Companion)Companion, (Chat)chat, (Set)((Set)immutableSet));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            collection.add(solrInputDocument);
        }
        collection = (List)destination$iv$iv3;
        super.addSolrDocuments((SolrCore)collection2, collection);
    }

    /*
     * WARNING - void declaration
     */
    private Map<Chat, UpdateCommonSearchIndexType> loadChatsAndOptimizeInstructions(List<? extends Pair<ChatId, ? extends UpdateCommonSearchIndexType>> indexInstructions) {
        Chat chat;
        void $this$filterTo$iv$iv;
        UpdateCommonSearchIndexType updateCommonSearchIndexType;
        Object object;
        Iterable $this$mapValuesTo$iv$iv;
        List list;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = indexInstructions;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            ChatId chatId;
            Object element$iv$iv = iterator.next();
            Pair pair = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SolrIndexService$loadChatsAndOptimizeInstructions$optimizedInstructions$32 = false;
            ChatId key$iv$iv = chatId = (ChatId)pair.component1();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            Pair $i$a$-groupBy-SolrIndexService$loadChatsAndOptimizeInstructions$optimizedInstructions$32 = (Pair)element$iv$iv;
            list = list$iv$iv;
            boolean bl = false;
            UpdateCommonSearchIndexType type = (UpdateCommonSearchIndexType)$i$a$-groupBy-SolrIndexService$loadChatsAndOptimizeInstructions$optimizedInstructions$32.component2();
            list.add(type);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = it$iv$iv.getKey();
            list = map;
            boolean bl3 = false;
            List types = (List)entry.getValue();
            Iterable $this$reduce$iv = types;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void p1;
                UpdateCommonSearchIndexType updateCommonSearchIndexType2 = (UpdateCommonSearchIndexType)iterator$iv.next();
                UpdateCommonSearchIndexType p0 = (UpdateCommonSearchIndexType)accumulator$iv;
                boolean bl4 = false;
                accumulator$iv = p0.getOptimizedType((UpdateCommonSearchIndexType)p1);
            }
            updateCommonSearchIndexType = (UpdateCommonSearchIndexType)accumulator$iv;
            list.put(object, updateCommonSearchIndexType);
        }
        Map optimizedInstructions = destination$iv$iv;
        Iterable $this$filter$iv = this.chatService.findByIds(optimizedInstructions.keySet()).values();
        boolean $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            chat = (Chat)element$iv$iv;
            boolean bl = false;
            if (!(!(chat instanceof OneOnOneChat) || chat.getLastMessageId() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            chat = (Chat)element$iv$iv;
            object = element$iv$iv;
            list = result$iv;
            boolean bl = false;
            updateCommonSearchIndexType = (UpdateCommonSearchIndexType)MapsKt.getValue((Map)optimizedInstructions, (Object)chat.getId());
            list.put(object, updateCommonSearchIndexType);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableSetMultimap<String, Role> loadChatPermissions(Map<Chat, ? extends UpdateCommonSearchIndexType> optimizedInstruction) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        Map<Chat, ? extends UpdateCommonSearchIndexType> $this$filter$iv = optimizedInstruction;
        boolean $i$f$filter = false;
        Map<Chat, ? extends UpdateCommonSearchIndexType> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl = false;
            UpdateCommonSearchIndexType type = (UpdateCommonSearchIndexType)entry.getValue();
            if (!type.getRequiredPermissions()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Chat chat = (Chat)entry.getKey();
            object.add(chat.getId().toPermissionItemId());
        }
        List itemsIds = (List)destination$iv$iv;
        boolean bl = false;
        ImmutableSetMultimap immutableSetMultimap = !((Collection)itemsIds).isEmpty() ? this.permissionRequestConnector.visibility((Iterable)itemsIds) : ImmutableSetMultimap.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"optimizedInstruction\n   \u2026          }\n            }");
        return immutableSetMultimap;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatId, List<Profile>> loadOneOnOneChatPartners(Map<Chat, ? extends UpdateCommonSearchIndexType> optimizedInstruction) {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        void $this$flatMapToSet$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Chat chat;
        Iterator iterator;
        Map $this$filterTo$iv$iv;
        Map<Chat, ? extends UpdateCommonSearchIndexType> $this$filter$iv = optimizedInstruction;
        boolean $i$f$filter = false;
        Map<Chat, ? extends UpdateCommonSearchIndexType> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
            iterator = element$iv$iv;
            boolean bl = false;
            chat = (Chat)iterator.getKey();
            UpdateCommonSearchIndexType type = (UpdateCommonSearchIndexType)iterator.getValue();
            if (!(chat instanceof OneOnOneChat && type.getRequiredBaseData())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapToSet$iv = destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$filterTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo22 = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            iterator = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            chat = (Chat)iterator.getKey();
            object.add(chat.getId());
        }
        Set oneOnOneChatIdsToLoad = (Set)destination$iv$iv;
        Map chatParticipantsByChatId = this.chatParticipantService.findByChatIds((Iterable)oneOnOneChatIdsToLoad);
        $this$mapTo$iv$iv = chatParticipantsByChatId.values();
        object = this.profileService;
        boolean $i$f$flatMapToSet = false;
        void $i$f$mapTo22 = $this$flatMapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            void $this$filterIsInstanceToSet$iv$iv;
            void $this$mapTo$iv$iv$iv;
            List participants = (List)element$iv$iv;
            boolean bl = false;
            ChatParticipant.Companion companion = ChatParticipant.Companion;
            Iterable $this$filterParticipantIds$iv = participants;
            boolean $i$f$filterParticipantIds = false;
            Iterable $this$map$iv$iv = $this$filterParticipantIds$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void p0$iv;
                ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                collection.add(p0$iv.getParticipantId());
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$filterIsInstanceToSet = false;
            $this$mapTo$iv$iv$iv = $this$filterIsInstanceToSet$iv$iv;
            destination$iv$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            list$iv$iv = (Set)destination$iv$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Map profilesById = object.findByIds((Set)destination$iv$iv2);
        Iterable $this$associateWith$iv = oneOnOneChatIdsToLoad;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void chatId;
            list$iv$iv = (ChatId)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            Iterable this_$iv = chatParticipantsByChatId.getOrDefault(chatId, CollectionsKt.emptyList());
            boolean $i$f$mapNotNull = false;
            void $i$f$filterParticipantIds = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Profile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl3 = false;
                ChatParticipant participant = (ChatParticipant)element$iv$iv2;
                boolean bl4 = false;
                if ((Profile)profilesById.get(participant.getParticipantId()) == null) continue;
                boolean bl5 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv3;
            object.put(t, list);
        }
        return result$iv;
    }

    private void addSolrDocuments(SolrCore $this$addSolrDocuments, List<? extends SolrInputDocument> documents) {
        if (documents.isEmpty()) {
            return;
        }
        try {
            $this$addSolrDocuments.getClient().add((Collection)documents);
            $this$addSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(documents.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch adding of " + documents.size() + " documents for solr core " + $this$addSolrDocuments.getCoreName() + " failed. Try to add documents individually.", (Throwable)e);
            this.addSolrDocumentsIndividually($this$addSolrDocuments, documents);
        }
    }

    private void addSolrDocumentsIndividually(SolrCore $this$addSolrDocumentsIndividually, List<? extends SolrInputDocument> documents) {
        Iterable $this$forEach$iv = documents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SolrInputDocument document = (SolrInputDocument)element$iv;
            boolean bl = false;
            try {
                $this$addSolrDocumentsIndividually.getClient().add(document);
                $this$addSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                SolrInputField solrInputField = (SolrInputField)document.get((Object)"id");
                LOG.error("Failed to index solr document for " + (solrInputField != null ? solrInputField.getValue() : null) + " in solr core " + $this$addSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$addSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    private void deleteSolrDocuments(SolrCore $this$deleteSolrDocuments, List<String> ids) {
        if (ids.isEmpty()) {
            return;
        }
        try {
            $this$deleteSolrDocuments.getClient().deleteById(ids);
            $this$deleteSolrDocuments.getSuccessfulIndexedDocumentCount().addAndGet(ids.size());
        }
        catch (SolrServerException e) {
            if (e.getCause() instanceof IOException) {
                throw e;
            }
            LOG.warn("Batch deletion of " + ids.size() + " documents for solr core " + $this$deleteSolrDocuments.getCoreName() + " failed. Try to delete documents individually.", (Throwable)e);
            this.deleteSolrDocumentsIndividually($this$deleteSolrDocuments, ids);
        }
    }

    private void deleteSolrDocumentsIndividually(SolrCore $this$deleteSolrDocumentsIndividually, List<String> ids) {
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl = false;
            try {
                $this$deleteSolrDocumentsIndividually.getClient().deleteById(id);
                $this$deleteSolrDocumentsIndividually.getSuccessfulIndexedDocumentCount().incrementAndGet();
            }
            catch (SolrServerException e) {
                if (e.getCause() instanceof IOException) {
                    throw e;
                }
                LOG.error("Failed to delete solr document " + id + " from solr core " + $this$deleteSolrDocumentsIndividually.getCoreName(), (Throwable)e);
                $this$deleteSolrDocumentsIndividually.getFailedIndexedDocumentCount().incrementAndGet();
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

