/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence.model;

import de.justsoftware.chat.model.ChatMessagePayload;
import de.justsoftware.chat.persistence.model.DbAuditModel;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import de.justsoftware.chat.serializer.ChatMessagePayloadConverter;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="ChatMessage")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0097\b\u0018\u0000 72\u00020\u0001:\u00017BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010*\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010+\u001a\u00020\bH\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0003JY\u0010/\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u00c6\u0001J\u0013\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J\t\u00106\u001a\u00020\u0006H\u00d6\u0001R$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0015\"\u0004\b\u001f\u0010\u0017R\u001e\u0010\u0007\u001a\u00020\b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R \u0010\n\u001a\u0004\u0018\u00010\u000b8\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u00068"}, d2={"Lde/justsoftware/chat/persistence/model/DbChatMessage;", "Lde/justsoftware/chat/persistence/model/DbAuditModel;", "id", "Ljava/util/UUID;", "chatId", "message", "", "messageType", "Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;", "author", "payload", "Lde/justsoftware/chat/model/ChatMessagePayload;", "attachments", "", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/lang/String;Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;Ljava/lang/String;Lde/justsoftware/chat/model/ChatMessagePayload;Ljava/util/List;)V", "getAttachments", "()Ljava/util/List;", "setAttachments", "(Ljava/util/List;)V", "getAuthor", "()Ljava/lang/String;", "setAuthor", "(Ljava/lang/String;)V", "getChatId", "()Ljava/util/UUID;", "setChatId", "(Ljava/util/UUID;)V", "getId", "setId", "getMessage", "setMessage", "getMessageType", "()Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;", "setMessageType", "(Lde/justsoftware/chat/persistence/model/DbChatMessage$Companion$ChatMessageType;)V", "getPayload", "()Lde/justsoftware/chat/model/ChatMessagePayload;", "setPayload", "(Lde/justsoftware/chat/model/ChatMessagePayload;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "chat-service"})
public class DbChatMessage
extends DbAuditModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @NotNull
    private UUID id;
    @NotNull
    private UUID chatId;
    @Nullable
    private String message;
    @Enumerated(value=EnumType.STRING)
    @NotNull
    private Companion.ChatMessageType messageType;
    @NotNull
    private String author;
    @Convert(converter=ChatMessagePayloadConverter.class)
    @Nullable
    private ChatMessagePayload payload;
    @OneToMany(targetEntity=DbChatMessageAttachment.class, cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="chatMessage", orphanRemoval=true)
    @NotNull
    private List<? extends DbChatMessageAttachment> attachments;

    public DbChatMessage(@NotNull UUID id, @NotNull UUID chatId, @Nullable String message2, @NotNull Companion.ChatMessageType messageType2, @NotNull String author, @Nullable ChatMessagePayload payload2, @NotNull List<? extends DbChatMessageAttachment> attachments) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)messageType2, (String)"messageType");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        this.id = id;
        this.chatId = chatId;
        this.message = message2;
        this.messageType = messageType2;
        this.author = author;
        this.payload = payload2;
        this.attachments = attachments;
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    public void setId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.id = uUID;
    }

    @NotNull
    public UUID getChatId() {
        return this.chatId;
    }

    public void setChatId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.chatId = uUID;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String string2) {
        this.message = string2;
    }

    @NotNull
    public Companion.ChatMessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(@NotNull Companion.ChatMessageType chatMessageType) {
        Intrinsics.checkNotNullParameter((Object)chatMessageType, (String)"<set-?>");
        this.messageType = chatMessageType;
    }

    @NotNull
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.author = string2;
    }

    @Nullable
    public ChatMessagePayload getPayload() {
        return this.payload;
    }

    public void setPayload(@Nullable ChatMessagePayload chatMessagePayload) {
        this.payload = chatMessagePayload;
    }

    @NotNull
    public List<DbChatMessageAttachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(@NotNull List<? extends DbChatMessageAttachment> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.attachments = list;
    }

    @NotNull
    public final UUID component1() {
        return this.getId();
    }

    @NotNull
    public final UUID component2() {
        return this.getChatId();
    }

    @Nullable
    public final String component3() {
        return this.getMessage();
    }

    @NotNull
    public final Companion.ChatMessageType component4() {
        return this.getMessageType();
    }

    @NotNull
    public final String component5() {
        return this.getAuthor();
    }

    @Nullable
    public final ChatMessagePayload component6() {
        return this.getPayload();
    }

    @NotNull
    public final List<DbChatMessageAttachment> component7() {
        return this.getAttachments();
    }

    @NotNull
    public final DbChatMessage copy(@NotNull UUID id, @NotNull UUID chatId, @Nullable String message2, @NotNull Companion.ChatMessageType messageType2, @NotNull String author, @Nullable ChatMessagePayload payload2, @NotNull List<? extends DbChatMessageAttachment> attachments) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)messageType2, (String)"messageType");
        Intrinsics.checkNotNullParameter((Object)author, (String)"author");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        return new DbChatMessage(id, chatId, message2, messageType2, author, payload2, attachments);
    }

    public static /* synthetic */ DbChatMessage copy$default(DbChatMessage dbChatMessage, UUID uUID, UUID uUID2, String string2, Companion.ChatMessageType chatMessageType, String string3, ChatMessagePayload chatMessagePayload, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
        }
        if ((n & 1) != 0) {
            uUID = dbChatMessage.getId();
        }
        if ((n & 2) != 0) {
            uUID2 = dbChatMessage.getChatId();
        }
        if ((n & 4) != 0) {
            string2 = dbChatMessage.getMessage();
        }
        if ((n & 8) != 0) {
            chatMessageType = dbChatMessage.getMessageType();
        }
        if ((n & 0x10) != 0) {
            string3 = dbChatMessage.getAuthor();
        }
        if ((n & 0x20) != 0) {
            chatMessagePayload = dbChatMessage.getPayload();
        }
        if ((n & 0x40) != 0) {
            list = dbChatMessage.getAttachments();
        }
        return dbChatMessage.copy(uUID, uUID2, string2, chatMessageType, string3, chatMessagePayload, list);
    }

    @NotNull
    public String toString() {
        return "DbChatMessage(id=" + this.getId() + ", chatId=" + this.getChatId() + ", message=" + this.getMessage() + ", messageType=" + this.getMessageType() + ", author=" + this.getAuthor() + ", payload=" + this.getPayload() + ", attachments=" + this.getAttachments() + ")";
    }

    public int hashCode() {
        int result = this.getId().hashCode();
        result = result * 31 + this.getChatId().hashCode();
        result = result * 31 + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        result = result * 31 + this.getMessageType().hashCode();
        result = result * 31 + this.getAuthor().hashCode();
        result = result * 31 + (this.getPayload() == null ? 0 : this.getPayload().hashCode());
        result = result * 31 + ((Object)this.getAttachments()).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DbChatMessage)) {
            return false;
        }
        DbChatMessage dbChatMessage = (DbChatMessage)other;
        if (!Intrinsics.areEqual((Object)this.getId(), (Object)dbChatMessage.getId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getChatId(), (Object)dbChatMessage.getChatId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMessage(), (Object)dbChatMessage.getMessage())) {
            return false;
        }
        if (this.getMessageType() != dbChatMessage.getMessageType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getAuthor(), (Object)dbChatMessage.getAuthor())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPayload(), (Object)dbChatMessage.getPayload())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getAttachments(), (Object)dbChatMessage.getAttachments());
    }

    public DbChatMessage() {
    }
}

