/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbRemovedParticipantProfileForSync;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H'\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbRemovedParticipantProfileForSync;", "Lde/justsoftware/chat/persistence/model/DbChatProfileId;", "deleteByRemovedAtLessThan", "", "removedAt", "Ljava/time/Instant;", "findChatsEffectivelyRemovedFromSince", "", "Ljava/util/UUID;", "profileId", "", "since", "chat-service"})
public interface RemovedParticipantProfileForSyncRepository
extends JpaRepository<DbRemovedParticipantProfileForSync, DbChatProfileId> {
    @Query(value="\n        SELECT rpp.chatId\n        FROM DbRemovedParticipantProfileForSync rpp\n        WHERE rpp.profileId = :profileId\n        AND rpp.removedAt > :since\n        AND NOT EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            LEFT JOIN DbUserGroupMember ugm ON cp.participantId = ugm.groupId\n            WHERE cp.chatId = rpp.chatId\n            AND (cp.participantId = :profileId OR ugm.profileId = :profileId)\n        )\n        ")
    @NotNull
    public List<UUID> findChatsEffectivelyRemovedFromSince(@NotNull String var1, @NotNull Instant var2);

    public long deleteByRemovedAtLessThan(@NotNull Instant var1);
}

