/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.persistence.model.DbChat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.persistence.QueryHint;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H'J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH'J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u0013H'J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0013H'J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0012\u001a\u00020\u0013H'J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/chat/persistence/ChatRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChat;", "Ljava/util/UUID;", "findAllChatIdsByType", "Ljava/util/stream/Stream;", "type", "Lde/justsoftware/chat/model/ChatType;", "findChatHavingMessagesByTenantIdAndParticipantIdIn", "Lorg/springframework/data/domain/Page;", "tenantId", "participantIds", "", "", "pageable", "Lorg/springframework/data/domain/Pageable;", "findChatsBySyncDateGreaterThanAndParticipantIds", "", "syncDate", "Ljava/time/Instant;", "findChatsBySyncDateGreaterThanAndParticipantIdsIn", "findOneOnOneChatsByOtherUserUpdatedAtGreaterThan", "profileId", "updatedSince", "updateSyncDateByChatIdIn", "", "chatIds", "updateSyncDateByChatIds", "", "chat-service"})
public interface ChatRepository
extends JpaRepository<DbChat, UUID> {
    @Query(value="\n        SELECT c\n        FROM DbChat c\n        WHERE c.tenantId = :tenantId\n        AND (c.type = 'MULTI_USER_CHAT' OR c.lastMessageId IS NOT NULL)\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            WHERE cp.chatId = c.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public Page<DbChat> findChatHavingMessagesByTenantIdAndParticipantIdIn(@NotNull UUID var1, @NotNull Iterable<String> var2, @NotNull Pageable var3);

    @Query(value="\n        SELECT c.id\n        FROM DbChat c\n        WHERE c.type = :type\n        ")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize")})
    @NotNull
    public Stream<UUID> findAllChatIdsByType(@NotNull ChatType var1);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="updateSyncDateByChatIds(chatIds, syncDate)", imports={}))
    @Query(value="UPDATE DbChat c SET c.syncDate = :syncDate WHERE c.id IN :chatIds")
    @Modifying
    public void updateSyncDateByChatIdIn(@NotNull Iterable<UUID> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public List<Unit> updateSyncDateByChatIds(@NotNull Set<UUID> chatIds, @NotNull Instant syncDate) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)syncDate, (String)"syncDate");
        Iterable $this$map$iv = CollectionsKt.chunked((Iterable)chatIds, (int)1000);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chatIdsChunk;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            this.updateSyncDateByChatIdIn((Iterable)chatIdsChunk, syncDate);
            collection.add(Unit.INSTANCE);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findChatsBySyncDateGreaterThanAndParticipantIds(participantIds, syncDate)", imports={}))
    @Query(value="\n        SELECT c.id\n        FROM DbChat c\n        WHERE c.syncDate > :syncDate\n        AND (c.type = 'MULTI_USER_CHAT' OR c.lastMessageId IS NOT NULL)\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            WHERE cp.chatId = c.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<UUID> findChatsBySyncDateGreaterThanAndParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public List<UUID> findChatsBySyncDateGreaterThanAndParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant syncDate) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)syncDate, (String)"syncDate");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findChatsBySyncDateGreaterThanAndParticipantIdsIn((Iterable)it, syncDate);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Query(value="\n        SELECT c.id\n        FROM DbChat c\n        JOIN DbChatParticipant cp1 ON c.id = cp1.chatId\n        JOIN DbChatParticipant cp2 ON c.id = cp2.chatId\n        JOIN DbProfile p ON cp2.participantId = p.id\n        WHERE cp1.participantId = :profileId\n        AND cp2.participantId <> :profileId\n        AND c.type = 'ONE_ON_ONE'\n        AND c.lastMessageId IS NOT NULL\n        AND p.updatedAt > :updatedSince\n        ")
    @NotNull
    public List<UUID> findOneOnOneChatsByOtherUserUpdatedAtGreaterThan(@NotNull String var1, @NotNull Instant var2);
}

