/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.DeletedMessage;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMarkedAsReadEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageDeletedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatSettingsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.mobile.model.MobilePushNotification;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.mobile.service.MobilePushNotificationProducer;
import de.justsoftware.chat.mobile.service.MobilePushNotificationSendService;
import de.justsoftware.chat.mobile.service.MobilePushTokenService;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0017\u0018\u0000 >2\u00020\u0001:\u0002>?BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0012J(\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\b\u0002\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017H\u0012J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010 \u001a\u00020\u0015H\u0012J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0012J\u0018\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0013H\u0012J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010)\u001a\u00020\u001dH\u0012J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0017J\u0010\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020/H\u0017J\u0010\u00100\u001a\u00020+2\u0006\u0010,\u001a\u000201H\u0017J\u0010\u00102\u001a\u00020+2\u0006\u0010,\u001a\u000203H\u0017J\u0010\u00104\u001a\u00020+2\u0006\u0010,\u001a\u000205H\u0017J\u0010\u00106\u001a\u00020+2\u0006\u0010,\u001a\u000207H\u0017J\u0010\u00108\u001a\u00020+2\u0006\u0010,\u001a\u000209H\u0017J\u0018\u0010:\u001a\u00020;2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\u0013H\u0012J\u0016\u0010<\u001a\u00020+2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/justsoftware/chat/mobile/service/MobilePushNotificationProducer;", "", "mobileApnsSendService", "Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;", "mobileFcmSendService", "mobilePushTokenService", "Lde/justsoftware/chat/mobile/service/MobilePushTokenService;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "(Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;Lde/justsoftware/chat/mobile/service/MobilePushNotificationSendService;Lde/justsoftware/chat/mobile/service/MobilePushTokenService;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatSettingsService;Lde/justsoftware/chat/business/ChatReadDateService;)V", "buildNewChatMessageContext", "Lde/justsoftware/chat/mobile/service/MobilePushNotificationProducer$NewChatMessageContext;", "message", "Lde/justsoftware/chat/business/model/UserMessage;", "profileIds", "", "Lde/justsoftware/chat/model/ProfileId;", "createAllForChatUpdate", "", "Lde/justsoftware/chat/mobile/model/MobilePushNotification;", "updatedChatId", "Lde/justsoftware/chat/model/ChatId;", "affectedProfileIds", "createAllForNewChatMessage", "newMessage", "createForChatUpdate", "Lde/justsoftware/chat/mobile/model/MobilePushNotification$ChatUpdate;", "pushToken", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "createForNewChatMessage", "Lde/justsoftware/chat/mobile/model/MobilePushNotification$NewChatMessage;", "context", "findAffectedProfileIdsInChat", "chatId", "onChatCreatedEvent", "", "event", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "onChatMarkedAsReadEvent", "Lde/justsoftware/chat/business/model/event/ChatMarkedAsReadEvent;", "onChatMessageCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "onChatMessageDeletedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageDeletedEvent;", "onChatParticipantsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "onChatSettingsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatSettingsChangedEvent;", "onChatUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "requiresOnlyChatUpdate", "", "send", "pushNotifications", "Companion", "NewChatMessageContext", "chat-service"})
public class MobilePushNotificationProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobilePushNotificationSendService mobileApnsSendService;
    @NotNull
    private final MobilePushNotificationSendService mobileFcmSendService;
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final ChatReadDateService chatReadDateService;

    public MobilePushNotificationProducer(@NotNull MobilePushNotificationSendService mobileApnsSendService, @NotNull MobilePushNotificationSendService mobileFcmSendService, @NotNull MobilePushTokenService mobilePushTokenService, @NotNull ChatService chatService, @NotNull ProfileService profileService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatSettingsService chatSettingsService, @NotNull ChatReadDateService chatReadDateService) {
        Intrinsics.checkNotNullParameter((Object)mobileApnsSendService, (String)"mobileApnsSendService");
        Intrinsics.checkNotNullParameter((Object)mobileFcmSendService, (String)"mobileFcmSendService");
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        this.mobileApnsSendService = mobileApnsSendService;
        this.mobileFcmSendService = mobileFcmSendService;
        this.mobilePushTokenService = mobilePushTokenService;
        this.chatService = chatService;
        this.profileService = profileService;
        this.chatParticipantService = chatParticipantService;
        this.chatSettingsService = chatSettingsService;
        this.chatReadDateService = chatReadDateService;
    }

    @EventListener
    public void onChatMessageCreatedEvent(@NotNull ChatMessageCreatedEvent event) {
        List list;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ChatMessage message2 = event.getChatMessage();
        if (message2 instanceof UserMessage) {
            list = this.createAllForNewChatMessage((UserMessage)message2);
        } else if (message2 instanceof SystemMessage ? true : message2 instanceof DeletedMessage) {
            list = MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)message2.getChatId(), null, (int)2, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.send(list);
    }

    @EventListener
    public void onChatMessageDeletedEvent(@NotNull ChatMessageDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChat().getId(), null, (int)2, null));
    }

    @EventListener
    public void onChatParticipantsChangedEvent(@NotNull ChatParticipantsChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(this.createAllForChatUpdate(event.getChatId(), SetsKt.plus((Set)event.getEffectiveProfileIdsAdded(), (Iterable)event.getEffectiveProfileIdsRemoved())));
    }

    @EventListener
    public void onChatCreatedEvent(@NotNull ChatCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChat().getId(), null, (int)2, null));
    }

    @EventListener
    public void onChatUpdatedEvent(@NotNull ChatUpdatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(MobilePushNotificationProducer.createAllForChatUpdate$default((MobilePushNotificationProducer)this, (ChatId)event.getChatId(), null, (int)2, null));
    }

    @EventListener
    public void onChatSettingsChangedEvent(@NotNull ChatSettingsChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(this.createAllForChatUpdate(event.getChatId(), SetsKt.setOf((Object)event.getProfileId())));
    }

    @EventListener
    public void onChatMarkedAsReadEvent(@NotNull ChatMarkedAsReadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.send(this.createAllForChatUpdate(event.getChatId(), SetsKt.setOf((Object)event.getProfileId())));
    }

    /*
     * WARNING - void declaration
     */
    private void send(List<? extends MobilePushNotification> pushNotifications) {
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = pushNotifications;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            MobilePushNotificationSendService mobilePushNotificationSendService;
            MobilePushNotification pushNotification = (MobilePushNotification)element$iv$iv;
            boolean bl = false;
            MobilePushNotification mobilePushNotification = pushNotification;
            if (mobilePushNotification instanceof MobilePushNotification.Apns) {
                mobilePushNotificationSendService = this.mobileApnsSendService;
            } else if (mobilePushNotification instanceof MobilePushNotification.Fcm) {
                mobilePushNotificationSendService = this.mobileFcmSendService;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            MobilePushNotificationSendService key$iv$iv = mobilePushNotificationSendService;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            MobilePushNotificationSendService sendService = (MobilePushNotificationSendService)entry.getKey();
            List pushNotifications2 = (List)entry.getValue();
            sendService.sendAll(pushNotifications2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<MobilePushNotification> createAllForChatUpdate(ChatId updatedChatId, Set<ProfileId> affectedProfileIds) {
        void $this$mapTo$iv$iv;
        Set set = affectedProfileIds;
        if (set == null) {
            set = this.findAffectedProfileIdsInChat(updatedChatId);
        }
        Iterable $this$map$iv = CollectionUtilsKt.flattenValues((Map)this.mobilePushTokenService.findByProfileIds(set));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createForChatUpdate((MobilePushToken)p0));
        }
        return (List)destination$iv$iv;
    }

    static /* synthetic */ List createAllForChatUpdate$default(MobilePushNotificationProducer mobilePushNotificationProducer, ChatId chatId, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createAllForChatUpdate");
        }
        if ((n & 2) != 0) {
            set = null;
        }
        return mobilePushNotificationProducer.createAllForChatUpdate(chatId, set);
    }

    /*
     * WARNING - void declaration
     */
    private List<MobilePushNotification> createAllForNewChatMessage(UserMessage newMessage) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map pushTokens = this.mobilePushTokenService.findByProfileIds(this.findAffectedProfileIdsInChat(newMessage.getChatId()));
        boolean bl = false;
        NewChatMessageContext context = this.buildNewChatMessageContext(newMessage, pushTokens.keySet());
        Iterable iterable = CollectionUtilsKt.flattenValues((Map)pushTokens);
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void pushToken;
            MobilePushToken mobilePushToken = (MobilePushToken)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.requiresOnlyChatUpdate((MobilePushToken)pushToken, context) ? (MobilePushNotification)this.createForChatUpdate((MobilePushToken)pushToken) : (MobilePushNotification)this.createForNewChatMessage((MobilePushToken)pushToken, context));
        }
        return (List)destination$iv$iv;
    }

    private Set<ProfileId> findAffectedProfileIdsInChat(ChatId chatId) {
        return this.chatParticipantService.findEffectiveProfileIdsByChatId(chatId);
    }

    private MobilePushNotification.ChatUpdate createForChatUpdate(MobilePushToken pushToken) {
        MobilePushNotification.ChatUpdate chatUpdate;
        switch (WhenMappings.$EnumSwitchMapping$0[pushToken.getPlatform().ordinal()]) {
            case 1: {
                chatUpdate = (MobilePushNotification.ChatUpdate)new MobilePushNotification.FcmChatUpdate(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), 1, null);
                break;
            }
            case 2: {
                chatUpdate = (MobilePushNotification.ChatUpdate)new MobilePushNotification.ApnsChatUpdate(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return chatUpdate;
    }

    private MobilePushNotification.NewChatMessage createForNewChatMessage(MobilePushToken pushToken, NewChatMessageContext context) {
        MobilePushNotification.NewChatMessage newChatMessage;
        switch (WhenMappings.$EnumSwitchMapping$0[pushToken.getPlatform().ordinal()]) {
            case 1: {
                newChatMessage = (MobilePushNotification.NewChatMessage)new MobilePushNotification.FcmNewChatMessage(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), context.getAuthor().getFullName(), UserMessage.Companion.attachmentFileNameOrMessage(context.getMessage(), true), Companion.access$toIntCount((Companion)Companion, (Long)((Long)context.getUnreadMessageCounts().get(pushToken.getUserId()))), Companion.access$toIntCount((Companion)Companion, (Long)((Long)context.getUnreadChatCounts().get(pushToken.getUserId()))), 1, null);
                break;
            }
            case 2: {
                newChatMessage = (MobilePushNotification.NewChatMessage)new MobilePushNotification.ApnsNewChatMessage(null, MobilePushNotification.Token.constructor-impl((String)pushToken.getToken()), pushToken.getUserId(), context.getMessage().getChatId(), context.getMessage().getId(), context.getMessage().getCreatedAt(), context.getAuthor().getFullName(), Companion.access$multiUserChatTitleOrNull((Companion)Companion, (Chat)context.getChat()), UserMessage.Companion.attachmentFileNameOrMessage(context.getMessage(), true), Companion.access$toIntCount((Companion)Companion, (Long)((Long)context.getUnreadMessageCounts().get(pushToken.getUserId()))), 1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return newChatMessage;
    }

    private boolean requiresOnlyChatUpdate(MobilePushToken pushToken, NewChatMessageContext context) {
        ProfileId userId = pushToken.getUserId();
        boolean isAuthor = Intrinsics.areEqual((Object)context.getAuthor().getId(), (Object)userId);
        ChatSettings chatSettings = (ChatSettings)context.getChatSettings().get(userId);
        boolean isChatMuted = chatSettings != null ? chatSettings.getMuted() : false;
        return isAuthor || isChatMuted;
    }

    private NewChatMessageContext buildNewChatMessageContext(UserMessage message2, Set<ProfileId> profileIds) {
        Map chatUnreadMessageCounts = this.chatReadDateService.getChatUnreadMessageCounts(profileIds);
        boolean bl = false;
        return new NewChatMessageContext(message2, this.chatService.getById(message2.getChatId()), this.profileService.getById(message2.getAuthor()), this.chatSettingsService.getSettingsForChat(message2.getChatId(), profileIds), Companion.access$toUnreadChatCounts((Companion)Companion, (Map)chatUnreadMessageCounts), Companion.access$toUnreadMessageCounts((Companion)Companion, (Map)chatUnreadMessageCounts));
    }
}

