/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChangesService;
import de.justsoftware.chat.business.ChatMessageLocalizationService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.PeopleService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.SearchService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.Changes;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageAttachment;
import de.justsoftware.chat.business.model.ChatReadDateAndCount;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.PeopleProfile;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.exception.ChatAlreadyExistsException;
import de.justsoftware.chat.exception.ChatMessageAlreadyExistsException;
import de.justsoftware.chat.exception.DeprecatedChangesException;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.mobile.model.MobileAttachmentFilter;
import de.justsoftware.chat.mobile.model.MobileChange;
import de.justsoftware.chat.mobile.model.MobileChangeList;
import de.justsoftware.chat.mobile.model.MobileChangeToken;
import de.justsoftware.chat.mobile.model.MobileChat;
import de.justsoftware.chat.mobile.model.MobileChatList;
import de.justsoftware.chat.mobile.model.MobileChatMessage;
import de.justsoftware.chat.mobile.model.MobileChatMessageList;
import de.justsoftware.chat.mobile.model.MobileChatSettings;
import de.justsoftware.chat.mobile.model.MobileClientVersion;
import de.justsoftware.chat.mobile.model.MobileMessageTypeUpdate;
import de.justsoftware.chat.mobile.model.MobilePlatform;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.mobile.model.MobileSearchItemType;
import de.justsoftware.chat.mobile.model.MobileSearchResult;
import de.justsoftware.chat.mobile.model.MobileSearchResultList;
import de.justsoftware.chat.mobile.model.MobileSetting;
import de.justsoftware.chat.mobile.model.MobileThumbnailSize;
import de.justsoftware.chat.mobile.model.MobileUser;
import de.justsoftware.chat.mobile.model.MobileUserGroup;
import de.justsoftware.chat.mobile.model.MobileUserGroupSearchResult;
import de.justsoftware.chat.mobile.model.MobileUserList;
import de.justsoftware.chat.mobile.model.MobileUserSearchResult;
import de.justsoftware.chat.mobile.service.MobileApplicationService;
import de.justsoftware.chat.mobile.service.MobilePushTokenService;
import de.justsoftware.chat.mobile.service.MobileSettingsService;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.CommonCoreSearchResult;
import de.justsoftware.chat.model.Diff;
import de.justsoftware.chat.model.LimitOffset;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PeopleItemType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0090\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 \u00a2\u00012\u00020\u0001:\u0004\u00a1\u0001\u00a2\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u0012\u0006\u0010 \u001a\u00020!\u00a2\u0006\u0002\u0010\"J\u0012\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0012J0\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00100\u001a\u000201H\u0016J,\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020(2\n\b\u0002\u00107\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0012J(\u00108\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020(2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00109\u001a\u00020$2\u0006\u0010)\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0010\u0010:\u001a\u00020;2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\u0006\u00100\u001a\u000201H\u0016J&\u0010B\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\u0006\u0010C\u001a\u00020D2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020@2\u0006\u00100\u001a\u000201H\u0016J\u001e\u0010F\u001a\u00020G2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u00100\u001a\u000201H\u0012J*\u0010K\u001a\u000e\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020N0L2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020M0P2\u0006\u00100\u001a\u000201H\u0012J*\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020;0L2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020R0P2\u0006\u00100\u001a\u000201H\u0012J\"\u0010S\u001a\u00020T2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010U\u001a\u00020V2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010W\u001a\u0002032\u0006\u0010)\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010X\u001a\u00020Y2\u0006\u0010)\u001a\u00020*2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010Z\u001a\u00020(2\u0006\u0010?\u001a\u00020@2\u0006\u00100\u001a\u000201H\u0016J:\u0010[\u001a\u00020\\2\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010]\u001a\u0004\u0018\u00010@2\b\b\u0002\u0010^\u001a\u00020_2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010a2\u0006\u00100\u001a\u000201H\u0016J \u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020_2\u0006\u0010^\u001a\u00020_2\u0006\u00100\u001a\u000201H\u0016J\u000e\u0010e\u001a\b\u0012\u0004\u0012\u00020g0fH\u0016J\u0018\u0010h\u001a\u00020i2\u0006\u0010?\u001a\u00020@2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010j\u001a\b\u0012\u0004\u0012\u00020g0f2\b\u0010k\u001a\u0004\u0018\u00010lH\u0012J\u0018\u0010m\u001a\u00020;2\u0006\u0010n\u001a\u00020R2\u0006\u00100\u001a\u000201H\u0016J(\u0010o\u001a\u00020p2\u0006\u0010`\u001a\u00020i2\u0006\u0010d\u001a\u00020_2\u0006\u0010^\u001a\u00020_2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010q\u001a\u00020i2\u0006\u0010r\u001a\u0002062\u0006\u00100\u001a\u000201H\u0012J\u0018\u0010s\u001a\u00020i2\u0006\u0010t\u001a\u00020u2\u0006\u00100\u001a\u000201H\u0012J\"\u0010v\u001a\u00020i2\u0006\u00104\u001a\u00020J2\b\u0010w\u001a\u0004\u0018\u00010x2\u0006\u00100\u001a\u000201H\u0012J \u0010y\u001a\u0002032\u0006\u0010)\u001a\u00020*2\u0006\u0010z\u001a\u00020l2\u0006\u00100\u001a\u000201H\u0016J \u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020i2\u0006\u0010~\u001a\u00020\u007f2\u0006\u00100\u001a\u000201H\u0016JC\u0010\u0080\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u0082\u0001\u001a\u00020i2\b\b\u0002\u0010d\u001a\u00020_2\b\b\u0002\u0010^\u001a\u00020_2\u0012\b\u0002\u0010\u0083\u0001\u001a\u000b\u0012\u0005\u0012\u00030\u0084\u0001\u0018\u00010f2\u0006\u00100\u001a\u000201H\u0016J!\u0010\u0085\u0001\u001a\u00020$2\u0006\u0010}\u001a\u00020i2\u0006\u0010~\u001a\u00020\u007f2\u0006\u00100\u001a\u000201H\u0016J\u0019\u0010\u0086\u0001\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00100\u001a\u000201H\u0017J\"\u0010\u0087\u0001\u001a\u00020Y2\u0006\u0010)\u001a\u00020*2\u0007\u0010\u0088\u0001\u001a\u00020Y2\u0006\u00100\u001a\u000201H\u0016J#\u0010\u0089\u0001\u001a\u00020(2\u0006\u0010?\u001a\u00020@2\b\u0010\u008a\u0001\u001a\u00030\u008b\u00012\u0006\u00100\u001a\u000201H\u0017J\u001a\u0010\u008c\u0001\u001a\u00020;2\u0007\u0010\u008d\u0001\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0016J\u001a\u0010\u008e\u0001\u001a\u00020;2\u0006\u00100\u001a\u0002012\u0007\u0010\u008f\u0001\u001a\u00020iH\u0012J\u001b\u0010\u0090\u0001\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u00100\u001a\u000201H\u0012J\u001b\u0010\u0091\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010f*\t\u0012\u0005\u0012\u00030\u0093\u00010fH\u0012J\"\u0010\u0094\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010f*\b\u0012\u0004\u0012\u00020J0f2\u0006\u00100\u001a\u000201H\u0012J\"\u0010\u0095\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010f*\b\u0012\u0004\u0012\u0002060f2\u0006\u00100\u001a\u000201H\u0012J\u0015\u0010\u0096\u0001\u001a\u000203*\u00020J2\u0006\u00100\u001a\u000201H\u0012J\u001b\u0010\u0097\u0001\u001a\u00020c*\b\u0012\u0004\u0012\u0002030f2\u0006\u00100\u001a\u000201H\u0012J\u0015\u0010\u0098\u0001\u001a\u00020(*\u0002062\u0006\u00100\u001a\u000201H\u0012J!\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u0002030f*\b\u0012\u0004\u0012\u00020J0I2\u0006\u00100\u001a\u000201H\u0012J\u001a\u0010\u009a\u0001\u001a\b\u0012\u0004\u0012\u00020;0f*\t\u0012\u0005\u0012\u00030\u009b\u00010IH\u0012J\u001a\u0010\u009c\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010f*\b\u0012\u0004\u0012\u00020g0fH\u0012J*\u0010\u009d\u0001\u001a\u0004\u0018\u00010i*\u0002062\u0006\u00104\u001a\u00020J2\u0006\u00100\u001a\u0002012\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010xH\u0012J\"\u0010\u009f\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010f*\b\u0012\u0004\u0012\u00020u0f2\u0006\u00100\u001a\u000201H\u0012J\"\u0010\u00a0\u0001\u001a\t\u0012\u0005\u0012\u00030\u0092\u00010f*\b\u0012\u0004\u0012\u00020x0f2\u0006\u00100\u001a\u000201H\u0012R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a3\u0001"}, d2={"Lde/justsoftware/chat/mobile/service/MobileApplicationService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "searchService", "Lde/justsoftware/chat/business/SearchService;", "chatMessageLocalizationService", "Lde/justsoftware/chat/business/ChatMessageLocalizationService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "peopleService", "Lde/justsoftware/chat/business/PeopleService;", "driveService", "Lde/justsoftware/chat/business/DriveService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "mobileSettingsService", "Lde/justsoftware/chat/mobile/service/MobileSettingsService;", "mobilePushTokenService", "Lde/justsoftware/chat/mobile/service/MobilePushTokenService;", "changesService", "Lde/justsoftware/chat/business/ChangesService;", "resourceBundle", "Lorg/springframework/context/support/ResourceBundleMessageSource;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/SearchService;Lde/justsoftware/chat/business/ChatMessageLocalizationService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/business/PeopleService;Lde/justsoftware/chat/business/DriveService;Lde/justsoftware/chat/business/ChatSettingsService;Lde/justsoftware/chat/mobile/service/MobileSettingsService;Lde/justsoftware/chat/mobile/service/MobilePushTokenService;Lde/justsoftware/chat/business/ChangesService;Lorg/springframework/context/support/ResourceBundleMessageSource;Ljava/time/Clock;)V", "checkForDeprecatedChangeToken", "", "changeToken", "Lde/justsoftware/chat/mobile/model/MobileChangeToken;", "createAttachmentMessage", "Lde/justsoftware/chat/mobile/model/MobileChatMessage;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "message", "attachment", "Lorg/springframework/web/multipart/MultipartFile;", "markChatAsRead", "", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "createChat", "Lde/justsoftware/chat/mobile/model/MobileChat;", "chat", "createOrGetMessage", "Lde/justsoftware/chat/business/model/ChatMessage;", "file", "createTextMessage", "deleteChat", "deleteUserImage", "Lde/justsoftware/chat/mobile/model/MobileUser;", "downloadAttachment", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "messageId", "Lde/justsoftware/chat/model/ChatMessageId;", "downloadAttachmentPreview", "downloadAttachmentThumbnail", "size", "Lde/justsoftware/chat/mobile/model/MobileThumbnailSize;", "downloadAttachmentVideoStream", "fetchChatTransformationContext", "Lde/justsoftware/chat/mobile/service/MobileApplicationService$ChatTransformationContext;", "chats", "", "Lde/justsoftware/chat/business/model/Chat;", "findUserGroupsById", "", "Lde/justsoftware/chat/model/UserGroupId;", "Lde/justsoftware/chat/mobile/model/MobileUserGroup;", "ids", "", "findUsersById", "Lde/justsoftware/chat/model/ProfileId;", "getChanges", "Lde/justsoftware/chat/mobile/model/MobileChangeList;", "clientVersion", "Lde/justsoftware/chat/mobile/model/MobileClientVersion;", "getChat", "getChatSettings", "Lde/justsoftware/chat/mobile/model/MobileChatSettings;", "getMessage", "getMessages", "Lde/justsoftware/chat/mobile/model/MobileChatMessageList;", "offsetMessageId", "limit", "", "filter", "Lde/justsoftware/chat/mobile/model/MobileAttachmentFilter;", "getRecentChats", "Lde/justsoftware/chat/mobile/model/MobileChatList;", "offset", "getSettings", "", "Lde/justsoftware/chat/mobile/model/MobileSetting;", "getUnauthorizedAttachmentVideoUrl", "", "getUpdatedSettings", "since", "Ljava/time/Instant;", "getUser", "userId", "getUsers", "Lde/justsoftware/chat/mobile/model/MobileUserList;", "localizeMessage", "chatMessage", "localizeName", "userGroup", "Lde/justsoftware/chat/business/model/UserGroup;", "localizeTitle", "oneOnOneChatPartner", "Lde/justsoftware/chat/business/model/Profile;", "readChat", "readDate", "registerPushToken", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "pushToken", "platform", "Lde/justsoftware/chat/mobile/model/MobilePlatform;", "searchParticipants", "Lde/justsoftware/chat/mobile/model/MobileSearchResultList;", "query", "types", "Lde/justsoftware/chat/mobile/model/MobileSearchItemType;", "unregisterPushToken", "updateChat", "updateChatSettings", "chatSettings", "updateMessage", "messageTypeUpdate", "Lde/justsoftware/chat/mobile/model/MobileMessageTypeUpdate;", "updateUserImage", "image", "updateUserImageUrl", "imageUrl", "validateTenant", "toChatSettingsUpdates", "Lde/justsoftware/chat/mobile/model/MobileChange;", "Lde/justsoftware/chat/business/model/ChatSettings;", "toChatUpdates", "toMessageUpdates", "toMobileChat", "toMobileChatList", "toMobileChatMessage", "toMobileChats", "toMobileUsers", "Lde/justsoftware/chat/model/CommonCoreSearchResult;", "toSettingsUpdates", "toTeaser", "author", "toUserGroupUpdates", "toUserUpdates", "ChatTransformationContext", "Companion", "chat-service"})
public class MobileApplicationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final SearchService searchService;
    @NotNull
    private final ChatMessageLocalizationService chatMessageLocalizationService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final PeopleService peopleService;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final MobileSettingsService mobileSettingsService;
    @NotNull
    private final MobilePushTokenService mobilePushTokenService;
    @NotNull
    private final ChangesService changesService;
    @NotNull
    private final ResourceBundleMessageSource resourceBundle;
    @NotNull
    private final Clock clock;
    public static final long CHAT_CHANGES_MAX_AGE_DAYS = 30L;

    public MobileApplicationService(@NotNull ChatService chatService, @NotNull ChatMessageService chatMessageService, @NotNull ChatParticipantService chatParticipantService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull SearchService searchService, @NotNull ChatMessageLocalizationService chatMessageLocalizationService, @NotNull ChatReadDateService chatReadDateService, @NotNull PeopleService peopleService, @NotNull DriveService driveService, @NotNull ChatSettingsService chatSettingsService, @NotNull MobileSettingsService mobileSettingsService, @NotNull MobilePushTokenService mobilePushTokenService, @NotNull ChangesService changesService, @NotNull ResourceBundleMessageSource resourceBundle, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        Intrinsics.checkNotNullParameter((Object)chatMessageLocalizationService, (String)"chatMessageLocalizationService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)peopleService, (String)"peopleService");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)mobileSettingsService, (String)"mobileSettingsService");
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenService, (String)"mobilePushTokenService");
        Intrinsics.checkNotNullParameter((Object)changesService, (String)"changesService");
        Intrinsics.checkNotNullParameter((Object)resourceBundle, (String)"resourceBundle");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatService = chatService;
        this.chatMessageService = chatMessageService;
        this.chatParticipantService = chatParticipantService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.searchService = searchService;
        this.chatMessageLocalizationService = chatMessageLocalizationService;
        this.chatReadDateService = chatReadDateService;
        this.peopleService = peopleService;
        this.driveService = driveService;
        this.chatSettingsService = chatSettingsService;
        this.mobileSettingsService = mobileSettingsService;
        this.mobilePushTokenService = mobilePushTokenService;
        this.changesService = changesService;
        this.resourceBundle = resourceBundle;
        this.clock = clock;
    }

    @NotNull
    public MobileChatList getRecentChats(int offset, int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.toMobileChatList(this.toMobileChats((Iterable)this.chatService.getRecentChats(authContext.getProfileId(), authContext.getTenantId(), (Offset)new LimitOffset(offset, limit)), authContext), authContext);
    }

    @NotNull
    public MobileChat getChat(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        return this.toMobileChat(this.chatService.getById(chatId), authContext);
    }

    @NotNull
    public MobileChat createChat(@NotNull MobileChat chat, @NotNull AuthorizationContext authContext) {
        MobileChat mobileChat;
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkCreateChat();
        try {
            mobileChat = this.toMobileChat(this.chatService.createChat(MobileChat.Companion.toNewChat(chat, authContext.getTenantId(), this.clock), Companion.access$participantPermissions((Companion)Companion, (MobileChat)chat), authContext.getProfileId()), authContext);
        }
        catch (ChatAlreadyExistsException e) {
            mobileChat = this.getChat(e.getChatId(), authContext);
        }
        return mobileChat;
    }

    @Transactional
    @NotNull
    public MobileChat updateChat(@NotNull MobileChat chat, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Map participants = Companion.access$participantPermissions((Companion)Companion, (MobileChat)chat);
        Diff participantChanges = this.chatParticipantService.getParticipantChanges(chat.getId(), participants);
        Chat currentChat = this.chatService.getById(chat.getId());
        boolean bl = false;
        boolean titleChanged = currentChat instanceof MultiUserChat && !Intrinsics.areEqual((Object)chat.getTitle(), (Object)((MultiUserChat)currentChat).getTitle());
        if (!titleChanged && Companion.access$isOnlyLeavingChat((Companion)Companion, (Diff)participantChanges, (ProfileId)authContext.getProfileId())) {
            authContext.checkReadChat(chat.getId());
        } else {
            authContext.checkManageChat(chat.getId());
        }
        if (participantChanges.getHasChanges()) {
            ChatParticipantService.setParticipants$default((ChatParticipantService)this.chatParticipantService, (ChatId)chat.getId(), (Map)participants, (ProfileId)authContext.getProfileId(), (boolean)false, (int)8, null);
        }
        if (titleChanged) {
            this.chatService.updateUserGroupChatTitle(chat.getId(), chat.getTitle(), authContext.getProfileId());
        }
        return this.getChat(chat.getId(), authContext);
    }

    public void deleteChat(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageChat(chatId);
        this.chatService.delete(chatId, authContext.getProfileId());
    }

    @NotNull
    public MobileChat readChat(@NotNull ChatId chatId, @NotNull Instant readDate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatReadDateService.markAsRead(chatId, authContext.getProfileId(), readDate);
        return this.getChat(chatId, authContext);
    }

    @NotNull
    public MobileChatSettings getChatSettings(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        MobileChatSettings.Companion companion = MobileChatSettings.Companion;
        Object object = this.chatSettingsService.getSettings(authContext.getProfileId(), SetsKt.setOf((Object)chatId)).get(chatId);
        if (object == null) {
            MobileChatSettings.Companion companion2 = companion;
            boolean bl = false;
            object = new ChatSettings(chatId, authContext.getProfileId(), false, null, 12, null);
            companion = companion2;
        }
        return companion.toMobileChatSettings((ChatSettings)object);
    }

    @NotNull
    public MobileChatSettings updateChatSettings(@NotNull ChatId chatId, @NotNull MobileChatSettings chatSettings, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatSettings, (String)"chatSettings");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Companion.access$validateUpdateChatSettings((Companion)Companion, (ChatId)chatId, (MobileChatSettings)chatSettings);
        authContext.checkReadChat(chatId);
        return MobileChatSettings.Companion.toMobileChatSettings(this.chatSettingsService.muteChat(chatSettings.getChatId(), authContext.getProfileId(), chatSettings.getMuted()));
    }

    @NotNull
    public MobileUserList getUsers(@NotNull String filter, int offset, int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        List p0 = this.toMobileUsers((Iterable)SearchService.suggestUser$default((SearchService)this.searchService, (String)filter, (ProfileId)authContext.getProfileId(), (Offset)((Offset)new LimitOffset(offset, limit)), null, (int)8, null));
        boolean bl = false;
        return new MobileUserList(p0);
    }

    @NotNull
    public MobileUser getUser(@NotNull ProfileId userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Companion this_$iv = Companion;
        boolean $i$f$notFoundOnNotAllowed = false;
        try {
            boolean bl = false;
            authContext.checkReadProfile(userId);
        }
        catch (NotAllowedException e$iv) {
            String string2 = e$iv.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            throw new NotFoundException(string2);
        }
        return MobileUser.Companion.toMobileUser(this.profileService.getById(userId), true);
    }

    @NotNull
    public MobileChatMessage getMessage(@NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        boolean bl = false;
        authContext.checkReadChat(message2.getChatId());
        return this.toMobileChatMessage(message2, authContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobileChatMessageList getMessages(@NotNull ChatId chatId, @Nullable ChatMessageId offsetMessageId, int limit, @Nullable MobileAttachmentFilter filter, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapToSet$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        MobileChat chat = this.getChat(chatId, authContext);
        MobileAttachmentFilter mobileAttachmentFilter = filter;
        List list = this.chatMessageService.getRecentMessages(chatId, offsetMessageId, limit, mobileAttachmentFilter != null ? MobileAttachmentFilter.Companion.toAttachmentFilter(mobileAttachmentFilter) : null).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"chatMessageService\n     \u2026r())\n            .content");
        Iterable iterable = list;
        boolean $i$f$map22 = false;
        void var10_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ChatMessage chatMessage = (ChatMessage)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(this.toMobileChatMessage((ChatMessage)it, authContext));
        }
        List messages = (List)destination$iv$iv;
        Iterable $i$f$map22 = messages;
        boolean $i$f$mapToSet22 = false;
        destination$iv$iv = $this$mapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p02;
            MobileChatMessage bl = (MobileChatMessage)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(p02.getAuthorId());
        }
        $this$mapToSet$iv = (Set)destination$iv$iv2;
        ProfileService $i$f$mapToSet22 = this.profileService;
        Set p0 = $this$mapToSet$iv;
        boolean bl = false;
        $this$mapToSet$iv = $i$f$mapToSet22.findByIds(p0).values();
        boolean $i$f$mapToSet = false;
        p0 = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profile;
            Profile p02 = (Profile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(MobileUser.Companion.toMobileUser((Profile)profile, true));
        }
        Set authors = (Set)destination$iv$iv;
        return new MobileChatMessageList(messages, chat, authors);
    }

    public static /* synthetic */ MobileChatMessageList getMessages$default(MobileApplicationService mobileApplicationService, ChatId chatId, ChatMessageId chatMessageId, int n, MobileAttachmentFilter mobileAttachmentFilter, AuthorizationContext authorizationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 2) != 0) {
            chatMessageId = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            mobileAttachmentFilter = null;
        }
        return mobileApplicationService.getMessages(chatId, chatMessageId, n, mobileAttachmentFilter, authorizationContext);
    }

    @Transactional
    @NotNull
    public MobileChatMessage updateMessage(@NotNull ChatMessageId messageId, @NotNull MobileMessageTypeUpdate messageTypeUpdate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)messageTypeUpdate, (String)"messageTypeUpdate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        boolean bl = false;
        authContext.checkReadChat(message2.getChatId());
        Companion.access$validateUpdateMessageForDeletion((Companion)Companion, (ChatMessageId)messageId, (MobileMessageTypeUpdate)messageTypeUpdate);
        return this.toMobileChatMessage(this.chatMessageService.delete(messageId, authContext.getProfileId()), authContext);
    }

    @NotNull
    public MobileChatMessage createTextMessage(@NotNull ChatId chatId, @NotNull MobileChatMessage message2, boolean markChatAsRead, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Companion.access$validateCreateMessage((Companion)Companion, (ChatId)chatId, (MobileChatMessage)message2, (MobileChatMessage.Type)MobileChatMessage.Type.TEXT);
        authContext.checkWriteChat(chatId);
        return this.toMobileChatMessage(MobileApplicationService.createOrGetMessage$default((MobileApplicationService)this, (MobileChatMessage)message2, null, (boolean)markChatAsRead, (AuthorizationContext)authContext, (int)2, null), authContext);
    }

    @NotNull
    public MobileChatMessage createAttachmentMessage(@NotNull ChatId chatId, @NotNull MobileChatMessage message2, @NotNull MultipartFile attachment, boolean markChatAsRead, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Companion.access$validateCreateMessage((Companion)Companion, (ChatId)chatId, (MobileChatMessage)message2, (MobileChatMessage.Type)MobileChatMessage.Type.ATTACHMENT);
        authContext.checkWriteChat(chatId);
        return this.toMobileChatMessage(this.createOrGetMessage(message2, attachment, markChatAsRead, authContext), authContext);
    }

    private ChatMessage createOrGetMessage(MobileChatMessage message2, MultipartFile file, boolean markChatAsRead, AuthorizationContext authContext) {
        ChatMessage chatMessage;
        try {
            ChatMessage chatMessage2 = chatMessage = this.chatMessageService.create((ChatMessage)MobileChatMessage.Companion.toNewUserMessage(message2, this.clock), CollectionsKt.listOfNotNull((Object)file));
            boolean bl = false;
            if (markChatAsRead) {
                this.chatReadDateService.markAsRead(chatMessage2.getChatId(), authContext.getProfileId(), chatMessage2.getCreatedAt());
            }
        }
        catch (ChatMessageAlreadyExistsException e) {
            chatMessage = this.chatMessageService.getById(e.getMessageId());
        }
        return chatMessage;
    }

    static /* synthetic */ ChatMessage createOrGetMessage$default(MobileApplicationService mobileApplicationService, MobileChatMessage mobileChatMessage, MultipartFile multipartFile, boolean bl, AuthorizationContext authorizationContext, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createOrGetMessage");
        }
        if ((n & 2) != 0) {
            multipartFile = null;
        }
        return mobileApplicationService.createOrGetMessage(mobileChatMessage, multipartFile, bl, authorizationContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobileSearchResultList searchParticipants(@NotNull String query, int offset, int limit, @Nullable List<? extends MobileSearchItemType> types, @NotNull AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        Collection<PeopleItemType> collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        TenantId tenantId = authContext.getTenantId();
        Offset offset2 = (Offset)new LimitOffset(offset, limit);
        List list = types;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        Offset offset3 = offset2;
        Object object2 = query;
        Object object3 = tenantId;
        Object object4 = this.peopleService;
        boolean $i$f$map = false;
        void var9_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            MobileSearchItemType mobileSearchItemType = (MobileSearchItemType)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileSearchItemType.Companion.toPeopleItemType((MobileSearchItemType)it));
        }
        collection = (List)destination$iv$iv;
        List participantIds = object4.searchParticipants(object3, (String)object2, offset3, (List)collection);
        iterable = Companion.access$toGroupedIds((Companion)Companion, (List)participantIds);
        Set profileIds = (Set)iterable.component1();
        Set userGroupIds = (Set)iterable.component2();
        Map $i$f$mapTo22 = this.findUsersById(profileIds, authContext);
        boolean $i$f$mapValues22 = false;
        item$iv$iv2 = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = it$iv$iv.getKey();
            object4 = object;
            boolean bl2 = false;
            MobileUser profile = (MobileUser)entry2.getValue();
            object2 = new MobileUserSearchResult(profile);
            object4.put(object3, object2);
        }
        Map profilesById = destination$iv$iv2;
        Map $i$f$mapValues22 = this.findUserGroupsById(userGroupIds, authContext);
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Object destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object3 = it$iv$iv.getKey();
            object4 = map;
            boolean bl3 = false;
            MobileUserGroup userGroup = (MobileUserGroup)entry.getValue();
            object2 = new MobileUserGroupSearchResult(userGroup);
            object4.put(object3, object2);
        }
        Map userGroupsById = destination$iv$iv3;
        Iterable $this$map$iv2 = participantIds;
        boolean $i$f$map2 = false;
        $this$mapValuesTo$iv$iv = $this$map$iv2;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            MobileSearchResult mobileSearchResult;
            void id;
            Object element$iv$iv$iv;
            element$iv$iv$iv = (ParticipantId)item$iv$iv3;
            object2 = destination$iv$iv3;
            boolean bl = false;
            object = id;
            if (object instanceof ProfileId) {
                mobileSearchResult = (MobileSearchResult)MapsKt.getValue((Map)profilesById, (Object)id);
            } else if (object instanceof UserGroupId) {
                mobileSearchResult = (MobileSearchResult)MapsKt.getValue((Map)userGroupsById, (Object)id);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object2.add(mobileSearchResult);
        }
        List list2 = (List)destination$iv$iv3;
        return new MobileSearchResultList(list2);
    }

    public static /* synthetic */ MobileSearchResultList searchParticipants$default(MobileApplicationService mobileApplicationService, String string2, int n, int n2, List list, AuthorizationContext authorizationContext, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: searchParticipants");
        }
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 20;
        }
        if ((n3 & 8) != 0) {
            list = null;
        }
        return mobileApplicationService.searchParticipants(string2, n, n2, list, authorizationContext);
    }

    @NotNull
    public ResponseEntity<Resource> downloadAttachment(@NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        authContext.checkReadChat(message2.getChatId());
        return this.driveService.downloadFile(Companion.access$firstAttachmentOrError((Companion)Companion, (ChatMessage)message2).getDocumentId());
    }

    @NotNull
    public ResponseEntity<Resource> downloadAttachmentThumbnail(@NotNull ChatMessageId messageId, @NotNull MobileThumbnailSize size, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        authContext.checkReadChat(message2.getChatId());
        ChatMessageAttachment attachment = Companion.access$firstAttachmentOrError((Companion)Companion, (ChatMessage)message2);
        if (!ChatMessageService.Companion.getHasThumbnail(attachment)) {
            throw new NotFoundException("No thumbnail for attachment " + attachment.getId());
        }
        return this.driveService.downloadFileThumbnail(attachment.getDocumentId(), size.getImageSize());
    }

    @NotNull
    public ResponseEntity<Resource> downloadAttachmentPreview(@NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        authContext.checkReadChat(message2.getChatId());
        return this.driveService.downloadFilePreview(Companion.access$firstAttachmentOrError((Companion)Companion, (ChatMessage)message2).getDocumentId());
    }

    @NotNull
    public ResponseEntity<Resource> downloadAttachmentVideoStream(@NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        authContext.checkReadChat(message2.getChatId());
        ChatMessageAttachment attachment = Companion.access$firstAttachmentOrError((Companion)Companion, (ChatMessage)message2);
        if (!ChatMessageAttachment.Companion.isVideo(attachment)) {
            throw new NotFoundException("No video stream for attachment " + attachment.getId());
        }
        return this.driveService.downloadVideoStream(attachment.getDocumentId());
    }

    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatMessage message2 = this.chatMessageService.getById(messageId);
        authContext.checkReadChat(message2.getChatId());
        ChatMessageAttachment attachment = Companion.access$firstAttachmentOrError((Companion)Companion, (ChatMessage)message2);
        if (!ChatMessageAttachment.Companion.isVideo(attachment)) {
            throw new NotFoundException("No video url for attachment " + attachment.getId());
        }
        return this.driveService.getUnauthorizedVideoUrl(attachment.getDocumentId());
    }

    @NotNull
    public MobileUser updateUserImage(@NotNull MultipartFile image, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PeopleProfile peopleProfile = this.peopleService.updateUserImage(authContext.getProfileId(), image);
        return this.updateUserImageUrl(authContext, peopleProfile.getImageUrl());
    }

    @NotNull
    public MobileUser deleteUserImage(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        PeopleProfile peopleProfile = this.peopleService.deleteUserImage(authContext.getProfileId());
        return this.updateUserImageUrl(authContext, peopleProfile.getImageUrl());
    }

    @NotNull
    public List<MobileSetting> getSettings() {
        return this.mobileSettingsService.getSettings();
    }

    @NotNull
    public MobilePushToken registerPushToken(@NotNull String pushToken, @NotNull MobilePlatform platform, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobilePushTokenService.registerPushToken(pushToken, platform, authContext.getProfileId());
    }

    public void unregisterPushToken(@NotNull String pushToken, @NotNull MobilePlatform platform, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobilePushTokenService.unregisterPushToken(pushToken, platform, authContext.getProfileId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobileChangeList getChanges(@Nullable MobileChangeToken changeToken, @NotNull MobileClientVersion clientVersion, @NotNull AuthorizationContext authContext) {
        Collection<MobileChange.Delete> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)clientVersion, (String)"clientVersion");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.checkForDeprecatedChangeToken(changeToken);
        this.validateTenant(changeToken, authContext);
        Instant requestTimestamp = this.clock.instant();
        MobileChangeToken mobileChangeToken = changeToken;
        Instant since = mobileChangeToken != null ? mobileChangeToken.getTimestamp() : null;
        Changes changes = this.changesService.getChanges(since, authContext.getProfileId(), authContext.getTenantId());
        List updatedSettings = this.getUpdatedSettings(since);
        List[] listArray = new List[7];
        listArray[0] = this.toChatUpdates(changes.getUpdatedChats(), authContext);
        listArray[1] = this.toMessageUpdates(changes.getUpdatedMessages(), authContext);
        listArray[2] = this.toUserUpdates(changes.getUpdatedProfiles(), authContext);
        listArray[3] = this.toUserGroupUpdates(changes.getUpdatedUserGroups(), authContext);
        listArray[4] = this.toChatSettingsUpdates(changes.getUpdatedChatSettings());
        listArray[5] = this.toSettingsUpdates(updatedSettings);
        Iterable iterable = changes.getDeletedChatIds();
        int n = 6;
        List[] listArray2 = listArray;
        boolean $i$f$map = false;
        void var12_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toDeleteChange((ChatId)it));
        }
        collection = (List)destination$iv$iv;
        listArray2[n] = collection;
        List items = CollectionUtilsKt.concat((List[])listArray);
        Intrinsics.checkNotNullExpressionValue((Object)requestTimestamp, (String)"requestTimestamp");
        MobileChangeToken nextToken = new MobileChangeToken(0, requestTimestamp, clientVersion.getVersionCode(), authContext.getTenantId(), 1, null);
        return new MobileChangeList(items, nextToken);
    }

    private void checkForDeprecatedChangeToken(MobileChangeToken changeToken) {
        if (changeToken == null) {
            return;
        }
        if (changeToken.getVersion() < 5) {
            throw new DeprecatedChangesException();
        }
        if (changeToken.getTimestamp().isBefore(this.clock.instant().minus(30L, ChronoUnit.DAYS))) {
            throw new DeprecatedChangesException();
        }
    }

    private void validateTenant(MobileChangeToken changeToken, AuthorizationContext authContext) {
        ValidationException.Companion companion = ValidationException.Companion;
        boolean value$iv = changeToken == null || Intrinsics.areEqual((Object)changeToken.getTenantId(), (Object)authContext.getTenantId());
        boolean $i$f$validate = false;
        if (!value$iv) {
            boolean bl = false;
            MobileChangeToken mobileChangeToken = changeToken;
            String string2 = ("Sync token was issued for tenant " + (TenantId)(mobileChangeToken != null ? mobileChangeToken.getTenantId() : null) + " but user is logged into tenant " + authContext.getTenantId()).toString();
            throw new ValidationException(string2);
        }
    }

    private List<MobileSetting> getUpdatedSettings(Instant since) {
        return since != null ? this.mobileSettingsService.getSettingsUpdates(since) : this.mobileSettingsService.getSettings();
    }

    private MobileUser updateUserImageUrl(AuthorizationContext authContext, String imageUrl) {
        return MobileUser.Companion.toMobileUser(this.profileService.updateImageUrl(authContext.getProfileId(), imageUrl), true);
    }

    private String localizeMessage(ChatMessage chatMessage, AuthorizationContext authContext) {
        return this.chatMessageLocalizationService.localize(chatMessage, authContext.getProfileId(), authContext.getLocale());
    }

    private String localizeTitle(Chat chat, Profile oneOnOneChatPartner, AuthorizationContext authContext) {
        String string2;
        Chat chat2 = chat;
        if (chat2 instanceof MultiUserChat) {
            string2 = ((MultiUserChat)chat).getTitle();
        } else if (chat2 instanceof OneOnOneChat) {
            Object object = oneOnOneChatPartner;
            if (object == null || (object = object.getFullName()) == null) {
                object = this.resourceBundle.getMessage("chat.user.deleted", null, authContext.getLocale());
            }
            string2 = object;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"oneOnOneChatPartner?.ful\u2026text.locale\n            )");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private String localizeName(UserGroup userGroup, AuthorizationContext authContext) {
        String string2;
        if (userGroup.isAllTenantUsersGroup()) {
            String string3 = this.resourceBundle.getMessage("chat.group.allUsers", null, authContext.getLocale());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            resourceBu\u2026Context.locale)\n        }");
        } else {
            string2 = userGroup.getName();
        }
        return string2;
    }

    private MobileChat toMobileChat(Chat $this$toMobileChat, AuthorizationContext authContext) {
        return (MobileChat)CollectionsKt.first((List)this.toMobileChats((Iterable)CollectionsKt.listOf((Object)$this$toMobileChat), authContext));
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChat> toMobileChats(Iterable<? extends Chat> $this$toMobileChats, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        ChatTransformationContext context = this.fetchChatTransformationContext($this$toMobileChats, authContext);
        Iterable<? extends Chat> $this$map$iv = $this$toMobileChats;
        boolean $i$f$map = false;
        Iterable<? extends Chat> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Profile profile;
            ChatMessage lastMessage;
            ChatMessage chatMessage;
            ChatMessage chatMessage2;
            void chat;
            Chat chat2 = (Chat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (chat.getLastMessageId() != null) {
                ChatMessageId it;
                boolean bl2 = false;
                chatMessage2 = (ChatMessage)context.getLastMessages().get(it);
            } else {
                chatMessage2 = null;
            }
            if ((chatMessage = (lastMessage = chatMessage2)) != null && (chatMessage = chatMessage.getAuthor()) != null) {
                ChatMessage it = chatMessage;
                boolean bl3 = false;
                profile = (Profile)context.getLastMessageAuthors().get(it);
            } else {
                profile = null;
            }
            Profile lastMessageAuthor = profile;
            Profile oneOnOneChatPartner = (Profile)context.getOneOnOneChatPartners().get(chat.getId());
            ChatMessage chatMessage3 = lastMessage;
            collection.add(MobileChat.Companion.toMobileChat((Chat)chat, this.localizeTitle((Chat)chat, oneOnOneChatPartner, authContext), context.userPermissions(chat.getId()), context.userGroupPermissions(chat.getId()), oneOnOneChatPartner, (ChatReadDateAndCount)context.getChatsReadData().get(chat.getId()), chatMessage3 != null ? this.toTeaser(chatMessage3, (Chat)chat, authContext, lastMessageAuthor) : null, context.allowedActions((Chat)chat)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private ChatTransformationContext fetchChatTransformationContext(Iterable<? extends Chat> chats, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapToSet$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        Object item$iv$iv3;
        void $this$mapTo$iv$iv3;
        void $this$mapToSet$iv3;
        void $this$filterIsInstanceTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Iterable $this$mapToSet$iv4 = chats;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv4;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapToSet$iv4));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv4) {
            void p0;
            Chat chat = (Chat)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set chatIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = chats;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof OneOnOneChat)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapToSet2 = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$mapToSet$iv3;
        destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv3));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv3) {
            void p0;
            OneOnOneChat bl = (OneOnOneChat)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(p0.getId());
        }
        Set oneOnOneChatIds = (Set)destination$iv$iv2;
        Iterable $this$filterIsInstance$iv2 = chats;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv2;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MultiUserChat)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv3;
        boolean $i$f$mapToSet3 = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv2;
        destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv4 : $this$mapTo$iv$iv2) {
            void p0;
            MultiUserChat bl2 = (MultiUserChat)item$iv$iv4;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set multiUserChatIds = (Set)destination$iv$iv3;
        Map participantPermissionsByChatId = this.chatParticipantService.getParticipantPermissionsByChatIds((Iterable)chatIds);
        Map oneOnOneChatPartnersByChatId = this.chatParticipantService.getDirectChatPartnersForProfile(oneOnOneChatIds, authContext.getProfileId());
        destination$iv$iv3 = chats;
        collection = this.chatMessageService;
        boolean $i$f$mapNotNullToSet22 = false;
        item$iv$iv3 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv4 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatMessageId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Chat p0 = (Chat)element$iv$iv;
            boolean bl3 = false;
            if (p0.getLastMessageId() == null) continue;
            boolean bl4 = false;
            destination$iv$iv4.add(it$iv$iv);
        }
        Map lastMessageById = collection.findByIds((Set)destination$iv$iv4);
        Iterable $i$f$mapNotNullToSet22 = lastMessageById.values();
        collection = this.profileService;
        boolean $i$f$mapToSet4 = false;
        destination$iv$iv4 = $this$mapToSet$iv;
        Collection destination$iv$iv5 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv5 : $this$mapTo$iv$iv) {
            void p0;
            element$iv$iv$iv = (ChatMessage)item$iv$iv5;
            Collection collection2 = destination$iv$iv5;
            boolean bl = false;
            collection2.add(p0.getAuthor());
        }
        Map authorByProfileId = collection.findByIds((Set)destination$iv$iv5);
        Map chatsReadData = this.chatReadDateService.getReadData(authContext.getProfileId(), chatIds);
        Map multiUserChatAllowedActions = AuthorizationContext.toMultiUserChatsAllowedActions$default((AuthorizationContext)authContext, (Set)multiUserChatIds, null, null, (int)6, null);
        return new ChatTransformationContext(chatsReadData, oneOnOneChatPartnersByChatId, lastMessageById, authorByProfileId, participantPermissionsByChatId, multiUserChatAllowedActions);
    }

    private MobileChatList toMobileChatList(List<MobileChat> $this$toMobileChatList, AuthorizationContext authContext) {
        Iterable list$iv$iv;
        MobileChat it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMapToSet$iv;
        Iterable iterable = $this$toMobileChatList;
        Object object = this;
        List<MobileChat> list = $this$toMobileChatList;
        boolean $i$f$flatMapToSet = false;
        void var5_7 = $this$flatMapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MobileChat)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getUserParticipants().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set set = (Set)destination$iv$iv;
        Set set2 = CollectionsKt.toSet((Iterable)object.findUsersById(set, authContext).values());
        $this$flatMapToSet$iv = $this$toMobileChatList;
        set = this;
        object = set2;
        $i$f$flatMapToSet = false;
        $this$flatMapTo$iv$iv = $this$flatMapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MobileChat)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getUserGroupParticipants().keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set set3 = (Set)destination$iv$iv;
        Set set4 = CollectionsKt.toSet((Iterable)super.findUserGroupsById(set3, authContext).values());
        Object object2 = object;
        List<MobileChat> list2 = list;
        return new MobileChatList(list2, (Set)object2, set4);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ProfileId, MobileUser> findUsersById(Set<ProfileId> ids, AuthorizationContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map chattableById = authContext.mayReadProfiles(ids);
        Map map = this.profileService.findByIds(ids);
        boolean $i$f$mapValues = false;
        void var6_6 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Profile profile = (Profile)entry2.getValue();
            Boolean bl3 = (Boolean)chattableById.get(profile.getId());
            MobileUser mobileUser = MobileUser.Companion.toMobileUser(profile, bl3 != null ? bl3 : false);
            map3.put(k, mobileUser);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<UserGroupId, MobileUserGroup> findUserGroupsById(Set<UserGroupId> ids, AuthorizationContext authContext) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Map chattableById = authContext.mayReadUserGroups(ids);
        Set memberUserGroupIds = this.userGroupService.getUserGroupIdsByProfileId(authContext.getProfileId());
        Map map = this.userGroupService.findByIds(ids);
        boolean $i$f$mapValues = false;
        void var7_7 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            UserGroup userGroup = (UserGroup)entry2.getValue();
            Boolean bl3 = (Boolean)chattableById.get(userGroup.getId());
            MobileUserGroup mobileUserGroup = MobileUserGroup.Companion.toMobileUserGroup(userGroup, this.localizeName(userGroup, authContext), bl3 != null ? bl3 : false, memberUserGroupIds.contains(userGroup.getId()));
            map3.put(k, mobileUserGroup);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileUser> toMobileUsers(Iterable<CommonCoreSearchResult> $this$toMobileUsers) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable<CommonCoreSearchResult> $this$mapNotNullToSet$iv = $this$toMobileUsers;
        boolean $i$f$mapNotNullToSet = false;
        Iterable<CommonCoreSearchResult> iterable = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Profile profile = $this$forEach$iv$iv$iv.iterator();
        while (profile.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = profile.next();
            boolean bl = false;
            CommonCoreSearchResult p0 = (CommonCoreSearchResult)element$iv$iv;
            boolean bl2 = false;
            if (p0.getProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv;
        boolean $i$a$-let-MobileApplicationService$toMobileUsers$32 = false;
        Iterable $this$map$iv = CollectionUtilsKt.getNotNullValues((Map)this.profileService.findByIds(profileIds), (Collection)profileIds);
        boolean $i$f$map = false;
        Iterable $i$a$-let-MobileApplicationService$toMobileUsers$32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profile2;
            profile = (Profile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileUser.Companion.toMobileUser((Profile)profile2, true));
        }
        return (List)destination$iv$iv;
    }

    private String toTeaser(ChatMessage $this$toTeaser, Chat chat, AuthorizationContext authContext, Profile author) {
        return this.chatMessageLocalizationService.localizeTeaser($this$toTeaser, chat, author, authContext.getProfileId(), authContext.getLocale(), true);
    }

    private MobileChatMessage toMobileChatMessage(ChatMessage $this$toMobileChatMessage, AuthorizationContext authContext) {
        return MobileChatMessage.Companion.toMobileChatMessage($this$toMobileChatMessage, this.localizeMessage($this$toMobileChatMessage, authContext));
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> toChatUpdates(List<? extends Chat> $this$toChatUpdates, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.toMobileChats((Iterable)$this$toChatUpdates, authContext);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobileChat mobileChat = (MobileChat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange((MobileChat)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> toMessageUpdates(List<? extends ChatMessage> $this$toMessageUpdates, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toMessageUpdates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatMessage chatMessage = (ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange(this.toMobileChatMessage((ChatMessage)it, authContext)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> toUserUpdates(List<Profile> $this$toUserUpdates, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$mapToSet$iv = $this$toUserUpdates;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Profile profile = (Profile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set profileIds = (Set)destination$iv$iv;
        Map chattableById = authContext.mayReadProfiles(profileIds);
        Iterable $this$map$iv = $this$toUserUpdates;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profile;
            Profile bl = (Profile)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Boolean bl3 = (Boolean)chattableById.get(profile.getId());
            collection.add(MobileChange.Companion.toUpdateChange(MobileUser.Companion.toMobileUser((Profile)profile, bl3 != null ? bl3 : false)));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> toUserGroupUpdates(List<UserGroup> $this$toUserGroupUpdates, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$mapToSet$iv = $this$toUserGroupUpdates;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            UserGroup userGroup = (UserGroup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set userGroupIds = (Set)destination$iv$iv;
        Map chattableById = authContext.mayReadUserGroups(userGroupIds);
        Set memberUserGroupIds = this.userGroupService.getUserGroupIdsByProfileId(authContext.getProfileId());
        Iterable $this$map$iv = $this$toUserGroupUpdates;
        boolean $i$f$map = false;
        Iterable $i$f$mapTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void userGroup;
            UserGroup userGroup2 = (UserGroup)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Boolean bl2 = (Boolean)chattableById.get(userGroup.getId());
            collection.add(MobileChange.Companion.toUpdateChange(MobileUserGroup.Companion.toMobileUserGroup((UserGroup)userGroup, this.localizeName((UserGroup)userGroup, authContext), bl2 != null ? bl2 : false, memberUserGroupIds.contains(userGroup.getId()))));
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> toChatSettingsUpdates(List<ChatSettings> $this$toChatSettingsUpdates) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toChatSettingsUpdates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ChatSettings chatSettings = (ChatSettings)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange(MobileChatSettings.Companion.toMobileChatSettings((ChatSettings)it)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<MobileChange> toSettingsUpdates(List<MobileSetting> $this$toSettingsUpdates) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toSettingsUpdates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobileSetting mobileSetting = (MobileSetting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MobileChange.Companion.toUpdateChange((MobileSetting)it));
        }
        return (List)destination$iv$iv;
    }
}

