/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.business.ConfigService;
import de.justsoftware.chat.business.model.event.JustLicenseChangedEvent;
import de.justsoftware.chat.exception.JunoLoginException;
import de.justsoftware.chat.exception.JunoUnauthorizedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.mobile.service.JunoRestClientService;
import de.justsoftware.chat.mobile.service.JunoRestClientService$performLoginRequest$;
import de.justsoftware.chat.mobile.util.JunoUtilsKt;
import de.justsoftware.pushnotification.client.model.PushNotificationResults;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.netty.http.client.HttpClient;
import reactor.util.retry.Retry;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0014\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001cR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/chat/mobile/service/JunoRestClientService;", "", "junoBasePath", "", "httpClient", "Lreactor/netty/http/client/HttpClient;", "configService", "Lde/justsoftware/chat/business/ConfigService;", "(Ljava/lang/String;Lreactor/netty/http/client/HttpClient;Lde/justsoftware/chat/business/ConfigService;)V", "accessTokenResponse", "Lde/justsoftware/chat/mobile/service/JunoRestClientService$JunoOAuth2AccessTokenResponse;", "lastFatalLicenseError", "Lde/justsoftware/chat/exception/JunoLoginException$ErrorCode;", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "getAccessTokenResponse", "Lreactor/core/publisher/Mono;", "login", "logout", "", "onLicenseChanged", "event", "Lde/justsoftware/chat/business/model/event/JustLicenseChangedEvent;", "performLoginRequest", "license", "performSendPushNotificationsRequest", "Lde/justsoftware/pushnotification/client/model/PushNotificationResults;", "pushNotifications", "", "oauthToken", "sendPushNotifications", "Companion", "JunoOAuth2AccessTokenResponse", "chat-service"})
public final class JunoRestClientService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final WebClient webClient;
    @Nullable
    private volatile JunoOAuth2AccessTokenResponse accessTokenResponse;
    @Nullable
    private volatile JunoLoginException.ErrorCode lastFatalLicenseError;
    @NotNull
    private static final Logger LOG;

    public JunoRestClientService(@NotNull String junoBasePath, @NotNull HttpClient httpClient, @NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)junoBasePath, (String)"junoBasePath");
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"httpClient");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.configService = configService;
        String[] stringArray = new String[]{"application/json"};
        WebClient webClient = WebClient.builder().baseUrl(junoBasePath).defaultHeader("Accept", stringArray).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
        Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"builder()\n            .b\u2026nt))\n            .build()");
        this.webClient = webClient;
    }

    @NotNull
    public final PushNotificationResults sendPushNotifications(@NotNull List<? extends Object> pushNotifications) {
        Intrinsics.checkNotNullParameter(pushNotifications, (String)"pushNotifications");
        JunoLoginException.ErrorCode errorCode = this.lastFatalLicenseError;
        if (errorCode != null) {
            JunoLoginException.ErrorCode errorCode2 = errorCode;
            boolean bl = false;
            throw new JunoLoginException(errorCode2);
        }
        PushNotificationResults pushNotificationResults = (PushNotificationResults)this.getAccessTokenResponse().flatMap(arg_0 -> JunoRestClientService.sendPushNotifications$lambda-1(this, pushNotifications, arg_0)).retryWhen((Retry)Retry.max((long)1L).filter(JunoRestClientService::sendPushNotifications$lambda-2)).block();
        if (pushNotificationResults == null) {
            throw new NotFoundException("Juno did not return a result");
        }
        return pushNotificationResults;
    }

    private final Mono<PushNotificationResults> performSendPushNotificationsRequest(List<? extends Object> pushNotifications, JunoOAuth2AccessTokenResponse oauthToken) {
        String[] stringArray = new String[]{"application/json"};
        WebClient.RequestHeadersSpec requestHeadersSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/notification", new Object[0])).bodyValue(pushNotifications).header("Content-Type", stringArray);
        stringArray = new String[]{oauthToken.getTokenType() + " " + oauthToken.getAccessToken()};
        WebClient.ResponseSpec responseSpec = requestHeadersSpec.header("Authorization", stringArray).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), arg_0 -> JunoRestClientService.performSendPushNotificationsRequest$lambda-3(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"webClient\n            .p\u2026xception())\n            }");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono;
    }

    @EventListener
    public final void onLicenseChanged(@NotNull JustLicenseChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.lastFatalLicenseError != null) {
            LOG.info("Just license changed, retry logging into Juno");
            this.logout();
            this.lastFatalLicenseError = null;
        }
    }

    private final Mono<JunoOAuth2AccessTokenResponse> getAccessTokenResponse() {
        Mono mono = Mono.fromSupplier(() -> JunoRestClientService.getAccessTokenResponse$lambda-4(this)).filter(JunoRestClientService::getAccessTokenResponse$lambda-5);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromSupplier<JunoOAuth2A\u2026   .filter { it.isValid }");
        return MonoExtensionsKt.switchIfEmpty((Mono)mono, (Function0)((Function0)new /* Unavailable Anonymous Inner Class!! */));
    }

    private final Mono<JunoOAuth2AccessTokenResponse> login() {
        Mono mono = Mono.fromCallable(() -> ((ConfigService)this.configService).justLicense()).switchIfEmpty(Mono.error((Throwable)((Throwable)new JunoLoginException(JunoLoginException.ErrorCode.LICENSE_NOT_FOUND)))).flatMap(arg_0 -> this.performLoginRequest(arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"fromCallable<String>(con\u2026ap(::performLoginRequest)");
        return MonoExtensionsKt.doOnError((Mono)mono, (KClass)Reflection.getOrCreateKotlinClass(JunoLoginException.class), (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    private final Mono<JunoOAuth2AccessTokenResponse> performLoginRequest(String license) {
        WebClient.ResponseSpec responseSpec = ((WebClient.RequestBodySpec)this.webClient.post().uri("/login", new Object[0])).bodyValue((Object)license).retrieve().onStatus(arg_0 -> HttpStatus.UNAUTHORIZED.equals(arg_0), JunoRestClientService::performLoginRequest$lambda-6).onStatus(HttpStatus::isError, JunoRestClientService::performLoginRequest$lambda-7);
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"webClient\n            .p\u2026ption.ErrorCode.OTHER)) }");
        WebClient.ResponseSpec $this$bodyToMono$iv = responseSpec;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new performLoginRequest$$inlined$bodyToMono$1());
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono;
    }

    private final void logout() {
        this.accessTokenResponse = null;
    }

    private static final Mono sendPushNotifications$lambda-1(JunoRestClientService this$0, List $pushNotifications, JunoOAuth2AccessTokenResponse token) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pushNotifications, (String)"$pushNotifications");
        Intrinsics.checkNotNullExpressionValue((Object)token, (String)"token");
        return this$0.performSendPushNotificationsRequest($pushNotifications, token);
    }

    private static final boolean sendPushNotifications$lambda-2(Throwable it) {
        return it instanceof JunoUnauthorizedException;
    }

    private static final Mono performSendPushNotificationsRequest$lambda-3(JunoRestClientService this$0, ClientResponse it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.logout();
        return Mono.error((Throwable)((Throwable)new JunoUnauthorizedException()));
    }

    private static final JunoOAuth2AccessTokenResponse getAccessTokenResponse$lambda-4(JunoRestClientService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.accessTokenResponse;
    }

    private static final boolean getAccessTokenResponse$lambda-5(JunoOAuth2AccessTokenResponse it) {
        return it.isValid();
    }

    private static final Mono performLoginRequest$lambda-6(ClientResponse response) {
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        ClientResponse $this$bodyToMono$iv = response;
        boolean $i$f$bodyToMono = false;
        Mono mono = $this$bodyToMono$iv.bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        Intrinsics.checkExpressionValueIsNotNull((Object)mono, (String)"bodyToMono(object : Para\u2026zedTypeReference<T>() {})");
        return mono.map(JunoUtilsKt::toJunoLoginException);
    }

    private static final Mono performLoginRequest$lambda-7(ClientResponse it) {
        return Mono.error((Throwable)((Throwable)new JunoLoginException(JunoLoginException.ErrorCode.OTHER)));
    }

    public static final /* synthetic */ Mono access$login(JunoRestClientService $this) {
        return $this.login();
    }

    public static final /* synthetic */ void access$setAccessTokenResponse$p(JunoRestClientService $this, JunoOAuth2AccessTokenResponse junoOAuth2AccessTokenResponse) {
        $this.accessTokenResponse = junoOAuth2AccessTokenResponse;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setLastFatalLicenseError$p(JunoRestClientService $this, JunoLoginException.ErrorCode errorCode) {
        $this.lastFatalLicenseError = errorCode;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

