/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka.search;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.kafka.search.UpdateCommonSearchIndexProducer;
import de.justsoftware.chat.kafka.search.UpdateCommonSearchIndexType;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.toolbox.kafka.client.KafkaCleaningProducer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0011H\u0017J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0013H\u0017J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0017H\u0017J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/toolbox/kafka/client/KafkaCleaningProducer;", "", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "(Lde/justsoftware/toolbox/kafka/client/KafkaCleaningProducer;Lde/justsoftware/chat/business/ChatParticipantService;)V", "fullIndex", "", "ids", "", "Lde/justsoftware/chat/model/ChatId;", "handleChatCreated", "evt", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "handleChatMessageCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "handleChatParticipantsChanged", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "handleChatUpdated", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "handleProfileUpdated", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "send", "id", "type", "Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexType;", "Companion", "chat-service"})
public class UpdateCommonSearchIndexProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    public static final String TOPIC = "just.chat-service.search.common.updateIndex";

    public UpdateCommonSearchIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ChatParticipantService chatParticipantService) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        this.kafkaProducer = kafkaProducer;
        this.chatParticipantService = chatParticipantService;
    }

    @EventListener
    public void handleChatCreated(@NotNull ChatCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChat() instanceof MultiUserChat) {
            this.send(evt.getChatId(), UpdateCommonSearchIndexType.FULL_INDEX);
        }
    }

    @EventListener
    public void handleChatUpdated(@NotNull ChatUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getNewChat() instanceof OneOnOneChat && evt.getOldChat().getLastMessageId() == null && evt.getNewChat().getLastMessageId() != null) {
            this.send(evt.getChatId(), UpdateCommonSearchIndexType.FULL_INDEX);
        } else {
            this.send(evt.getChatId(), UpdateCommonSearchIndexType.BASE_DATA_UPDATE);
        }
    }

    @EventListener
    public void handleChatMessageCreatedEvent(@NotNull ChatMessageCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatMessage().getChatId(), UpdateCommonSearchIndexType.BASE_DATA_UPDATE);
    }

    @EventListener
    public void handleChatParticipantsChanged(@NotNull ChatParticipantsChangedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatId(), UpdateCommonSearchIndexType.PERMISSIONS_UPDATE);
    }

    @EventListener
    public void handleProfileUpdated(@NotNull ProfileUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = this.chatParticipantService.findOneOnOneChatIdsByProfileId(evt.getProfileId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId it = (ChatId)element$iv;
            boolean bl = false;
            this.send(it, UpdateCommonSearchIndexType.BASE_DATA_UPDATE);
        }
    }

    public void fullIndex(@NotNull Set<ChatId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId it = (ChatId)element$iv;
            boolean bl = false;
            this.send(it, UpdateCommonSearchIndexType.FULL_INDEX);
        }
    }

    private void send(ChatId id, UpdateCommonSearchIndexType type) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)id.toCanonicalId(), (Object)type.name()));
    }
}

