/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.kafka.AbstractKafkaConsumer;
import de.justsoftware.chat.kafka.KafkaConsumerContext;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.ProfileKafkaConsumer;
import de.justsoftware.chat.kafka.model.KafkaProfile;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00172\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0017B)\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ)\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0010\u00a2\u0006\u0002\b\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/chat/kafka/ProfileKafkaConsumer;", "Lde/justsoftware/chat/kafka/AbstractKafkaConsumer;", "", "Lde/justsoftware/chat/kafka/model/KafkaProfile;", "bootstrapServers", "maxChunkSize", "", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "clock", "Ljava/time/Clock;", "(Ljava/lang/String;ILde/justsoftware/chat/business/ProfileService;Ljava/time/Clock;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "process", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "context", "Lde/justsoftware/chat/kafka/KafkaConsumerContext;", "process$chat_service", "Companion", "chat-service"})
public class ProfileKafkaConsumer
extends AbstractKafkaConsumer<String, KafkaProfile> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String bootstrapServers;
    private final int maxChunkSize;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final Clock clock;
    @NotNull
    public static final String TOPIC = "just.persons";
    @NotNull
    private static final Logger LOG;

    public ProfileKafkaConsumer(@Value(value="${kafka.bootstrap-servers:localhost:9092}") @NotNull String bootstrapServers, @Value(value="${kafka.consumer-max-chunk-size:100}") int maxChunkSize, @NotNull ProfileService profileService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(Companion.createConsumer(bootstrapServers, maxChunkSize, (ObjectMapper)KafkaObjectMapper.INSTANCE), SetsKt.setOf((Object)TOPIC));
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
        this.profileService = profileService;
        this.clock = clock;
    }

    @NotNull
    protected Logger getLog() {
        return LOG;
    }

    public void process$chat_service(@NotNull ConsumerRecords<String, KafkaProfile> records, @NotNull KafkaConsumerContext context) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                KafkaProfile kafkaProfile = (KafkaProfile)record.value();
                Intrinsics.checkNotNullExpressionValue((Object)kafkaProfile, (String)"kafkaProfile");
                this.profileService.save(KafkaProfile.Companion.toProfile(kafkaProfile, this.clock));
            }
            catch (RuntimeException e) {
                LOG.error("Failed to save or update profile with id = " + ((KafkaProfile)record.value()).getId() + ". Skip this record.", (Throwable)e);
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

