/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.controller;

import de.justsoftware.chat.application.PermissionApplicationService;
import de.justsoftware.chat.application.SettingsApplicationService;
import de.justsoftware.chat.application.XmppApplicationService;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.chat.util.CollectionUtilsKt;
import io.swagger.v3.oas.annotations.Hidden;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Hidden
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0017J\u0012\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J\u0012\u0010\u0010\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0017J$\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u00122\u000e\b\u0001\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015H\u0017J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0017J\b\u0010\u0018\u001a\u00020\fH\u0017J\b\u0010\u0019\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/chat/controller/InternalController;", "", "permissionApplicationService", "Lde/justsoftware/chat/application/PermissionApplicationService;", "xmppApplicationService", "Lde/justsoftware/chat/application/XmppApplicationService;", "solrIndexService", "Lde/justsoftware/chat/search/SolrIndexService;", "settingsApplicationService", "Lde/justsoftware/chat/application/SettingsApplicationService;", "(Lde/justsoftware/chat/application/PermissionApplicationService;Lde/justsoftware/chat/application/XmppApplicationService;Lde/justsoftware/chat/search/SolrIndexService;Lde/justsoftware/chat/application/SettingsApplicationService;)V", "clearAndSyncChatNodes", "", "disableChatNotifications", "personId", "", "enableChatNotifications", "getChatNotifications", "", "", "personIds", "", "publishAllPermissions", "Lkotlin/Function0;", "reindexAll", "reindexChats", "chat-service"})
public class InternalController {
    @NotNull
    private final PermissionApplicationService permissionApplicationService;
    @NotNull
    private final XmppApplicationService xmppApplicationService;
    @NotNull
    private final SolrIndexService solrIndexService;
    @NotNull
    private final SettingsApplicationService settingsApplicationService;

    public InternalController(@NotNull PermissionApplicationService permissionApplicationService, @NotNull XmppApplicationService xmppApplicationService, @NotNull SolrIndexService solrIndexService, @NotNull SettingsApplicationService settingsApplicationService) {
        Intrinsics.checkNotNullParameter((Object)permissionApplicationService, (String)"permissionApplicationService");
        Intrinsics.checkNotNullParameter((Object)xmppApplicationService, (String)"xmppApplicationService");
        Intrinsics.checkNotNullParameter((Object)solrIndexService, (String)"solrIndexService");
        Intrinsics.checkNotNullParameter((Object)settingsApplicationService, (String)"settingsApplicationService");
        this.permissionApplicationService = permissionApplicationService;
        this.xmppApplicationService = xmppApplicationService;
        this.solrIndexService = solrIndexService;
        this.settingsApplicationService = settingsApplicationService;
    }

    @PostMapping(value={"publish/permissions"})
    @NotNull
    public Function0<Unit> publishAllPermissions() {
        return this.permissionApplicationService.republishPermissions();
    }

    @PostMapping(value={"xmpp/resyncChatNodes"})
    public void clearAndSyncChatNodes() {
        this.xmppApplicationService.clearAndSyncChatNodes();
    }

    @PostMapping(value={"search/reindexAll"})
    public void reindexAll() {
        this.solrIndexService.reindexAll();
    }

    @PostMapping(value={"search/reindexChats"})
    public void reindexChats() {
        this.solrIndexService.reindexChatsInCommonCore();
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"settings/chatNotifications"})
    @NotNull
    public Map<Long, Boolean> getChatNotifications(@RequestBody @NotNull List<Long> personIds) {
        void $this$mapKeysTo$iv$iv;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(personIds, (String)"personIds");
        Iterable iterable = personIds;
        Object object = this.settingsApplicationService;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p0;
            Object item$iv$iv = iterator.next();
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ProfileId((long)p0));
        }
        Map $this$mapKeys$iv = object.getMailDeliveryEnabledSettingsForProfileIds((Set)destination$iv$iv);
        boolean $i$f$mapKeys = false;
        $this$mapTo$iv$iv = $this$mapKeys$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            ProfileId profileId = (ProfileId)entry.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Long l = (long)profileId.getValue();
            Object object2 = object;
            boolean bl2 = false;
            entry = it$iv$iv.getValue();
            object2.put(l, entry);
        }
        return destination$iv$iv;
    }

    @PostMapping(value={"settings/chatNotifications/{personId}/enable"})
    public void enableChatNotifications(@PathVariable(value="personId") long personId) {
        this.settingsApplicationService.saveMailDeliveryEnabledSettingForProfile(new ProfileId(personId), true);
    }

    @PostMapping(value={"settings/chatNotifications/{personId}/disable"})
    public void disableChatNotifications(@PathVariable(value="personId") long personId) {
        this.settingsApplicationService.saveMailDeliveryEnabledSettingForProfile(new ProfileId(personId), false);
    }
}

