/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config.security;

import de.justsoftware.chat.config.security.JustOpaqueTokenIntrospector;
import de.justsoftware.chat.config.security.WebSecurityConfiguration;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.Filter;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@EnableWebSecurity
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \r2\u00020\u0001:\u0001\rB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/chat/config/security/WebSecurityConfiguration;", "Lorg/springframework/security/config/annotation/web/configuration/WebSecurityConfigurerAdapter;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "checkTokenEndpoint", "", "clientId", "clientSecret", "(Lde/justsoftware/jwtfilter/verifier/JwtVerifier;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "configure", "", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "Companion", "chat-service"})
public class WebSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JwtVerifier jwtVerifier;
    @NotNull
    private final String checkTokenEndpoint;
    @NotNull
    private final String clientId;
    @NotNull
    private final String clientSecret;
    @NotNull
    private static final String INTERNAL_API = "/internal/**";
    @NotNull
    private static final String[] SWAGGER_RESOURCES;

    public WebSecurityConfiguration(@NotNull JwtVerifier jwtVerifier, @Value(value="${just.chat.oauth2.resource.check-token-endpoint}") @NotNull String checkTokenEndpoint, @Value(value="${just.chat.oauth2.resource.client-id}") @NotNull String clientId, @Value(value="${just.chat.oauth2.resource.client-secret}") @NotNull String clientSecret) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)checkTokenEndpoint, (String)"checkTokenEndpoint");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        super(true);
        this.jwtVerifier = jwtVerifier;
        this.checkTokenEndpoint = checkTokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    /*
     * WARNING - void declaration
     */
    protected void configure(@NotNull HttpSecurity http) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Object[] objectArray = ArraysKt.plus((Object[])SWAGGER_RESOURCES, (Object)INTERNAL_API);
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter = new JwtAuthenticationProcessingFilter(this.jwtVerifier);
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AntPathRequestMatcher((String)p0));
        }
        List list = (List)destination$iv$iv;
        JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter2 = jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((RequestMatcher)new OrRequestMatcher(list));
        Intrinsics.checkNotNullExpressionValue((Object)jwtAuthenticationProcessingFilter2, (String)"JwtAuthenticationProcess\u2026)\n            )\n        )");
        JwtAuthenticationProcessingFilter jwt = jwtAuthenticationProcessingFilter2;
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.requestMatchers().and().sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().and()).headers().cacheControl().and().and()).anonymous().and()).authorizeRequests();
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)SWAGGER_RESOURCES);
        spreadBuilder.add((Object)INTERNAL_API);
        ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]))).permitAll().and()).authorizeRequests().anyRequest()).fullyAuthenticated().and()).oauth2ResourceServer(arg_0 -> WebSecurityConfiguration.configure$lambda-1(this, arg_0)).addFilterAfter((Filter)jwt, AbstractPreAuthenticatedProcessingFilter.class);
    }

    private static final void configure$lambda-1$lambda-0(WebSecurityConfiguration this$0, OAuth2ResourceServerConfigurer.OpaqueTokenConfigurer opaqueTokenCustomizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        JustOpaqueTokenIntrospector justTokenIntrospector = new JustOpaqueTokenIntrospector(this$0.checkTokenEndpoint, this$0.clientId, this$0.clientSecret);
        opaqueTokenCustomizer.introspector((OpaqueTokenIntrospector)justTokenIntrospector);
    }

    private static final void configure$lambda-1(WebSecurityConfiguration this$0, OAuth2ResourceServerConfigurer resourceServerCustomizer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        resourceServerCustomizer.opaqueToken(arg_0 -> WebSecurityConfiguration.configure$lambda-1$lambda-0(this$0, arg_0));
    }

    static {
        String[] stringArray = new String[]{"/v3/api-docs/**", "/swagger-ui/**"};
        SWAGGER_RESOURCES = stringArray;
    }
}

