/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config.security;

import de.justsoftware.chat.config.security.JwtConfiguration;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.generator.JwtGenerators;
import de.justsoftware.jwtfilter.keys.PublicKeyCache;
import de.justsoftware.jwtfilter.keys.SecretKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\t\u001a\u00020\nH\u0011\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\nH\u0011\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u000fH\u0011\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/chat/config/security/JwtConfiguration;", "", "environment", "Lorg/springframework/core/env/Environment;", "(Lorg/springframework/core/env/Environment;)V", "ejabberdJwtSecretKeyCache", "Lde/justsoftware/jwtfilter/keys/SecretKeyCache;", "publicKeyCache", "Lde/justsoftware/jwtfilter/keys/PublicKeyCache;", "ejabberdJwtGenerator", "Lde/justsoftware/jwtfilter/generator/JwtGenerator;", "ejabberdJwtGenerator$chat_service", "jwtGenerator", "jwtGenerator$chat_service", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "jwtVerifier$chat_service", "Companion", "chat-service"})
public class JwtConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublicKeyCache publicKeyCache;
    @NotNull
    private final SecretKeyCache ejabberdJwtSecretKeyCache;
    @NotNull
    private static final String ENVIRONMENT_KEY_FOR_JWT_PUBLIC_KEY = "jwt.publicKey";
    @NotNull
    private static final String ENVIRONMENT_KEY_FOR_JWT_PRIVATE_KEY = "jwt.privateKey";
    @NotNull
    private static final String ENVIRONMENT_KEY_FOR_EJABBERD_JWT_SECRET_KEY = "jwt.ejabberd.secretKey";
    public static final long DEFAULT_LIFETIME = 120L;

    public JwtConfiguration(@NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Function0 privateKeyProvider2 = (Function0)new /* Unavailable Anonymous Inner Class!! */;
        Function0 publicKeyProvider2 = (Function0)new /* Unavailable Anonymous Inner Class!! */;
        this.publicKeyCache = new PublicKeyCache(() -> JwtConfiguration._init_$lambda-0(privateKeyProvider2), () -> JwtConfiguration._init_$lambda-1(publicKeyProvider2));
        this.ejabberdJwtSecretKeyCache = new SecretKeyCache(() -> JwtConfiguration._init_$lambda-3(environment));
    }

    @Bean
    @Primary
    @NotNull
    public JwtGenerator jwtGenerator$chat_service() {
        JwtGenerator jwtGenerator = JwtGenerators.createEncryptedJwtGenerator((PublicKeyCache)this.publicKeyCache);
        Intrinsics.checkNotNullExpressionValue((Object)jwtGenerator, (String)"createEncryptedJwtGenerator(publicKeyCache)");
        return jwtGenerator;
    }

    @Bean
    @Primary
    @NotNull
    public JwtVerifier jwtVerifier$chat_service() {
        JwtVerifier jwtVerifier = JwtVerifiers.createEncryptedTokenVerifier((PublicKeyCache)this.publicKeyCache);
        Intrinsics.checkNotNullExpressionValue((Object)jwtVerifier, (String)"createEncryptedTokenVerifier(publicKeyCache)");
        return jwtVerifier;
    }

    @Bean(value={"ejabberdJwtGenerator"})
    @NotNull
    public JwtGenerator ejabberdJwtGenerator$chat_service() {
        JwtGenerator jwtGenerator = JwtGenerators.createPlaintextSignedJwtGenerator((SecretKeyCache)this.ejabberdJwtSecretKeyCache);
        Intrinsics.checkNotNullExpressionValue((Object)jwtGenerator, (String)"createPlaintextSignedJwt\u2026jabberdJwtSecretKeyCache)");
        return jwtGenerator;
    }

    private static final Optional _init_$lambda-0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke();
    }

    private static final Optional _init_$lambda-1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke();
    }

    private static final byte[] lambda-3$lambda-2(String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return Companion.access$base64Decode((Companion)Companion, (String)it);
    }

    private static final Optional _init_$lambda-3(Environment $environment) {
        Intrinsics.checkNotNullParameter((Object)$environment, (String)"$environment");
        return Optional.ofNullable($environment.getProperty("jwt.ejabberd.secretKey")).map(JwtConfiguration::lambda-3$lambda-2);
    }
}

