/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.business.ConfigService;
import de.justsoftware.chat.business.MailService;
import de.justsoftware.chat.config.MailScheduler;
import de.justsoftware.chat.model.ClusterPosition;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0012J\"\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0092\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/chat/config/MailScheduler;", "", "taskScheduler", "Lorg/springframework/scheduling/TaskScheduler;", "configService", "Lde/justsoftware/chat/business/ConfigService;", "mailService", "Lde/justsoftware/chat/business/MailService;", "clusterPosition", "Lde/justsoftware/chat/model/ClusterPosition;", "(Lorg/springframework/scheduling/TaskScheduler;Lde/justsoftware/chat/business/ConfigService;Lde/justsoftware/chat/business/MailService;Lde/justsoftware/chat/model/ClusterPosition;)V", "scheduledThread", "Ljava/util/concurrent/ScheduledFuture;", "startMailCron", "", "schedule", "cronExpression", "", "task", "Ljava/lang/Runnable;", "Companion", "chat-service"})
public class MailScheduler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final TaskScheduler taskScheduler;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private final MailService mailService;
    @NotNull
    private final ClusterPosition clusterPosition;
    @Nullable
    private ScheduledFuture<?> scheduledThread;
    @NotNull
    private static final Logger LOG;

    public MailScheduler(@NotNull TaskScheduler taskScheduler, @NotNull ConfigService configService, @NotNull MailService mailService, @Value(value="${service.cluster-position}") @NotNull ClusterPosition clusterPosition) {
        Intrinsics.checkNotNullParameter((Object)taskScheduler, (String)"taskScheduler");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)mailService, (String)"mailService");
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        this.taskScheduler = taskScheduler;
        this.configService = configService;
        this.mailService = mailService;
        this.clusterPosition = clusterPosition;
        if (this.clusterPosition == ClusterPosition.PRIMARY) {
            this.configService.addMailCronExpressionListener(() -> MailScheduler._init_$lambda-0(this));
            this.startMailCron();
        }
    }

    private void startMailCron() {
        ScheduledFuture scheduledFuture = this.scheduledThread;
        if (scheduledFuture != null) {
            ScheduledFuture scheduledFuture2 = scheduledFuture;
            boolean bl = false;
            scheduledFuture2.cancel(false);
            LOG.info("Active MailCron was canceled due to a Zookeeper change.");
        }
        String string2 = this.configService.mailCronExpression();
        if (string2 == null) {
            MailScheduler $this$startMailCron_u24lambda_u2d2 = this;
            boolean bl = false;
            LOG.info("Cron expression is empty. MailCron won't be started.");
            return;
        }
        String cronExpression = string2;
        LOG.info("Starting MailCron with {}.", (Object)cronExpression);
        this.scheduledThread = this.schedule(this.taskScheduler, cronExpression, () -> MailScheduler.startMailCron$lambda-3(this));
    }

    private ScheduledFuture<?> schedule(TaskScheduler $this$schedule, String cronExpression, Runnable task) {
        ScheduledFuture scheduledFuture;
        try {
            scheduledFuture = $this$schedule.schedule(task, (Trigger)new CronTrigger(cronExpression));
        }
        catch (IllegalArgumentException e) {
            LOG.error("An illegal argument exception was raised. Make sure the supplied cron expression is valid.", (Throwable)e);
            scheduledFuture = null;
        }
        return scheduledFuture;
    }

    private static final void _init_$lambda-0(MailScheduler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.startMailCron();
    }

    private static final void startMailCron$lambda-3(MailScheduler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LOG.info("Starting MailCron job...");
        long numberOfSentMails = this$0.mailService.sendUnreadChatMails();
        LOG.info("MailCron job finished. " + numberOfSentMails + " mails were sent.");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

