/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.config.ApplicationConfiguration;
import de.justsoftware.chat.config.AuthorizationContextResolver;
import de.justsoftware.chat.config.ChatWebConfig;
import de.justsoftware.chat.config.MobileAppVersionCheckInterceptor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleContextResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;

@Configuration
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/chat/config/ChatWebConfig;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "toroBaseUrl", "", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Lde/justsoftware/chat/authorization/AuthorizationService;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "addArgumentResolvers", "", "argumentResolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "addInterceptors", "registry", "Lorg/springframework/web/servlet/config/annotation/InterceptorRegistry;", "getLocaleContextResolver", "Lorg/springframework/web/servlet/LocaleContextResolver;", "Companion", "chat-service"})
public class ChatWebConfig
implements WebMvcConfigurer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private static final String LOCALE_COOKIE_NAME = "jc_locale";

    public ChatWebConfig(@Value(value="${just.toro.internal.baseurl}") @NotNull String toroBaseUrl, @NotNull AuthorizationService authorizationService, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.toroBaseUrl = toroBaseUrl;
        this.authorizationService = authorizationService;
        this.objectMapper = objectMapper;
    }

    public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> argumentResolvers) {
        Intrinsics.checkNotNullParameter(argumentResolvers, (String)"argumentResolvers");
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthorizationContextResolver(this.toroBaseUrl, this.authorizationService, this.getLocaleContextResolver(), this.objectMapper, null, 16, null));
    }

    public void addInterceptors(@NotNull InterceptorRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String[] stringArray = new String[]{"/api/mobile/**"};
        registry.addInterceptor((HandlerInterceptor)MobileAppVersionCheckInterceptor.INSTANCE).addPathPatterns(stringArray);
    }

    private LocaleContextResolver getLocaleContextResolver() {
        CookieLocaleResolver cookieLocaleResolver;
        CookieLocaleResolver $this$getLocaleContextResolver_u24lambda_u2d0 = cookieLocaleResolver = new CookieLocaleResolver();
        boolean bl = false;
        $this$getLocaleContextResolver_u24lambda_u2d0.setDefaultLocale(ApplicationConfiguration.Companion.getDEFAULT_LOCALE());
        $this$getLocaleContextResolver_u24lambda_u2d0.setCookieName(LOCALE_COOKIE_NAME);
        return (LocaleContextResolver)cookieLocaleResolver;
    }
}

