/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import de.justsoftware.chat.cache.CachedResults;
import de.justsoftware.chat.extension.MapExtensionKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u0018BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012$\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\fR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\n\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/chat/cache/CachedResults;", "K", "V", "", "cacheName", "", "expire", "Ljava/time/Duration;", "maxSize", "", "loader", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;Ljava/time/Duration;JLkotlin/jvm/functions/Function1;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "keys", "invalidateAll", "", "invalidateKeys", "Companion", "chat-service"})
public final class CachedResults<K, V> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String cacheName;
    @NotNull
    private final Function1<Set<? extends K>, Map<K, V>> loader;
    @NotNull
    private final Cache<K, V> cache;
    @NotNull
    private static final Logger LOG;

    public CachedResults(@NotNull String cacheName, @NotNull Duration expire, long maxSize, @NotNull Function1<? super Set<? extends K>, ? extends Map<K, ? extends V>> loader) {
        Intrinsics.checkNotNullParameter((Object)cacheName, (String)"cacheName");
        Intrinsics.checkNotNullParameter((Object)expire, (String)"expire");
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        this.cacheName = cacheName;
        this.loader = loader;
        Cache cache = Caffeine.newBuilder().softValues().expireAfterWrite(expire).maximumSize(maxSize).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder()\n        .so\u2026maxSize)\n        .build()");
        this.cache = cache;
    }

    public /* synthetic */ CachedResults(String string2, Duration duration, long l, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            int $this$days$iv = 1;
            boolean $i$f$getDays = false;
            long $this$days$iv$iv = $this$days$iv;
            boolean $i$f$getDays2 = false;
            Duration duration2 = Duration.ofDays($this$days$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofDays(this)");
            duration = duration2;
        }
        if ((n & 4) != 0) {
            l = 10000L;
        }
        this(string2, duration, l, function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<K, V> get(@NotNull Set<? extends K> keys) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$associateWith$iv = keys;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator.next();
            Object t2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object object = this.cache.getIfPresent((Object)it);
            map.put(t2, object);
        }
        Map cached = MapExtensionKt.filterNullValues((Map)result$iv);
        if (cached.size() == keys.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache '" + this.cacheName + "' has a full hit for " + keys);
            }
            return cached;
        }
        Iterable $this$filter$iv = keys;
        boolean $i$f$filter = false;
        $this$associateWithTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(!cached.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set keysToLoad = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map loaded = (Map)this.loader.invoke((Object)keysToLoad);
        this.cache.putAll(loaded);
        return MapsKt.plus((Map)loaded, (Map)cached);
    }

    @Nullable
    public final V get(K key) {
        return this.get(SetsKt.setOf(key)).get(key);
    }

    public final void invalidateKeys(@NotNull Set<? extends K> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.cache.invalidate(it);
        }
    }

    public final void invalidateAll() {
        this.cache.invalidateAll();
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

