/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.business.model.UserGroupMember;
import de.justsoftware.chat.cache.CachedResults;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.UserGroupMemberRepository;
import de.justsoftware.chat.persistence.UserGroupRepository;
import de.justsoftware.chat.persistence.model.DbUserGroup;
import de.justsoftware.chat.persistence.model.DbUserGroupMember;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0016\u0010\u0013\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00180\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0016J(\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000e0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eH\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018H\u0017J\u0016\u0010$\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J$\u0010%\u001a\u00020\u00102\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/justsoftware/chat/business/UserGroupService;", "", "userGroupRepository", "Lde/justsoftware/chat/persistence/UserGroupRepository;", "userGroupMemberRepository", "Lde/justsoftware/chat/persistence/UserGroupMemberRepository;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/chat/persistence/UserGroupRepository;Lde/justsoftware/chat/persistence/UserGroupMemberRepository;Lde/justsoftware/chat/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "userGroupIdsByProfileIdCache", "Lde/justsoftware/chat/cache/CachedResults;", "", "", "deleteById", "", "groupId", "Lde/justsoftware/chat/model/UserGroupId;", "deleteMembers", "members", "", "Lde/justsoftware/chat/business/model/UserGroupMember;", "findAllUsersGroup", "Lde/justsoftware/chat/business/model/UserGroup;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "findByIds", "", "userGroupIds", "getUserGroupIdsByProfileId", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "getUserGroupMembersByUserGroupIds", "save", "group", "saveMembers", "updateMembers", "membersToSave", "membersToDelete", "chat-service"})
public class UserGroupService {
    @NotNull
    private final UserGroupRepository userGroupRepository;
    @NotNull
    private final UserGroupMemberRepository userGroupMemberRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final CachedResults<String, Set<String>> userGroupIdsByProfileIdCache;

    public UserGroupService(@NotNull UserGroupRepository userGroupRepository, @NotNull UserGroupMemberRepository userGroupMemberRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)userGroupRepository, (String)"userGroupRepository");
        Intrinsics.checkNotNullParameter((Object)userGroupMemberRepository, (String)"userGroupMemberRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.userGroupRepository = userGroupRepository;
        this.userGroupMemberRepository = userGroupMemberRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.userGroupIdsByProfileIdCache = new CachedResults("UserGroupIdsByProfileIdCache", null, 0L, (Function1)new /* Unavailable Anonymous Inner Class!! */, 6, null);
    }

    @Transactional
    @NotNull
    public UserGroup save(@NotNull UserGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Object object = this.userGroupRepository.save((Object)DbUserGroup.Companion.toDbUserGroup(group));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"userGroupRepository\n    \u2026ve(group.toDbUserGroup())");
        return DbUserGroup.Companion.toUserGroup((DbUserGroup)object);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteById(@NotNull UserGroupId groupId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Iterable $this$mapToSet$iv = this.userGroupMemberRepository.findUserGroupMembersByGroupIds((Iterable)SetsKt.setOf((Object)groupId.toCanonicalId())).getOrDefault(groupId.toCanonicalId(), SetsKt.emptySet());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbUserGroupMember.Companion.toUserGroupMember((DbUserGroupMember)it));
        }
        Set userGroupMembers = (Set)destination$iv$iv;
        this.userGroupRepository.deleteById((Object)groupId.toCanonicalId());
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void saveMembers(@NotNull List<UserGroupMember> members) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Iterable iterable = members;
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbUserGroupMember.Companion.toDbUserGroupMember((UserGroupMember)it));
        }
        userGroupMemberRepository.saveAll((Iterable)((List)destination$iv$iv));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void deleteMembers(@NotNull List<UserGroupMember> members) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(members, (String)"members");
        Iterable iterable = members;
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbUserGroupMember.Companion.toDbUserGroupMember((UserGroupMember)it));
        }
        userGroupMemberRepository.deleteAll((Iterable)((List)destination$iv$iv));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void updateMembers(@NotNull List<UserGroupMember> membersToSave, @NotNull List<UserGroupMember> membersToDelete) {
        Intrinsics.checkNotNullParameter(membersToSave, (String)"membersToSave");
        Intrinsics.checkNotNullParameter(membersToDelete, (String)"membersToDelete");
        if (!((Collection)membersToSave).isEmpty()) {
            this.saveMembers(membersToSave);
        }
        if (!((Collection)membersToDelete).isEmpty()) {
            this.deleteMembers(membersToDelete);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, UserGroup> findByIds(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable iterable = userGroupIds;
        Object object = this.userGroupRepository;
        boolean $i$f$map22 = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"userGroupRepository\n    \u2026rGroupId::toCanonicalId))");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void dbUserGroup;
            Object item$iv$iv2;
            item$iv$iv2 = (DbUserGroup)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)dbUserGroup, (String)"dbUserGroup");
            object.add(DbUserGroup.Companion.toUserGroup((DbUserGroup)dbUserGroup));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            UserGroup bl = (UserGroup)element$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv22;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UserGroupId> getUserGroupIdsByProfileId(@NotNull ProfileId profileId) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Set set = (Set)this.userGroupIdsByProfileIdCache.get((Object)profileId.toCanonicalId());
        if (set == null) {
            set = SetsKt.emptySet();
        }
        Iterable iterable = set;
        UserGroupId.Companion companion = UserGroupId.Companion;
        boolean $i$f$mapToSet = false;
        void var5_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(companion.fromCanonicalId((String)p0));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<UserGroupId, Set<UserGroupMember>> getUserGroupMembersByUserGroupIds(@NotNull Set<UserGroupId> userGroupIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        Iterable iterable = userGroupIds;
        UserGroupMemberRepository userGroupMemberRepository = this.userGroupMemberRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UserGroupId userGroupId = (UserGroupId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = userGroupMemberRepository.findUserGroupMembersByGroupIds((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$mapToSet$iv;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String userGroupId = (String)entry.getKey();
            Set userGroupMembers = (Set)entry.getValue();
            Iterable iterable2 = userGroupMembers;
            UserGroupId userGroupId2 = UserGroupId.Companion.fromCanonicalId(userGroupId);
            boolean $i$f$mapToSet = false;
            void var18_24 = $this$mapToSet$iv;
            Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbUserGroupMember dbUserGroupMember = (DbUserGroupMember)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(DbUserGroupMember.Companion.toUserGroupMember((DbUserGroupMember)it));
            }
            entry = TuplesKt.to((Object)userGroupId2, (Object)((Set)destination$iv$iv3));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public UserGroup findAllUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        DbUserGroup dbUserGroup = this.userGroupRepository.findOneByTenantIdAndIsAllTenantUsersGroupTrue(tenantId.getValue());
        return dbUserGroup != null ? DbUserGroup.Companion.toUserGroup(dbUserGroup) : null;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(UserGroupService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ CachedResults access$getUserGroupIdsByProfileIdCache$p(UserGroupService $this) {
        return $this.userGroupIdsByProfileIdCache;
    }
}

