/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.persistence.ProfileRepository;
import de.justsoftware.chat.persistence.model.DbProfile;
import de.justsoftware.chat.util.TransactionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0012J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0017J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/chat/business/ProfileService;", "", "profileRepository", "Lde/justsoftware/chat/persistence/ProfileRepository;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/chat/persistence/ProfileRepository;Lde/justsoftware/chat/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;)V", "findByIds", "", "Lde/justsoftware/chat/model/ProfileId;", "Lde/justsoftware/chat/business/model/Profile;", "profileIds", "", "fireUpdateEventAfterCommit", "", "savedProfile", "getById", "id", "save", "profile", "updateImageUrl", "imageUrl", "", "chat-service"})
public class ProfileService {
    @NotNull
    private final ProfileRepository profileRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;

    public ProfileService(@NotNull ProfileRepository profileRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.profileRepository = profileRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Transactional
    @NotNull
    public Profile save(@NotNull Profile profile) {
        Profile profile2;
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Object object = this.profileRepository.save((Object)DbProfile.Companion.toDbProfile(profile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"profileRepository\n      \u2026ve(profile.toDbProfile())");
        Profile p0 = profile2 = DbProfile.Companion.toProfile((DbProfile)object);
        boolean bl = false;
        this.fireUpdateEventAfterCommit(p0);
        return profile2;
    }

    private void fireUpdateEventAfterCommit(Profile savedProfile) {
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> findByIds(@NotNull Set<ProfileId> profileIds) {
        void $this$associateByTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        Object object = this.profileRepository;
        boolean $i$f$map22 = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"profileRepository\n      \u2026rofileId::toCanonicalId))");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (DbProfile)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            object.add(DbProfile.Companion.toProfile((DbProfile)it));
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv2;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            Profile bl = (Profile)element$iv$iv;
            object = destination$iv$iv22;
            boolean bl2 = false;
            object.put(p0.getId(), element$iv$iv);
        }
        return destination$iv$iv22;
    }

    @NotNull
    public Profile getById(@NotNull ProfileId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Profile profile = this.profileRepository.findById((Object)id.toCanonicalId()).map(ProfileService::getById$lambda-3).orElseThrow(() -> ProfileService.getById$lambda-4(id));
        Intrinsics.checkNotNullExpressionValue((Object)profile, (String)"profileRepository\n      \u2026d $id does not exist.\") }");
        return profile;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Profile updateImageUrl(@NotNull ProfileId id, @NotNull String imageUrl) {
        Profile profile;
        void dbProfile;
        DbProfile $this$updateImageUrl_u24lambda_u2d6;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)imageUrl, (String)"imageUrl");
        Object t = this.profileRepository.findById((Object)id.toCanonicalId()).orElseThrow(() -> ProfileService.updateImageUrl$lambda-5(id));
        DbProfile dbProfile2 = (DbProfile)t;
        DbProfile.Companion companion = DbProfile.Companion;
        boolean bl = false;
        $this$updateImageUrl_u24lambda_u2d6.setImageUrl(imageUrl);
        $this$updateImageUrl_u24lambda_u2d6 = (DbProfile)t;
        boolean bl2 = false;
        DbProfile dbProfile3 = (DbProfile)this.profileRepository.save((Object)dbProfile);
        Intrinsics.checkNotNullExpressionValue((Object)dbProfile3, (String)"profileRepository\n      \u2026ository.save(dbProfile) }");
        Profile p0 = profile = companion.toProfile(dbProfile3);
        boolean bl3 = false;
        this.fireUpdateEventAfterCommit(p0);
        return profile;
    }

    private static final Profile getById$lambda-3(DbProfile it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbProfile.Companion.toProfile(it);
    }

    private static final NotFoundException getById$lambda-4(ProfileId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("User with id " + $id + " does not exist.");
    }

    private static final NotFoundException updateImageUrl$lambda-5(ProfileId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("User with id " + $id + " does not exist.");
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ProfileService $this) {
        return $this.applicationEventPublisher;
    }
}

