/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.model.DbChat;
import de.justsoftware.chat.persistence.model.DbChatParticipant;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.permission.client.kafka.MultiRoleAssignmentProducer;
import de.justsoftware.permission.client.kafka.PermissionItemProducer;
import de.justsoftware.permission.client.kafka.WaitForOffsetException;
import de.justsoftware.permission.client.kafka.WaitForOffsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u0000 *2\u00020\u0001:\u0005)*+,-B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J!\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0012\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aH\u0016J\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0012J\u0018\u0010 \u001a\u0004\u0018\u00010\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001eH\u0012J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0$H\u0016J\f\u0010%\u001a\u00020\u001c*\u00020&H\u0012J\f\u0010%\u001a\u00020\u001c*\u00020'H\u0012J\f\u0010%\u001a\u00020\u001c*\u00020(H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lde/justsoftware/chat/business/PermissionService;", "", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "multiRoleAssignmentProducer", "Lde/justsoftware/permission/client/kafka/MultiRoleAssignmentProducer;", "permissionItemProducer", "Lde/justsoftware/permission/client/kafka/PermissionItemProducer;", "(Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/ChatParticipantRepository;Lde/justsoftware/permission/client/kafka/MultiRoleAssignmentProducer;Lde/justsoftware/permission/client/kafka/PermissionItemProducer;)V", "addPermissionItemForNewChat", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "executeInstructions", "instructions", "", "Lde/justsoftware/chat/business/PermissionService$PermissionInstruction;", "([Lde/justsoftware/chat/business/PermissionService$PermissionInstruction;)V", "removePermissionsForDeletedChat", "replaceRolePermissionsForChat", "replaceRolePermissionsForChats", "chatIds", "", "republishChatItems", "Lde/justsoftware/permission/client/kafka/WaitForOffsets;", "chats", "", "Lde/justsoftware/chat/persistence/model/DbChat;", "republishParticipantRoles", "participants", "Lde/justsoftware/chat/persistence/model/DbChatParticipant;", "republishPermissions", "Lkotlin/Function0;", "execute", "Lde/justsoftware/chat/business/PermissionService$AddChatInstruction;", "Lde/justsoftware/chat/business/PermissionService$DeleteChatInstruction;", "Lde/justsoftware/chat/business/PermissionService$PublishReplacementsInstruction;", "AddChatInstruction", "Companion", "DeleteChatInstruction", "PermissionInstruction", "PublishReplacementsInstruction", "chat-service"})
public class PermissionService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;
    @NotNull
    private final MultiRoleAssignmentProducer multiRoleAssignmentProducer;
    @NotNull
    private final PermissionItemProducer permissionItemProducer;
    @NotNull
    private static final Logger LOG;

    public PermissionService(@NotNull ChatRepository chatRepository, @NotNull ChatParticipantRepository chatParticipantRepository, @NotNull MultiRoleAssignmentProducer multiRoleAssignmentProducer, @NotNull PermissionItemProducer permissionItemProducer) {
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        Intrinsics.checkNotNullParameter((Object)multiRoleAssignmentProducer, (String)"multiRoleAssignmentProducer");
        Intrinsics.checkNotNullParameter((Object)permissionItemProducer, (String)"permissionItemProducer");
        this.chatRepository = chatRepository;
        this.chatParticipantRepository = chatParticipantRepository;
        this.multiRoleAssignmentProducer = multiRoleAssignmentProducer;
        this.permissionItemProducer = permissionItemProducer;
    }

    public void addPermissionItemForNewChat(@NotNull ChatId chatId, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        PermissionInstruction[] permissionInstructionArray = new PermissionInstruction[]{(PermissionInstruction)new AddChatInstruction(chatId, tenantId)};
        this.executeInstructions(permissionInstructionArray);
    }

    public void removePermissionsForDeletedChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        LOG.debug("Removing role replacements and item for deleted chat " + chatId);
        PermissionInstruction[] permissionInstructionArray = new PermissionInstruction[]{(PermissionInstruction)new PublishReplacementsInstruction(Companion.access$emptyRoleReplacementsOf((Companion)Companion, (ChatId)chatId)), (PermissionInstruction)new DeleteChatInstruction(chatId)};
        this.executeInstructions(permissionInstructionArray);
    }

    public void replaceRolePermissionsForChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        LOG.debug("Publishing new role replacements for chat " + chatId);
        this.replaceRolePermissionsForChats(SetsKt.setOf((Object)chatId));
    }

    /*
     * WARNING - void declaration
     */
    public void replaceRolePermissionsForChats(@NotNull Set<ChatId> chatIds) {
        Collection<UUID> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable iterable = chatIds;
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        Companion companion = Companion;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        Map participantReplacements = Companion.access$toRoleReplacements((Companion)companion, (List)CollectionUtilsKt.flattenValues((Map)chatParticipantRepository.findByChatIds((Iterable)collection)));
        Map replacements = MapsKt.plus((Map)Companion.access$toEmptyRoleReplacements((Companion)Companion, chatIds), (Map)participantReplacements);
        PermissionInstruction[] permissionInstructionArray = new PermissionInstruction[]{(PermissionInstruction)new PublishReplacementsInstruction(replacements)};
        this.executeInstructions(permissionInstructionArray);
    }

    @NotNull
    public Function0<Unit> republishPermissions() {
        LOG.debug("Republishing permission items for chats");
        List list = this.chatRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"chatRepository.findAll()");
        WaitForOffsets chatWaitForOffsets = this.republishChatItems(list);
        LOG.debug("Republishing participants role replacements");
        List list2 = this.chatParticipantRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"chatParticipantRepository.findAll()");
        WaitForOffsets participantWaitForOffsets = this.republishParticipantRoles(list2);
        return (Function0)new /* Unavailable Anonymous Inner Class!! */;
    }

    private WaitForOffsets republishChatItems(List<? extends DbChat> chats) {
        Ref.ObjectRef lastWaitForOffsets = new Ref.ObjectRef();
        this.permissionItemProducer.republish("CHAT", () -> PermissionService.republishChatItems$lambda-1(chats, lastWaitForOffsets, this));
        return (WaitForOffsets)lastWaitForOffsets.element;
    }

    private WaitForOffsets republishParticipantRoles(List<? extends DbChatParticipant> participants) {
        Ref.ObjectRef lastWaitForOffsets = new Ref.ObjectRef();
        this.multiRoleAssignmentProducer.republishForItemRoles("CHAT", PermissionType.Companion.getTypes(), () -> PermissionService.republishParticipantRoles$lambda-2(lastWaitForOffsets, this, participants));
        return (WaitForOffsets)lastWaitForOffsets.element;
    }

    /*
     * WARNING - void declaration
     */
    private void executeInstructions(PermissionInstruction ... instructions) {
        if (instructions.length == 0) {
            return;
        }
        try {
            void $this$mapTo$iv$iv;
            PermissionInstruction[] $this$map$iv = instructions;
            boolean $i$f$map = false;
            PermissionInstruction[] permissionInstructionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                WaitForOffsets waitForOffsets;
                void instruction;
                void item$iv$iv;
                void var10_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var12_15 = instruction;
                if (var12_15 instanceof AddChatInstruction) {
                    waitForOffsets = this.execute((AddChatInstruction)instruction);
                } else if (var12_15 instanceof DeleteChatInstruction) {
                    waitForOffsets = this.execute((DeleteChatInstruction)instruction);
                } else if (var12_15 instanceof PublishReplacementsInstruction) {
                    waitForOffsets = this.execute((PublishReplacementsInstruction)instruction);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(waitForOffsets);
            }
            Stream p0 = CollectionUtilsKt.toStream((Iterable)((List)destination$iv$iv));
            boolean bl = false;
            new WaitForOffsets(p0).waitForOffsets();
        }
        catch (WaitForOffsetException ex) {
            LOG.error("error while waiting for response from permission service", (Throwable)ex);
        }
    }

    private WaitForOffsets execute(AddChatInstruction $this$execute) {
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishItem($this$execute.getChatId().toPermissionItemId(), Optional.of($this$execute.getTenantId().toPermissionItemId()), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"permissionItemProducer.p\u2026issionItemId())\n        )");
        return waitForOffsets;
    }

    private WaitForOffsets execute(DeleteChatInstruction $this$execute) {
        WaitForOffsets waitForOffsets = this.permissionItemProducer.publishDeletedItem($this$execute.getChatId().toPermissionItemId());
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"permissionItemProducer.p\u2026tId.toPermissionItemId())");
        return waitForOffsets;
    }

    private WaitForOffsets execute(PublishReplacementsInstruction $this$execute) {
        WaitForOffsets waitForOffsets = this.multiRoleAssignmentProducer.publishRoleReplacements($this$execute.getReplacements());
        Intrinsics.checkNotNullExpressionValue((Object)waitForOffsets, (String)"multiRoleAssignmentProdu\u2026eplacements(replacements)");
        return waitForOffsets;
    }

    private static final void republishChatItems$lambda-1(List $chats, Ref.ObjectRef $lastWaitForOffsets, PermissionService this$0) {
        Intrinsics.checkNotNullParameter((Object)$chats, (String)"$chats");
        Intrinsics.checkNotNullParameter((Object)$lastWaitForOffsets, (String)"$lastWaitForOffsets");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $chats;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbChat chat = (DbChat)element$iv;
            boolean bl = false;
            $lastWaitForOffsets.element = this$0.execute(new AddChatInstruction(new ChatId(chat.getId()), new TenantId(chat.getTenantId())));
        }
    }

    private static final void republishParticipantRoles$lambda-2(Ref.ObjectRef $lastWaitForOffsets, PermissionService this$0, List $participants) {
        Intrinsics.checkNotNullParameter((Object)$lastWaitForOffsets, (String)"$lastWaitForOffsets");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$participants, (String)"$participants");
        $lastWaitForOffsets.element = this$0.execute(new PublishReplacementsInstruction(Companion.access$toRoleReplacements((Companion)Companion, (List)$participants)));
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

