/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.MailService;
import de.justsoftware.chat.business.SettingsService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001*B[\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bH\u0012J\b\u0010\u001f\u001a\u00020 H\u0017J\u0016\u0010!\u001a\u00020 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#H\u0012J0\u0010$\u001a\u0004\u0018\u00010\u0011*\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020'\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u001d0\u001b2\u0006\u0010)\u001a\u00020\u001cH\u0012R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/chat/business/MailService;", "", "restOperations", "Lorg/springframework/web/client/RestOperations;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "settingsService", "Lde/justsoftware/chat/business/SettingsService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "clock", "Ljava/time/Clock;", "toroInternalBaseUrl", "", "chatMailReceiverBatchSize", "", "entityManager", "Ljavax/persistence/EntityManager;", "(Lorg/springframework/web/client/RestOperations;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/business/SettingsService;Lde/justsoftware/chat/business/ChatSettingsService;Ljava/time/Clock;Ljava/lang/String;ILjavax/persistence/EntityManager;)V", "mailUrl", "sendMailData", "", "mailData", "", "Lde/justsoftware/chat/model/ProfileId;", "", "Lde/justsoftware/chat/business/MailService$ChatInfoDto;", "sendUnreadChatMails", "", "sendUnreadChatMailsChunked", "profileIds", "", "getTitleForMail", "Lde/justsoftware/chat/business/model/Chat;", "oneOnOnePartners", "Lde/justsoftware/chat/model/ChatId;", "Lde/justsoftware/chat/business/model/Profile;", "currentProfileId", "ChatInfoDto", "chat-service"})
public class MailService {
    @NotNull
    private final RestOperations restOperations;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final SettingsService settingsService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String toroInternalBaseUrl;
    private final int chatMailReceiverBatchSize;
    @NotNull
    private final EntityManager entityManager;
    @NotNull
    private final String mailUrl;

    public MailService(@Qualifier(value="internalApiRestOperations") @NotNull RestOperations restOperations, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatReadDateService chatReadDateService, @NotNull SettingsService settingsService, @NotNull ChatSettingsService chatSettingsService, @NotNull Clock clock, @Value(value="${just.toro.internal.baseurl}") @NotNull String toroInternalBaseUrl, @Value(value="${service.chat-mail-receiver-batch-size : 100}") int chatMailReceiverBatchSize, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)restOperations, (String)"restOperations");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)toroInternalBaseUrl, (String)"toroInternalBaseUrl");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.restOperations = restOperations;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatReadDateService = chatReadDateService;
        this.settingsService = settingsService;
        this.chatSettingsService = chatSettingsService;
        this.clock = clock;
        this.toroInternalBaseUrl = toroInternalBaseUrl;
        this.chatMailReceiverBatchSize = chatMailReceiverBatchSize;
        this.entityManager = entityManager;
        this.mailUrl = this.toroInternalBaseUrl + "/rest/internal/chat/mail";
    }

    @Transactional
    public long sendUnreadChatMails() {
        return CollectionUtilsKt.chunked((Stream)this.chatReadDateService.getUsersEligibleForUnreadMail(), (int)this.chatMailReceiverBatchSize).mapToLong(arg_0 -> MailService.sendUnreadChatMails$lambda-1(this, arg_0)).sum();
    }

    /*
     * WARNING - void declaration
     */
    private long sendUnreadChatMailsChunked(Set<ProfileId> profileIds) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Collection<Object> collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        void $this$flatMapTo$iv$iv;
        Map chatUnreadMessageCounts = this.chatReadDateService.getChatUnreadMessageCounts(profileIds);
        Iterable $this$flatMapToSet$iv = chatUnreadMessageCounts.values();
        boolean $i$f$flatMapToSet = false;
        Iterable iterable = $this$flatMapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map p0 = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set affectedChatIds = (Set)destination$iv$iv;
        Set profilesWithNonMutedChats = this.chatSettingsService.findProfilesWithNonMutedChats((Iterable)profileIds, (Iterable)affectedChatIds);
        Map affectedChats = this.chatService.findByIds(affectedChatIds);
        destination$iv$iv = affectedChats.values();
        Object object = this.chatParticipantService;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof OneOnOneChat)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$mapToSet22 = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
            void p0;
            OneOnOneChat oneOnOneChat = (OneOnOneChat)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Map affectedOneOnOneProfiles = object.getDirectChatPartners((Set)destination$iv$iv2);
        Map $i$f$mapToSet22 = chatUnreadMessageCounts;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = (Map.Entry)item$iv$iv2.next();
            boolean bl = false;
            if (!profilesWithNonMutedChats.contains(it.getKey())) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv3;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            Map unreadChatCounts;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv3;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = map;
            boolean bl2 = false;
            ProfileId profileId = (ProfileId)entry2.getKey();
            Map $this$mapNotNull$iv = unreadChatCounts = (Map)entry2.getValue();
            boolean $i$f$mapNotNull = false;
            Map map2 = $this$mapNotNull$iv;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                ChatInfoDto it$iv$iv2;
                Chat chat;
                Map.Entry element$iv$iv$iv2;
                Map.Entry element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                boolean bl3 = false;
                Map.Entry entry3 = element$iv$iv;
                boolean bl4 = false;
                ChatId chatId = (ChatId)entry3.getKey();
                long unreadCount = ((Number)entry3.getValue()).longValue();
                if (((Chat)affectedChats.get(chatId) == null ? null : new ChatInfoDto(chat.getId().toCanonicalId(), this.getTitleForMail(chat, affectedOneOnOneProfiles, profileId), unreadCount)) == null) continue;
                it$iv$iv2 = it$iv$iv2;
                boolean bl5 = false;
                destination$iv$iv4.add(it$iv$iv2);
            }
            List list = (List)destination$iv$iv4;
            object.put(collection, list);
        }
        Map mailData = destination$iv$iv3;
        this.sendMailData(mailData);
        Set set = mailData.keySet();
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        this.settingsService.saveMailDeliveryDates(set, instant);
        return mailData.size();
    }

    private void sendMailData(Map<ProfileId, ? extends List<ChatInfoDto>> mailData) {
        if (mailData.isEmpty()) {
            return;
        }
        ResponseEntity responseEntity = this.restOperations.postForEntity(this.mailUrl, mailData, Void.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"restOperations.postForEn\u2026oid::class.java\n        )");
        ResponseEntity response = responseEntity;
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException("Failed to send notification mails. Juco Internal REST API returned StatusCode: " + response.getStatusCode().value());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTitleForMail(Chat $this$getTitleForMail, Map<ChatId, ? extends List<Profile>> oneOnOnePartners, ProfileId currentProfileId) {
        Object v1;
        String string2;
        block2: {
            void $this$firstOrNull$iv;
            Chat chat = $this$getTitleForMail;
            if (chat instanceof MultiUserChat) {
                string2 = ((MultiUserChat)$this$getTitleForMail).getTitle();
                return string2;
            }
            if (!(chat instanceof OneOnOneChat)) throw new NoWhenBranchMatchedException();
            List<Profile> list = oneOnOnePartners.get($this$getTitleForMail.getId());
            if (list == null) return null;
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Profile profile = (Profile)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)profile.getId(), (Object)currentProfileId))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Profile profile = v1;
        if (profile == null) return null;
        string2 = profile.getFullName();
        return string2;
    }

    private static final long sendUnreadChatMails$lambda-1(MailService this$0, List profileIds) {
        long l;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)profileIds, (String)"profileIds");
        long it = l = this$0.sendUnreadChatMailsChunked(CollectionsKt.toSet((Iterable)profileIds));
        boolean bl = false;
        this$0.entityManager.flush();
        this$0.entityManager.clear();
        return l;
    }
}

