/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import com.google.common.base.Charsets;
import de.justsoftware.chat.business.ConfigService;
import de.justsoftware.chat.business.model.event.JustLicenseChangedEvent;
import java.nio.charset.Charset;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.unit.DataSize;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0012J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/chat/business/ConfigService;", "", "zookeeperClient", "Lorg/apache/curator/framework/CuratorFramework;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lorg/apache/curator/framework/CuratorFramework;Lorg/springframework/context/ApplicationEventPublisher;)V", "chatCleanupAfterExpressionCache", "Lorg/apache/curator/framework/recipes/cache/NodeCache;", "justLicenseCache", "mailCronExpressionCache", "maxDriveFileSizeCache", "addChatCleanupAfterExpressionListener", "", "listener", "Lorg/apache/curator/framework/recipes/cache/NodeCacheListener;", "addMailCronExpressionListener", "addMaxDriveFileSizeListener", "chatCleanupAfterExpression", "Ljava/time/Duration;", "getString", "", "cache", "justLicense", "mailCronExpression", "maxDriveFileSize", "Lorg/springframework/util/unit/DataSize;", "Companion", "chat-service"})
public class ConfigService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final NodeCache chatCleanupAfterExpressionCache;
    @NotNull
    private final NodeCache mailCronExpressionCache;
    @NotNull
    private final NodeCache maxDriveFileSizeCache;
    @NotNull
    private final NodeCache justLicenseCache;
    @NotNull
    private static final String MAIL_CRON_EXPRESSION_PATH = "/just/chat/mailCron";
    @NotNull
    private static final String CHAT_CLEANUP_AFTER_EXPRESSION_PATH = "/just/chat/cleanupAfter";
    @NotNull
    private static final String MAX_DRIVE_FILE_SIZE_PATH = "/just/drive/uploadMaxFileSize";
    @NotNull
    private static final String JUST_LICENSE_PATH = "/just/license";
    private static final DataSize DEFAULT_MAX_DRIVE_FILE_SIZE = DataSize.ofMegabytes((long)250L);
    @NotNull
    private static final Duration DEFAULT_CLEANUP_AFTER;

    /*
     * WARNING - void declaration
     */
    public ConfigService(@NotNull CuratorFramework zookeeperClient, @NotNull ApplicationEventPublisher applicationEventPublisher) {
        void $this$justLicenseCache_u24lambda_u2d4;
        NodeCache $this$maxDriveFileSizeCache_u24lambda_u2d2;
        NodeCache $this$mailCronExpressionCache_u24lambda_u2d1;
        NodeCache $this$chatCleanupAfterExpressionCache_u24lambda_u2d0;
        NodeCache nodeCache;
        Intrinsics.checkNotNullParameter((Object)zookeeperClient, (String)"zookeeperClient");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        this.applicationEventPublisher = applicationEventPublisher;
        NodeCache nodeCache2 = nodeCache = new NodeCache(zookeeperClient, CHAT_CLEANUP_AFTER_EXPRESSION_PATH);
        ConfigService configService = this;
        boolean bl = false;
        $this$chatCleanupAfterExpressionCache_u24lambda_u2d0.start();
        configService.chatCleanupAfterExpressionCache = nodeCache;
        $this$chatCleanupAfterExpressionCache_u24lambda_u2d0 = nodeCache = new NodeCache(zookeeperClient, MAIL_CRON_EXPRESSION_PATH);
        configService = this;
        boolean bl2 = false;
        $this$mailCronExpressionCache_u24lambda_u2d1.start();
        configService.mailCronExpressionCache = nodeCache;
        $this$mailCronExpressionCache_u24lambda_u2d1 = nodeCache = new NodeCache(zookeeperClient, MAX_DRIVE_FILE_SIZE_PATH);
        configService = this;
        boolean bl3 = false;
        $this$maxDriveFileSizeCache_u24lambda_u2d2.start();
        configService.maxDriveFileSizeCache = nodeCache;
        $this$maxDriveFileSizeCache_u24lambda_u2d2 = nodeCache = new NodeCache(zookeeperClient, JUST_LICENSE_PATH);
        configService = this;
        boolean bl4 = false;
        $this$justLicenseCache_u24lambda_u2d4.start();
        $this$justLicenseCache_u24lambda_u2d4.getListenable().addListener(() -> ConfigService.justLicenseCache$lambda-4$lambda-3(this));
        configService.justLicenseCache = nodeCache;
    }

    @NotNull
    public Duration chatCleanupAfterExpression() {
        Duration cleanupAfterDays;
        Duration duration;
        Duration duration2;
        String string2 = this.getString(this.chatCleanupAfterExpressionCache);
        if (string2 != null) {
            long $this$days$iv = Long.parseLong(string2, CharsKt.checkRadix((int)10));
            boolean $i$f$getDays = false;
            Duration duration3 = Duration.ofDays($this$days$iv);
            duration2 = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofDays(this)");
        } else {
            duration2 = null;
        }
        if ((duration = (cleanupAfterDays = duration2)) == null) {
            duration = DEFAULT_CLEANUP_AFTER;
        }
        return duration;
    }

    public void addChatCleanupAfterExpressionListener(@NotNull NodeCacheListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.chatCleanupAfterExpressionCache.getListenable().addListener((Object)listener);
    }

    @Nullable
    public String mailCronExpression() {
        return this.getString(this.mailCronExpressionCache);
    }

    public void addMailCronExpressionListener(@NotNull NodeCacheListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.mailCronExpressionCache.getListenable().addListener((Object)listener);
    }

    @NotNull
    public DataSize maxDriveFileSize() {
        DataSize dataSize;
        DataSize dataSize2;
        String string2 = this.getString(this.maxDriveFileSizeCache);
        if (string2 != null) {
            CharSequence p0 = string2;
            boolean bl = false;
            dataSize2 = DataSize.parse((CharSequence)p0);
        } else {
            dataSize2 = dataSize = null;
        }
        if (dataSize2 == null) {
            DataSize dataSize3 = DEFAULT_MAX_DRIVE_FILE_SIZE;
            dataSize = dataSize3;
            Intrinsics.checkNotNullExpressionValue((Object)dataSize3, (String)"DEFAULT_MAX_DRIVE_FILE_SIZE");
        }
        return dataSize;
    }

    public void addMaxDriveFileSizeListener(@NotNull NodeCacheListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.maxDriveFileSizeCache.getListenable().addListener((Object)listener);
    }

    @Nullable
    public String justLicense() {
        return this.getString(this.justLicenseCache);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getString(NodeCache cache) {
        ChildData childData = cache.getCurrentData();
        Object object = childData;
        if (childData == null) return null;
        byte[] byArray = object.getData();
        object = byArray;
        if (byArray == null) return null;
        Object object2 = object;
        boolean bl = false;
        Charset charset = Charsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        String string2 = new String((byte[])object2, charset2);
        return string2;
    }

    private static final void justLicenseCache$lambda-4$lambda-3(ConfigService this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.applicationEventPublisher.publishEvent((ApplicationEvent)new JustLicenseChangedEvent((Object)this$0));
    }

    static {
        int $this$days$iv = 90;
        boolean $i$f$getDays = false;
        long $this$days$iv$iv = $this$days$iv;
        boolean $i$f$getDays2 = false;
        Duration duration = Duration.ofDays($this$days$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(this)");
        DEFAULT_CLEANUP_AFTER = duration;
    }
}

