/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.persistence.ChatSettingsRepository;
import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatSettings;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0013H\u0016J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J*\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J*\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u001a2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/chat/business/ChatSettingsService;", "", "chatSettingsRepository", "Lde/justsoftware/chat/persistence/ChatSettingsRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "(Lde/justsoftware/chat/persistence/ChatSettingsRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;)V", "findByChatIdAndProfileId", "Ljava/util/Optional;", "Lde/justsoftware/chat/business/model/ChatSettings;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "findProfilesWithNonMutedChats", "", "profileIds", "", "chatIds", "findUpdatedAndSpecificSettings", "", "updatedSince", "Ljava/time/Instant;", "getSettings", "", "getSettingsForChat", "muteChat", "isMuted", "", "save", "chatSettings", "chat-service"})
public class ChatSettingsService {
    @NotNull
    private final ChatSettingsRepository chatSettingsRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;

    public ChatSettingsService(@NotNull ChatSettingsRepository chatSettingsRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils) {
        Intrinsics.checkNotNullParameter((Object)chatSettingsRepository, (String)"chatSettingsRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        this.chatSettingsRepository = chatSettingsRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, ChatSettings> getSettings(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds) {
        void $this$associateTo$iv$iv;
        Collection<UUID> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable iterable = chatIds;
        String string2 = profileId.toCanonicalId();
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$associate$iv = chatSettingsRepository.findByProfileIdAndChatIds(string2, (Iterable)collection).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            DbChatSettings dbChatSettings = (DbChatSettings)entry.getValue();
            entry = TuplesKt.to((Object)new ChatId(chatId), (Object)DbChatSettings.Companion.toChatSettings(dbChatSettings));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ChatSettings> getSettingsForChat(@NotNull ChatId chatId, @NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        UUID uUID = chatId.getValue();
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$associate$iv = chatSettingsRepository.findByChatIdAndProfileIds(uUID, (Iterable)collection).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String profileId = (String)entry.getKey();
            DbChatSettings dbChatSettings = (DbChatSettings)entry.getValue();
            entry = TuplesKt.to((Object)ProfileId.Companion.fromCanonicalId(profileId), (Object)DbChatSettings.Companion.toChatSettings(dbChatSettings));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Transactional
    @NotNull
    public ChatSettings muteChat(@NotNull ChatId chatId, @NotNull ProfileId profileId, boolean isMuted) {
        ChatSettings chatSettings;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ChatSettings currentSettings = this.findByChatIdAndProfileId(chatId, profileId).orElseGet(() -> ChatSettingsService.muteChat$lambda-3(chatId, profileId));
        if (currentSettings.getMuted() == isMuted) {
            Intrinsics.checkNotNullExpressionValue((Object)currentSettings, (String)"currentSettings");
            chatSettings = currentSettings;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)currentSettings, (String)"currentSettings");
            chatSettings = this.save(ChatSettings.copy$default((ChatSettings)currentSettings, null, null, (boolean)isMuted, null, (int)11, null));
        }
        return chatSettings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> findProfilesWithNonMutedChats(@NotNull Iterable<ProfileId> profileIds, @NotNull Iterable<ChatId> chatIds) {
        void $this$filterTo$iv$iv;
        DbChatSettings it;
        Iterable<ProfileId> $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        Collection<UUID> collection;
        ChatId p0;
        boolean bl;
        Iterable<String> iterable;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Intrinsics.checkNotNullParameter((Object)chatIds, (String)"chatIds");
        Iterable<ProfileId> iterable2 = profileIds;
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            ProfileId profileId = (ProfileId)t;
            iterable = destination$iv$iv;
            bl = false;
            iterable.add(p0.toCanonicalId());
        }
        $this$map$iv = chatIds;
        iterable = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            p0 = (ChatId)t;
            collection = destination$iv$iv;
            bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = chatSettingsRepository.findByProfileIdsAndChatIds(iterable, (Iterable)collection);
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            it = (DbChatSettings)t;
            bl = false;
            String key$iv$iv = it.getProfileId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Object savedSettings = destination$iv$iv;
        Iterable<ProfileId> $this$filterToSet$iv = profileIds;
        boolean $i$f$filterToSet = false;
        $this$groupByTo$iv$iv = $this$filterToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$filterToSet$iv));
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            boolean bl2;
            block11: {
                it = (ProfileId)t;
                boolean bl3 = false;
                List list = (List)savedSettings.get(it.toCanonicalId());
                if (list != null) {
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            DbChatSettings settings = (DbChatSettings)element$iv;
                            boolean bl4 = false;
                            if (!(!settings.getMuted())) continue;
                            bl2 = true;
                            break block11;
                        }
                        bl2 = false;
                    }
                } else {
                    bl2 = true;
                }
            }
            if (!bl2) continue;
            destination$iv$iv.add(t);
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChatSettings> findUpdatedAndSpecificSettings(@NotNull ProfileId profileId, @NotNull Iterable<ChatId> chatIds, @NotNull Instant updatedSince) {
        DbChatSettings p0;
        Collection<UUID> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        Iterable<ChatId> iterable = chatIds;
        Instant instant = updatedSince;
        String string2 = profileId.toCanonicalId();
        Object object = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = object.findByProfileIdAndUpdatedAtGreaterThanOrChatIds(string2, instant, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatSettings)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChatSettings.Companion.toChatSettings((DbChatSettings)it));
        }
        return (List)destination$iv$iv;
    }

    private ChatSettings save(ChatSettings chatSettings) {
        ChatSettings chatSettings2;
        Object object = this.chatSettingsRepository.save((Object)DbChatSettings.Companion.toDbChatSettings(chatSettings));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatSettingsRepository\n \u2026tings.toDbChatSettings())");
        ChatSettings savedChatSettings = chatSettings2 = DbChatSettings.Companion.toChatSettings((DbChatSettings)object);
        boolean bl = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return chatSettings2;
    }

    private Optional<ChatSettings> findByChatIdAndProfileId(ChatId chatId, ProfileId profileId) {
        Optional<ChatSettings> optional = this.chatSettingsRepository.findById((Object)new DbChatProfileId(chatId, profileId)).map(ChatSettingsService::findByChatIdAndProfileId$lambda-12);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"chatSettingsRepository\n \u2026p { it.toChatSettings() }");
        return optional;
    }

    private static final ChatSettings muteChat$lambda-3(ChatId $chatId, ProfileId $profileId) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        return new ChatSettings($chatId, $profileId, false, null, 12, null);
    }

    private static final ChatSettings findByChatIdAndProfileId$lambda-12(DbChatSettings it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbChatSettings.Companion.toChatSettings(it);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatSettingsService $this) {
        return $this.applicationEventPublisher;
    }
}

