/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChatReadDate;
import de.justsoftware.chat.business.model.ChatReadDateAndCount;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatProfileId;
import de.justsoftware.chat.model.Id;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.persistence.ChatReadDateRepository;
import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatReadDate;
import de.justsoftware.chat.persistence.model.DbChatReadDateAndCount;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00190\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0015H\u0016J.\u0010\u001e\u001a\u001a\u0012\u0004\u0012\u00020\u0013\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001f0\u001b0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016J*\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\"0\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130*H\u0016J$\u0010+\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020\u000fH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lde/justsoftware/chat/business/ChatReadDateService;", "", "chatReadDateRepository", "Lde/justsoftware/chat/persistence/ChatReadDateRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/persistence/ChatReadDateRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "findByChatIdAndProfileId", "Ljava/util/Optional;", "Lde/justsoftware/chat/business/model/ChatReadDate;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "findChatIdsReadSince", "", "participantIds", "Lde/justsoftware/chat/model/ParticipantId;", "readSince", "Ljava/time/Instant;", "getChatReadDates", "", "Lde/justsoftware/chat/model/ChatProfileId;", "ids", "getChatUnreadMessageCounts", "", "profileIds", "getReadData", "Lde/justsoftware/chat/business/model/ChatReadDateAndCount;", "chatIds", "getUnreadChatCount", "", "currentProfileId", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "getUsersEligibleForUnreadMail", "Ljava/util/stream/Stream;", "markAsRead", "readDate", "save", "chatReadDate", "chat-service"})
public class ChatReadDateService {
    @NotNull
    private final ChatReadDateRepository chatReadDateRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;

    public ChatReadDateService(@NotNull ChatReadDateRepository chatReadDateRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull UserGroupService userGroupService, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatReadDateRepository, (String)"chatReadDateRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatReadDateRepository = chatReadDateRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.userGroupService = userGroupService;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @NotNull
    public ChatReadDate markAsRead(@NotNull ChatId chatId, @NotNull ProfileId profileId, @Nullable Instant readDate) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Instant instant = readDate;
        if (instant == null) {
            instant = this.clock.instant();
        }
        Instant actualReadDate = instant;
        ChatReadDate chatReadDate = this.findByChatIdAndProfileId(chatId, profileId).filter(arg_0 -> ChatReadDateService.markAsRead$lambda-0(actualReadDate, arg_0)).orElseGet(() -> ChatReadDateService.markAsRead$lambda-1(this, chatId, profileId, actualReadDate));
        Intrinsics.checkNotNullExpressionValue((Object)chatReadDate, (String)"findByChatIdAndProfileId\u2026ileId, actualReadDate)) }");
        return chatReadDate;
    }

    public static /* synthetic */ ChatReadDate markAsRead$default(ChatReadDateService chatReadDateService, ChatId chatId, ProfileId profileId, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: markAsRead");
        }
        if ((n & 4) != 0) {
            instant = null;
        }
        return chatReadDateService.markAsRead(chatId, profileId, instant);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, ChatReadDateAndCount> getReadData(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable iterable = chatIds;
        ChatReadDateRepository chatReadDateRepository = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Iterable $this$associate$iv = chatReadDateRepository.readDateAndCountForUserInChats((Iterable)((List)destination$iv$iv), profileId.toCanonicalId()).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            DbChatReadDateAndCount dbChatReadDataResult = (DbChatReadDateAndCount)entry.getValue();
            entry = TuplesKt.to((Object)new ChatId(chatId), (Object)DbChatReadDateAndCount.Companion.toChatReadDateAndCount(dbChatReadDataResult));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Map<ChatId, Long>> getChatUnreadMessageCounts(@NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        ChatReadDateRepository chatReadDateRepository = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = chatReadDateRepository.unreadCountsForUsers((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Map value;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            Map map2 = value = (Map)entry.getValue();
            ProfileId profileId = ProfileId.Companion.fromCanonicalId(key);
            boolean $i$f$mapKeys = false;
            void var18_24 = $this$mapKeys$iv;
            Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv3;
                boolean bl2 = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                ChatId chatId = new ChatId((UUID)it.getKey());
                Map map4 = map3;
                boolean bl3 = false;
                entry2 = it$iv$iv.getValue();
                map4.put(chatId, entry2);
            }
            entry = TuplesKt.to((Object)profileId, (Object)destination$iv$iv3);
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    public int getUnreadChatCount(@NotNull ProfileId currentProfileId, @NotNull TenantId tenantId) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)currentProfileId, (String)"currentProfileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set userGroupIds = this.userGroupService.getUserGroupIdsByProfileId(currentProfileId);
        Set participantIds = SetsKt.plus((Set)userGroupIds, (Iterable)SetsKt.setOf((Object)currentProfileId));
        Iterable iterable = participantIds;
        UUID uUID = tenantId.getValue();
        ChatReadDateRepository chatReadDateRepository = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Id id = (Id)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((ParticipantId)it).toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        return chatReadDateRepository.getUnreadChatCountByTenantIdAndParticipantIdIn(uUID, (Iterable)collection, currentProfileId.toCanonicalId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findChatIdsReadSince(@NotNull Set<? extends ParticipantId> participantIds, @NotNull Instant readSince) {
        UUID p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)readSince, (String)"readSince");
        Iterable iterable = participantIds;
        Object object = this.chatReadDateRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findChatsByReadDateGreaterThanAndParticipantIds((Iterable)((List)destination$iv$iv), readSince);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (UUID)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new ChatId(p0));
        }
        return (Set)destination$iv$iv;
    }

    @NotNull
    public Stream<ProfileId> getUsersEligibleForUnreadMail() {
        Stream<ProfileId> stream = this.chatReadDateRepository.usersEligibleForUnreadMail().map(arg_0 -> ((ProfileId.Companion)ProfileId.Companion).fromCanonicalId(arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"chatReadDateRepository\n \u2026mpanion::fromCanonicalId)");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatProfileId, Instant> getChatReadDates(@NotNull Set<ChatProfileId> ids) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable iterable = ids;
        Object object = this.chatReadDateRepository;
        boolean $i$f$map22 = false;
        void var5_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            ChatProfileId chatProfileId = (ChatProfileId)item$iv$iv2;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DbChatProfileId(it.getChatId(), it.getProfileId()));
        }
        List list = object.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"chatReadDateRepository\n \u2026.chatId, it.profileId) })");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map = false;
        Iterable $i$f$map22 = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object item$iv$iv2;
            item$iv$iv2 = (DbChatReadDate)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            object.add(DbChatReadDate.Companion.toChatReadDate((DbChatReadDate)it));
        }
        Iterable $this$associate$iv = (List)destination$iv$iv2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associate$iv;
        Map destination$iv$iv22 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv22;
            ChatReadDate it = (ChatReadDate)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)new ChatProfileId(it.getChatId(), it.getProfileId()), (Object)it.getReadDate());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv22;
    }

    private ChatReadDate save(ChatReadDate chatReadDate) {
        ChatReadDate chatReadDate2;
        Object object = this.chatReadDateRepository.save((Object)DbChatReadDate.Companion.toDbChatReadDate(chatReadDate));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatReadDateRepository\n \u2026dDate.toDbChatReadDate())");
        ChatReadDate savedChatReadDate = chatReadDate2 = DbChatReadDate.Companion.toChatReadDate((DbChatReadDate)object);
        boolean bl = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return chatReadDate2;
    }

    private Optional<ChatReadDate> findByChatIdAndProfileId(ChatId chatId, ProfileId profileId) {
        Optional<ChatReadDate> optional = this.chatReadDateRepository.findById((Object)new DbChatProfileId(chatId, profileId)).map(ChatReadDateService::findByChatIdAndProfileId$lambda-13);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"chatReadDateRepository\n \u2026p { it.toChatReadDate() }");
        return optional;
    }

    private static final boolean markAsRead$lambda-0(Instant $actualReadDate, ChatReadDate it) {
        return it.getReadDate().compareTo($actualReadDate) >= 0;
    }

    private static final ChatReadDate markAsRead$lambda-1(ChatReadDateService this$0, ChatId $chatId, ProfileId $profileId, Instant $actualReadDate) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        Intrinsics.checkNotNullExpressionValue((Object)$actualReadDate, (String)"actualReadDate");
        return this$0.save(new ChatReadDate($chatId, $profileId, $actualReadDate));
    }

    private static final ChatReadDate findByChatIdAndProfileId$lambda-13(DbChatReadDate it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbChatReadDate.Companion.toChatReadDate(it);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatReadDateService $this) {
        return $this.applicationEventPublisher;
    }
}

