/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.business.model.UserGroupMember;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ProfileDeletedEvent;
import de.justsoftware.chat.business.model.event.UserGroupDeletedEvent;
import de.justsoftware.chat.business.model.event.UserGroupMembersAddedEvent;
import de.justsoftware.chat.business.model.event.UserGroupMembersRemovedEvent;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.Diff;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.RemovedParticipantProfileForSyncRepository;
import de.justsoftware.chat.persistence.model.DbChat;
import de.justsoftware.chat.persistence.model.DbChatParticipant;
import de.justsoftware.chat.persistence.model.DbRemovedParticipantProfileForSync;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0012J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020(0 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0 0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0,H\u0016J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0%H\u0012J$\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0,2\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u001a0%2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\u0006\u00104\u001a\u00020\u001aH\u0016J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00106\u001a\u00020\u001eH\u0016J$\u00107\u001a\b\u0012\u0004\u0012\u00020\u001a0%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0,2\u0006\u00106\u001a\u00020\u001eH\u0016J$\u00108\u001a\b\u0012\u0004\u0012\u0002090%2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#0,2\u0006\u00106\u001a\u00020\u001eH\u0016J(\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020;0 0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0%H\u0016J*\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020;0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\u0006\u0010=\u001a\u00020\u001aH\u0016J\u001a\u0010>\u001a\u0004\u0018\u00010\u001c2\u0006\u0010?\u001a\u00020\u001a2\u0006\u0010@\u001a\u00020\u001aH\u0016J*\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001c0*2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001a0%2\u0006\u0010@\u001a\u00020\u001aH\u0016J*\u0010C\u001a\b\u0012\u0004\u0012\u00020(0D2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002010*H\u0017J.\u0010F\u001a\u001a\u0012\u0004\u0012\u00020\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002010*0*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0,H\u0016J\u001c\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001a0%2\f\u0010H\u001a\b\u0012\u0004\u0012\u0002090%H\u0012J\u0018\u0010I\u001a\u00020J2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020\u001aH\u0017J\u0018\u0010L\u001a\u00020J2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020\u001aH\u0017J\u001e\u0010N\u001a\b\u0012\u0004\u0012\u00020(0 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010O\u001a\u00020\u001aH\u0017J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010Q\u001a\u00020RH\u0017J\u0016\u0010S\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010T\u001a\u00020UH\u0017J\u0016\u0010V\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010W\u001a\u00020XH\u0017J\u0016\u0010Y\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010W\u001a\u00020ZH\u0017J8\u0010[\u001a\u00020J2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020(0D2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010]\u001a\u00020\u001a2\u0006\u0010^\u001a\u00020_2\b\b\u0002\u0010`\u001a\u00020_H\u0012J,\u0010a\u001a\u00020J2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0%2\f\u0010b\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J(\u0010c\u001a\u00020J2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020(0e2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0012J6\u0010f\u001a\u00020J2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u0002010*2\u0006\u0010K\u001a\u00020\u001a2\b\b\u0002\u0010`\u001a\u00020_H\u0017J&\u0010g\u001a\u00020J2\u0006\u0010h\u001a\u00020i2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020(0D2\u0006\u0010K\u001a\u00020\u001aH\u0012J.\u0010j\u001a\u00020J2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020(0D2\u0006\u0010K\u001a\u00020\u001a2\u0006\u0010`\u001a\u00020_H\u0012J&\u0010k\u001a\u00020J2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020(0 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010K\u001a\u00020\u001aH\u0012J\u001e\u0010l\u001a\u00020J2\u0006\u0010m\u001a\u00020n2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020(0DH\u0012J\u0018\u0010o\u001a\u00020p2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010`\u001a\u00020_H\u0012J\u0018\u0010q\u001a\b\u0012\u0004\u0012\u00020\u001a0%*\b\u0012\u0004\u0012\u00020(0eH\u0012J\u0018\u0010q\u001a\b\u0012\u0004\u0012\u00020\u001a0%*\b\u0012\u0004\u0012\u00020#0%H\u0012R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lde/justsoftware/chat/business/ChatParticipantService;", "", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "permissionService", "Lde/justsoftware/chat/business/PermissionService;", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "removedParticipantProfileRepository", "Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/authorization/AuthorizationService;Lde/justsoftware/chat/business/PermissionService;Lde/justsoftware/chat/persistence/ChatParticipantRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "createDbRemovedParticipantProfile", "Lde/justsoftware/chat/persistence/model/DbRemovedParticipantProfileForSync;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "removedAt", "Ljava/time/Instant;", "deleteParticipant", "", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "participantId", "Lde/justsoftware/chat/model/ParticipantId;", "deletedUserGroupMembers", "", "Lde/justsoftware/chat/business/model/UserGroupMember;", "findByChatId", "Lde/justsoftware/chat/business/model/ChatParticipant;", "findByChatIds", "", "chatIds", "", "findChatsWithParticipants", "participantIds", "findChatsWithoutPermission", "permissionType", "Lde/justsoftware/chat/model/PermissionType;", "findEffectiveProfileIdsByChatId", "findOneOnOneChatIdsByProfileId", "id", "findRecentlyJoinedChatIds", "since", "findUpdatedDirectParticipants", "findUpdatedGroupParticipants", "Lde/justsoftware/chat/model/UserGroupId;", "getDirectChatPartners", "Lde/justsoftware/chat/business/model/Profile;", "getDirectChatPartnersForProfile", "currentProfileId", "getOneOnOneChatIdByChatPartnerId", "chatPartnerId", "userId", "getOneOnOneChatIdByChatPartnerIds", "chatPartnerIds", "getParticipantChanges", "Lde/justsoftware/chat/model/Diff;", "participants", "getParticipantPermissionsByChatIds", "getProfileIdsOfMembers", "userGroupIds", "leaveChat", "", "currentUserId", "moveParticipantsFromDeleted", "restoredBy", "moveParticipantsToDeleted", "deletedBy", "onProfileDeleted", "profileDeletedEvent", "Lde/justsoftware/chat/business/model/event/ProfileDeletedEvent;", "onUserGroupDeleted", "userGroupDeletedEvent", "Lde/justsoftware/chat/business/model/event/UserGroupDeletedEvent;", "onUserGroupMembersAdded", "event", "Lde/justsoftware/chat/business/model/event/UserGroupMembersAddedEvent;", "onUserGroupMembersRemoved", "Lde/justsoftware/chat/business/model/event/UserGroupMembersRemovedEvent;", "participantsChanged", "diff", "updater", "withSystemMessage", "", "isNewChat", "saveRemovedGroupMembersForSync", "removedGroupMembers", "saveRemovedParticipantsForSync", "removedParticipants", "", "setParticipants", "validateAddedParticipants", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "validateParticipantChanges", "validateParticipantsForLeaveChat", "validateResultingParticipants", "chatType", "Lde/justsoftware/chat/model/ChatType;", "validatedChatForParticipantChange", "Lde/justsoftware/chat/persistence/model/DbChat;", "toResolvedProfileIds", "chat-service"})
public class ChatParticipantService {
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;

    public ChatParticipantService(@NotNull UserGroupService userGroupService, @NotNull ProfileService profileService, @NotNull AuthorizationService authorizationService, @NotNull PermissionService permissionService, @NotNull ChatParticipantRepository chatParticipantRepository, @NotNull ChatRepository chatRepository, @NotNull RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)removedParticipantProfileRepository, (String)"removedParticipantProfileRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.userGroupService = userGroupService;
        this.profileService = profileService;
        this.authorizationService = authorizationService;
        this.permissionService = permissionService;
        this.chatParticipantRepository = chatParticipantRepository;
        this.chatRepository = chatRepository;
        this.removedParticipantProfileRepository = removedParticipantProfileRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @Transactional
    public void setParticipants(@NotNull ChatId chatId, @NotNull Map<ParticipantId, ? extends PermissionType> participants, @NotNull ProfileId currentUserId, boolean isNewChat) throws ValidationException {
        ChatParticipant it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        Diff diff2 = this.getParticipantChanges(chatId, participants);
        if (!diff2.getHasChanges()) {
            return;
        }
        this.validateParticipantChanges(chatId, diff2, currentUserId, isNewChat);
        Iterable iterable = CollectionsKt.plus((Collection)diff2.getModified(), (Iterable)diff2.getAdded());
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbChatParticipant.Companion.toDbChatParticipant(it));
        }
        chatParticipantRepository.saveAll((Iterable)((List)destination$iv$iv));
        $this$map$iv = diff2.getRemoved();
        chatParticipantRepository = this.chatParticipantRepository;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbChatParticipant.Companion.toDbChatParticipant(it));
        }
        chatParticipantRepository.deleteAll((Iterable)((List)destination$iv$iv));
        Instant participantsSetAt = this.clock.instant();
        Collection collection2 = diff2.getRemoved();
        Intrinsics.checkNotNullExpressionValue((Object)participantsSetAt, (String)"participantsSetAt");
        this.saveRemovedParticipantsForSync(chatId, collection2, participantsSetAt);
        if (!isNewChat) {
            this.chatRepository.updateSyncDateByChatIds(SetsKt.setOf((Object)chatId.getValue()), participantsSetAt);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static /* synthetic */ void setParticipants$default(ChatParticipantService chatParticipantService, ChatId chatId, Map map, ProfileId profileId, boolean bl, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setParticipants");
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        chatParticipantService.setParticipants(chatId, map, profileId, bl);
    }

    @Transactional
    @NotNull
    public Diff<ChatParticipant> getParticipantChanges(@NotNull ChatId chatId, @NotNull Map<ParticipantId, ? extends PermissionType> participants) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(participants, (String)"participants");
        return new Diff((Collection)this.findByChatId(chatId), (Collection)ChatParticipant.Companion.toChatParticipants(participants, chatId, this.clock), (Function1)getParticipantChanges.1.INSTANCE, (Function1)getParticipantChanges.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private void saveRemovedParticipantsForSync(ChatId chatId, Collection<ChatParticipant> removedParticipants, Instant removedAt) {
        void $this$forEach$iv;
        Iterable iterable = this.toResolvedProfileIds(removedParticipants);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProfileId profileId = (ProfileId)element$iv;
            boolean bl = false;
            this.removedParticipantProfileRepository.save((Object)this.createDbRemovedParticipantProfile(profileId, chatId, removedAt));
        }
    }

    static /* synthetic */ void saveRemovedParticipantsForSync$default(ChatParticipantService chatParticipantService, ChatId chatId, Collection collection, Instant instant, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveRemovedParticipantsForSync");
        }
        if ((n & 4) != 0) {
            Instant instant2 = chatParticipantService.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"clock.instant()");
            instant = instant2;
        }
        chatParticipantService.saveRemovedParticipantsForSync(chatId, collection, instant);
    }

    /*
     * WARNING - void declaration
     */
    private void participantsChanged(Diff<ChatParticipant> diff2, ChatId chatId, ProfileId updater, boolean withSystemMessage, boolean isNewChat) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        this.permissionService.replaceRolePermissionsForChat(chatId);
        Iterable $this$mapToSet$iv = diff2.getAdded();
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Iterator p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set addedParticipants = (Set)destination$iv$iv;
        Set effectiveProfileIdsAdded = SetsKt.minus((Set)this.toResolvedProfileIds(addedParticipants), (Iterable)this.toResolvedProfileIds(diff2.getFrom()));
        Iterable $this$mapToSet$iv2 = diff2.getRemoved();
        boolean $i$f$mapToSet2 = false;
        Iterable $i$f$mapTo22 = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo32 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set removedParticipants = (Set)destination$iv$iv2;
        Set effectiveProfileIdsRemoved = SetsKt.minus((Set)this.toResolvedProfileIds(removedParticipants), (Iterable)this.toResolvedProfileIds(diff2.getTo()));
        Iterable $this$mapToSet$iv3 = diff2.getModified();
        boolean $i$f$mapToSet3 = false;
        Iterable $i$f$mapTo32 = $this$mapToSet$iv3;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv3));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set updatedParticipants = (Set)destination$iv$iv3;
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new ChatParticipantsChangedEvent((Object)this, chatId, isNewChat, addedParticipants, effectiveProfileIdsAdded, removedParticipants, effectiveProfileIdsRemoved, updatedParticipants, withSystemMessage, updater));
    }

    static /* synthetic */ void participantsChanged$default(ChatParticipantService chatParticipantService, Diff diff2, ChatId chatId, ProfileId profileId, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: participantsChanged");
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        chatParticipantService.participantsChanged(diff2, chatId, profileId, bl, bl2);
    }

    @Transactional
    @NotNull
    public List<ChatParticipant> moveParticipantsToDeleted(@NotNull ChatId chatId, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        List participantsBeforeDeletion = this.findByChatId(chatId);
        this.chatParticipantRepository.copyParticipantsToDeleted(chatId.getValue());
        this.chatParticipantRepository.deleteByChatId(chatId.getValue());
        ChatParticipantService.saveRemovedParticipantsForSync$default((ChatParticipantService)this, (ChatId)chatId, (Collection)participantsBeforeDeletion, null, (int)4, null);
        Diff diff2 = new Diff((Collection)participantsBeforeDeletion, (Collection)SetsKt.emptySet(), (Function1)moveParticipantsToDeleted.diff.1.INSTANCE, (Function1)moveParticipantsToDeleted.diff.2.INSTANCE);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return participantsBeforeDeletion;
    }

    @Transactional
    public void moveParticipantsFromDeleted(@NotNull ChatId chatId, @NotNull ProfileId restoredBy) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)restoredBy, (String)"restoredBy");
        this.chatParticipantRepository.copyParticipantFromDeleted(chatId.getValue());
        this.chatParticipantRepository.deleteParticipantFromDeleted(chatId.getValue());
        List participantsAfterRestoration = this.findByChatId(chatId);
        Diff diff2 = new Diff((Collection)SetsKt.emptySet(), (Collection)participantsAfterRestoration, (Function1)moveParticipantsFromDeleted.diff.1.INSTANCE, (Function1)moveParticipantsFromDeleted.diff.2.INSTANCE);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void leaveChat(@NotNull ChatId chatId, @NotNull ProfileId currentUserId) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void it;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)currentUserId, (String)"currentUserId");
        List list = iterable = this.findByChatId(chatId);
        ChatId chatId2 = chatId;
        ChatParticipantService chatParticipantService = this;
        boolean $i$a$-also-ChatParticipantService$leaveChat$22 = false;
        this.validateParticipantsForLeaveChat((List)it, chatId, currentUserId);
        Object object = Unit.INSTANCE;
        iterable = iterable;
        boolean $i$f$filter = false;
        void $i$a$-also-ChatParticipantService$leaveChat$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant it2 = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it2.getParticipantId(), (Object)currentUserId))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = (List)destination$iv$iv;
        $this$filter$iv = (Iterable)object;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            ChatParticipant it3 = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it3.getParticipantId(), (Object)it3.getPermissionType());
            map.put(pair.getFirst(), pair.getSecond());
        }
        object = destination$iv$iv2;
        ChatParticipantService.setParticipants$default((ChatParticipantService)chatParticipantService, (ChatId)chatId2, (Map)object, (ProfileId)currentUserId, (boolean)false, (int)8, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, List<ChatParticipant>> findByChatIds(@NotNull Iterable<ChatId> chatIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Iterable<ChatId> iterable = chatIds;
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Iterable $this$associate$iv = chatParticipantRepository.findByChatIds((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            List participants = (List)entry.getValue();
            Iterable iterable2 = participants;
            ChatId chatId2 = new ChatId(chatId);
            boolean $i$f$map2 = false;
            void var18_24 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbChatParticipant dbChatParticipant = (DbChatParticipant)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(DbChatParticipant.Companion.toChatParticipant((DbChatParticipant)it));
            }
            entry = TuplesKt.to((Object)chatId2, (Object)((List)destination$iv$iv3));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @NotNull
    public List<ChatParticipant> findByChatId(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return this.findByChatIds((Iterable)SetsKt.setOf((Object)chatId)).getOrDefault(chatId, CollectionsKt.emptyList());
    }

    @NotNull
    public Set<ProfileId> findEffectiveProfileIdsByChatId(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return this.toResolvedProfileIds((Collection)this.findByChatId(chatId));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Map<ParticipantId, PermissionType>> getParticipantPermissionsByChatIds(@NotNull Iterable<ChatId> chatIds) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Map $this$mapValues$iv = this.findByChatIds(chatIds);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            List participants = (List)entry2.getValue();
            Iterable $this$associate$iv = participants;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map4 = destination$iv$iv2;
                ChatParticipant it = (ChatParticipant)element$iv$iv;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)it.getParticipantId(), (Object)it.getPermissionType());
                map4.put(pair.getFirst(), pair.getSecond());
            }
            Map map5 = destination$iv$iv2;
            map3.put(k, map5);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ChatId> getOneOnOneChatIdByChatPartnerIds(@NotNull Set<ProfileId> chatPartnerIds, @NotNull ProfileId userId) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatPartnerIds, (String)"chatPartnerIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Iterable iterable = chatPartnerIds;
        ChatParticipantRepository chatParticipantRepository = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = chatParticipantRepository.findOneOnOneChatIdByChatPartnerIds((Iterable)((List)destination$iv$iv), userId.toCanonicalId()).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String participantId = (String)entry.getKey();
            UUID chatId = (UUID)entry.getValue();
            entry = TuplesKt.to((Object)ProfileId.Companion.fromCanonicalId(participantId), (Object)new ChatId(chatId));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Nullable
    public ChatId getOneOnOneChatIdByChatPartnerId(@NotNull ProfileId chatPartnerId, @NotNull ProfileId userId) {
        Intrinsics.checkNotNullParameter((Object)chatPartnerId, (String)"chatPartnerId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return (ChatId)this.getOneOnOneChatIdByChatPartnerIds(SetsKt.setOf((Object)chatPartnerId), userId).get(chatPartnerId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findOneOnOneChatIdsByProfileId(@NotNull ProfileId id) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Iterable $this$mapToSet$iv = this.chatParticipantRepository.findOneOnOneChatIdsByProfileId(id.toCanonicalId());
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId((UUID)it));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, Profile> getDirectChatPartnersForProfile(@NotNull Set<ChatId> chatIds, @NotNull ProfileId currentProfileId) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)currentProfileId, (String)"currentProfileId");
        Map $this$mapValuesNotNull$iv = this.getDirectChatPartners(chatIds);
        boolean $i$f$mapValuesNotNull = false;
        Iterable iterable = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object v0;
            Map.Entry entry$iv;
            block5: {
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl = false;
                entry$iv = (Map.Entry)element$iv$iv$iv;
                boolean bl2 = false;
                Map.Entry entry = entry$iv;
                boolean bl3 = false;
                List profiles = (List)entry.getValue();
                Iterable $this$firstOrNull$iv = profiles;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Profile profile = (Profile)element$iv;
                    boolean bl4 = false;
                    if (!(!Intrinsics.areEqual((Object)profile.getId(), (Object)currentProfileId))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            if ((Profile)v0 != null) {
                Profile it$iv;
                boolean bl = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, List<Profile>> getDirectChatPartners(@NotNull Set<ChatId> chatIds) {
        void $this$associateWith$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMapToSet$iv;
        Collection collection;
        Object object;
        Object object2;
        Map.Entry entry;
        Object object3;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Map $this$mapValues$iv = this.findByChatIds((Iterable)chatIds);
        boolean $i$f$mapValues22 = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            void $this$filterIsInstanceToSet$iv$iv;
            void $this$mapTo$iv$iv$iv;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            entry = (Map.Entry)element$iv$iv$iv;
            object2 = it$iv$iv.getKey();
            object = object3;
            boolean bl2 = false;
            List participants = (List)entry.getValue();
            ChatParticipant.Companion companion = ChatParticipant.Companion;
            Iterable $this$filterParticipantIds$iv = participants;
            boolean $i$f$filterParticipantIds = false;
            Iterable $this$map$iv$iv = $this$filterParticipantIds$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void p0$iv;
                ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv$iv;
                Collection collection2 = destination$iv$iv$iv;
                boolean bl3 = false;
                collection2.add(p0$iv.getParticipantId());
            }
            $this$map$iv$iv = (List)destination$iv$iv$iv;
            boolean $i$f$filterIsInstanceToSet = false;
            $this$mapTo$iv$iv$iv = $this$filterIsInstanceToSet$iv$iv;
            destination$iv$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv2 : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv2 instanceof ProfileId)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv2);
            }
            collection = (Set)destination$iv$iv$iv;
            object.put(object2, collection);
        }
        Map chatProfileIdsByChatId = destination$iv$iv;
        Iterable $i$f$mapValues22 = chatProfileIdsByChatId.values();
        object = this.profileService;
        boolean $i$f$flatMapToSet = false;
        destination$iv$iv = $this$flatMapToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Set it = (Set)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Map chatPartners = object.findByIds((Set)destination$iv$iv2);
        $this$flatMapToSet$iv = chatIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void chatId;
            list$iv$iv = (ChatId)element$iv$iv;
            object2 = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            object3 = (Iterable)MapsKt.getValue((Map)chatProfileIdsByChatId, (Object)chatId);
            boolean $i$f$mapNotNull = false;
            entry = $this$mapNotNull$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Profile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                ProfileId profileId = (ProfileId)element$iv$iv2;
                boolean bl5 = false;
                if ((Profile)chatPartners.get(profileId) == null) continue;
                boolean bl6 = false;
                destination$iv$iv3.add(it$iv$iv);
            }
            collection = (List)destination$iv$iv3;
            object.put(object2, collection);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findRecentlyJoinedChatIds(@NotNull ProfileId profileId, @NotNull Instant since) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$mapToSet$iv = this.chatParticipantRepository.findRecentlyJoinedChats(profileId.toCanonicalId(), since);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            UUID uUID = (UUID)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ChatId((UUID)p0));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> findUpdatedDirectParticipants(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        String p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findDirectParticipantsUpdatedSinceByParticipantIds((Iterable)((List)destination$iv$iv), since);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<UserGroupId> findUpdatedGroupParticipants(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        String p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findGroupParticipantsUpdatedSinceByParticipantIds((Iterable)((List)destination$iv$iv), since);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(UserGroupId.Companion.fromCanonicalId((String)it));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ChatId> findChatsWithoutPermission(@NotNull Iterable<ChatId> chatIds, @NotNull PermissionType permissionType) {
        void $this$filterValues$iv;
        void $this$mapValuesTo$iv$iv;
        Object $this$mapValues$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Map $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Map $this$filterIsInstanceToSet$iv;
        Iterable it;
        Object object2;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Map permissions;
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        Map map = permissions = this.findByChatIds(chatIds);
        boolean $i$f$flatMap = false;
        void var7_8 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Map.Entry element$iv$iv : $this$flatMapTo$iv$iv.entrySet()) {
            void $this$mapTo$iv$iv2;
            Map.Entry entry = element$iv$iv;
            boolean bl = false;
            List participants = (List)entry.getValue();
            Iterable $this$map$iv = participants;
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(it.getParticipantId());
            }
            Iterable entry2 = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)entry2);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstanceToSet = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstanceToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)((Object)$this$filterIsInstanceToSet$iv)));
        boolean $i$f$filterIsInstanceTo = false;
        for (Map.Entry element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set profiles = (Set)destination$iv$iv;
        boolean $i$a$-let-ChatParticipantService$findChatsWithoutPermission$activeProfilePermissions$332 = false;
        Map $this$filterValues$iv2 = this.profileService.findByIds(profiles);
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv2.entrySet()) {
            Profile it2 = (Profile)entry.getValue();
            boolean bl = false;
            if (!(it2.getStatus() == ProfileStatus.ACTIVE)) continue;
            ((HashMap)result$iv).put(entry.getKey(), entry.getValue());
        }
        $this$filterIsInstanceToSet$iv = (Map)result$iv;
        boolean $i$f$mapToSet = false;
        void $i$a$-let-ChatParticipantService$findChatsWithoutPermission$activeProfilePermissions$332 = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet($this$mapToSet$iv.size());
        boolean $i$f$mapTo = false;
        result$iv = $this$mapTo$iv$iv.entrySet().iterator();
        while (result$iv.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)result$iv.next();
            object = destination$iv$iv;
            boolean bl = false;
            object.add((ProfileId)entry.getKey());
        }
        Set activeProfilePermissions = (Set)destination$iv$iv;
        $this$mapToSet$iv = permissions;
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv3;
            void $this$map$iv;
            ChatParticipant it4;
            void $this$filterTo$iv$iv;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Object object3 = destination$iv$iv;
            boolean bl3 = false;
            object2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object3;
            boolean bl4 = false;
            List participants = (List)object2.getValue();
            Iterable $this$filter$iv = participants;
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it4 = (ChatParticipant)element$iv$iv;
                boolean bl5 = false;
                boolean bl2 = it4.getParticipantId() instanceof ProfileId ? CollectionsKt.contains((Iterable)activeProfilePermissions, (Object)it4.getParticipantId()) : true;
                if (!bl2) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void p0;
                it4 = (ChatParticipant)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl7 = false;
                collection.add(p0.getPermissionType());
            }
            List list = (List)destination$iv$iv2;
            object.put(k, list);
        }
        $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$filterValues2 = false;
        LinkedHashMap result$iv2 = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it5 = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(!it5.contains(permissionType))) continue;
            result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv2).keySet();
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    @NotNull
    public List<ChatParticipantsChangedEvent> onUserGroupMembersAdded(@NotNull UserGroupMembersAddedEvent event) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterable $this$flatMap$iv = event.getUserGroupMembers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            UserGroupMember userGroupMember = (UserGroupMember)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.findChatsWithParticipants(SetsKt.setOf((Object)userGroupMember.getGroupId()));
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void chatId;
                ChatId chatId2 = (ChatId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new ChatParticipantsChangedEvent((Object)this, (ChatId)chatId, false, null, SetsKt.setOf((Object)userGroupMember.getProfileId()), null, null, null, false, null, 748, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    @NotNull
    public List<ChatParticipantsChangedEvent> onUserGroupMembersRemoved(@NotNull UserGroupMembersRemovedEvent event) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Instant removedAt = this.clock.instant();
        Iterable $this$flatMap$iv = event.getUserGroupMembers();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            UserGroupMember userGroupMember = (UserGroupMember)element$iv$iv;
            boolean bl = false;
            Set chatsWithUserGroupId = this.findChatsWithParticipants(SetsKt.setOf((Object)userGroupMember.getGroupId()));
            Set userGroupsOfUser = this.userGroupService.getUserGroupIdsByProfileId(userGroupMember.getProfileId());
            Set chatsWithUser = this.findChatsWithParticipants(SetsKt.plus((Set)userGroupsOfUser, (Object)userGroupMember.getProfileId()));
            Set chatsEffectivelyRemovedFrom = SetsKt.minus((Set)chatsWithUserGroupId, (Iterable)chatsWithUser);
            Set set = SetsKt.setOf((Object)userGroupMember);
            Intrinsics.checkNotNullExpressionValue((Object)removedAt, (String)"removedAt");
            this.saveRemovedGroupMembersForSync(chatsEffectivelyRemovedFrom, set, removedAt);
            Iterable $this$map$iv = chatsEffectivelyRemovedFrom;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void chatId;
                ChatId chatId2 = (ChatId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(new ChatParticipantsChangedEvent((Object)this, (ChatId)chatId, false, null, null, null, SetsKt.setOf((Object)userGroupMember.getProfileId()), null, false, null, 700, null));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @EventListener
    @Transactional
    @NotNull
    public List<ChatParticipantsChangedEvent> onProfileDeleted(@NotNull ProfileDeletedEvent profileDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileDeletedEvent, (String)"profileDeletedEvent");
        return ChatParticipantService.deleteParticipant$default((ChatParticipantService)this, (ParticipantId)((ParticipantId)profileDeletedEvent.getProfileId()), null, (int)2, null);
    }

    @EventListener
    @Transactional
    @NotNull
    public List<ChatParticipantsChangedEvent> onUserGroupDeleted(@NotNull UserGroupDeletedEvent userGroupDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)userGroupDeletedEvent, (String)"userGroupDeletedEvent");
        return this.deleteParticipant((ParticipantId)userGroupDeletedEvent.getUserGroupId(), userGroupDeletedEvent.getUserGroupMembers());
    }

    /*
     * WARNING - void declaration
     */
    private List<ChatParticipantsChangedEvent> deleteParticipant(ParticipantId participantId, Set<UserGroupMember> deletedUserGroupMembers) {
        void $this$mapTo$iv$iv;
        Collection collection;
        ChatId $this$mapTo$iv$iv2;
        void $this$mapToSet$iv;
        Set set;
        Set chatIdsWithDeletedParticipant = set = this.findChatsWithParticipants(SetsKt.setOf((Object)participantId));
        boolean $i$a$-also-ChatParticipantService$deleteParticipant$22 = false;
        this.chatParticipantRepository.deleteByParticipantIds(SetsKt.setOf((Object)participantId.toCanonicalId()));
        Instant deletedAt = this.clock.instant();
        Iterable iterable = chatIdsWithDeletedParticipant;
        ChatRepository chatRepository = this.chatRepository;
        boolean $i$f$mapToSet = false;
        void var10_14 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Intrinsics.checkNotNullExpressionValue((Object)deletedAt, (String)"deletedAt");
        chatRepository.updateSyncDateByChatIds((Set)destination$iv$iv, deletedAt);
        this.saveRemovedGroupMembersForSync(chatIdsWithDeletedParticipant, deletedUserGroupMembers, deletedAt);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable $i$a$-also-ChatParticipantService$deleteParticipant$22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void chatId;
            Set set2;
            $this$mapTo$iv$iv2 = (ChatId)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            ChatParticipantService chatParticipantService = this;
            ParticipantId $i$f$mapTo3 = participantId;
            if ($i$f$mapTo3 instanceof UserGroupId) {
                void $this$mapTo$iv$iv3;
                void $this$mapToSet$iv2;
                Iterable iterable2 = deletedUserGroupMembers;
                ChatParticipantService chatParticipantService2 = chatParticipantService;
                boolean $i$f$mapToSet2 = false;
                collection = $this$mapToSet$iv2;
                Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                    void p0;
                    UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv2;
                    Collection collection3 = destination$iv$iv3;
                    boolean bl2 = false;
                    collection3.add(p0.getProfileId());
                }
                set2 = (Set)destination$iv$iv3;
                chatParticipantService = chatParticipantService2;
            } else if ($i$f$mapTo3 instanceof ProfileId) {
                set2 = SetsKt.setOf((Object)participantId);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Set deletedProfileIds = chatParticipantService.toResolvedProfileIds(set2);
            Set currentProfileIds = this.toResolvedProfileIds((Collection)this.findByChatId((ChatId)chatId));
            collection2.add(new ChatParticipantsChangedEvent((Object)this, (ChatId)chatId, false, null, null, SetsKt.setOf((Object)participantId), SetsKt.minus((Set)deletedProfileIds, (Iterable)currentProfileIds), null, true, null, 668, null));
        }
        return (List)destination$iv$iv2;
    }

    static /* synthetic */ List deleteParticipant$default(ChatParticipantService chatParticipantService, ParticipantId participantId, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: deleteParticipant");
        }
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return chatParticipantService.deleteParticipant(participantId, set);
    }

    private void saveRemovedGroupMembersForSync(Set<ChatId> chatIds, Set<UserGroupMember> removedGroupMembers, Instant removedAt) {
        Iterable $this$forEach$iv = chatIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId chatId = (ChatId)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = removedGroupMembers;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                UserGroupMember removedGroupMember = (UserGroupMember)element$iv2;
                boolean bl2 = false;
                this.removedParticipantProfileRepository.save((Object)this.createDbRemovedParticipantProfile(removedGroupMember.getProfileId(), chatId, removedAt));
            }
        }
    }

    private void validateParticipantChanges(ChatId chatId, Diff<ChatParticipant> diff2, ProfileId currentUserId, boolean isNewChat) throws ValidationException {
        DbChat chat = this.validatedChatForParticipantChange(chatId, isNewChat);
        this.validateResultingParticipants(chat.getType(), diff2);
        this.validateAddedParticipants(new TenantId(chat.getTenantId()), diff2, currentUserId);
    }

    private DbChat validatedChatForParticipantChange(ChatId chatId, boolean isNewChat) throws ValidationException {
        DbChat chat = (DbChat)this.chatRepository.findById((Object)chatId.getValue()).orElseThrow(() -> ChatParticipantService.validatedChatForParticipantChange$lambda-46(chatId));
        if (chat.getType() == ChatType.ONE_ON_ONE && !isNewChat) {
            throw new ValidationException("ONE_ON_ONE chats may not be updated");
        }
        Intrinsics.checkNotNullExpressionValue((Object)chat, (String)"chat");
        return chat;
    }

    /*
     * WARNING - void declaration
     */
    private void validateResultingParticipants(ChatType chatType, Diff<ChatParticipant> diff2) throws ValidationException {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = diff2.getTo();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!(it.getPermissionType() == PermissionType.MANAGER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List managers = (List)destination$iv$iv;
        switch (WhenMappings.$EnumSwitchMapping$0[chatType.ordinal()]) {
            case 1: {
                if (diff2.getTo().size() == 2 && managers.size() == 2) break;
                throw new ValidationException("A ONE_ON_ONE chat requires exactly 2 managers");
            }
            case 2: {
                if (!managers.isEmpty()) break;
                throw new ValidationException("A chat requires at least one manager");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void validateAddedParticipants(TenantId tenantId, Diff<ChatParticipant> diff2, ProfileId currentUserId) throws ValidationException {
        void $this$filterIsInstanceTo$iv$iv;
        Object element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        void $this$filterValues$iv;
        void $this$mapTo$iv$iv;
        if (diff2.getAdded().isEmpty()) {
            return;
        }
        Iterable $this$mapToSet$iv = diff2.getAdded();
        boolean $i$f$mapToSet22 = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        Set addedParticipantIds = (Set)destination$iv$iv;
        Map $i$f$mapToSet22 = this.authorizationService.mayReadParticipants(addedParticipantIds, currentUserId);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            boolean it = (Boolean)entry$iv.getValue();
            boolean bl = false;
            if (!(!it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set notReadableParticipantIds = ((Map)result$iv).keySet();
        if (!((Collection)notReadableParticipantIds).isEmpty()) {
            throw new ValidationException("Adding not readable participants is not allowed: " + notReadableParticipantIds);
        }
        Iterable $this$filterIsInstanceToSet$iv = addedParticipantIds;
        boolean $i$f$filterIsInstanceToSet = false;
        Iterable $i$f$mapTo22 = $this$filterIsInstanceToSet$iv;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        Iterator bl = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (bl.hasNext()) {
            Object element$iv$iv = bl.next();
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv2;
        Iterable $this$forEach$iv = profileIds;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ProfileId profileId = (ProfileId)element$iv2;
            boolean bl2 = false;
            if (this.authorizationService.mayProfileReadTenant(tenantId, profileId)) continue;
            throw new ValidationException(profileId + " is not in the same tenant as chat tenant.");
        }
        Iterable $this$filterIsInstanceToSet$iv2 = addedParticipantIds;
        boolean $i$f$filterIsInstanceToSet2 = false;
        element$iv2 = $this$filterIsInstanceToSet$iv2;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv2));
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set userGroupIds = (Set)destination$iv$iv3;
        Map userGroups = this.userGroupService.findByIds(userGroupIds);
        Iterable $this$forEach$iv2 = userGroupIds;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            UserGroup userGroup;
            UserGroupId userGroupId = (UserGroupId)element$iv3;
            boolean bl3 = false;
            if ((UserGroup)userGroups.get(userGroupId) == null) {
                throw new ValidationException(userGroupId + " does not exists.");
            }
            if (Intrinsics.areEqual((Object)userGroup.getTenantId(), (Object)tenantId)) continue;
            throw new ValidationException(userGroupId + " is not in the same tenant as chat tenant.");
        }
    }

    private void validateParticipantsForLeaveChat(List<ChatParticipant> participants, ChatId chatId, ProfileId currentUserId) {
        Object v0;
        ChatParticipant it;
        Iterable $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        block5: {
            Iterable iterable = participants;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (ChatParticipant)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getParticipantId(), (Object)currentUserId)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        ChatParticipant chatParticipant = v0;
        if (chatParticipant == null) {
            throw new NotAllowedException("Cannot leave " + chatId + ". " + currentUserId + " participates through group membership.");
        }
        ChatParticipant participant = chatParticipant;
        if (participant.getPermissionType() == PermissionType.MANAGER) {
            Object v2;
            block6: {
                $this$firstOrNull$iv = participants;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (ChatParticipant)element$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getParticipantId(), (Object)currentUserId) && it.getPermissionType() == PermissionType.MANAGER)) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            if ((ChatParticipant)v2 == null) {
                throw new NotAllowedException("Cannot leave " + chatId + ". " + currentUserId + " is the only manager left.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<ChatId> findChatsWithParticipants(Set<? extends ParticipantId> participantIds) {
        DbChatParticipant p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = participantIds;
        Object object = this.chatParticipantRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findByParticipantIds((Iterable)((List)destination$iv$iv));
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatParticipant)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(new ChatId(it.getChatId()));
        }
        return (Set)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> toResolvedProfileIds(Collection<ChatParticipant> $this$toResolvedProfileIds) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Iterable iterable = $this$toResolvedProfileIds;
        ChatParticipantService chatParticipantService = this;
        boolean $i$f$mapToSet = false;
        void var4_5 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getParticipantId());
        }
        return chatParticipantService.toResolvedProfileIds((Set)destination$iv$iv);
    }

    private Set<ProfileId> toResolvedProfileIds(Set<? extends ParticipantId> $this$toResolvedProfileIds) {
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstanceToSet$iv;
        Iterable iterable = $this$toResolvedProfileIds;
        Object object = this;
        boolean $i$f$filterIsInstanceToSet = false;
        void var4_5 = $this$filterIsInstanceToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstanceToSet$iv = $this$toResolvedProfileIds;
        object = object.getProfileIdsOfMembers((Set)destination$iv$iv);
        $i$f$filterIsInstanceToSet = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstanceToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return SetsKt.plus((Set)object, (Iterable)((Set)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> getProfileIdsOfMembers(Set<UserGroupId> userGroupIds) {
        void $this$flatMapTo$iv$iv;
        Map $this$flatMapToSet$iv = this.userGroupService.getUserGroupMembersByUserGroupIds(userGroupIds);
        boolean $i$f$flatMapToSet = false;
        Map map = $this$flatMapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet($this$flatMapToSet$iv.size());
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Iterable $this$mapToSet$iv = (Iterable)it.getValue();
            boolean $i$f$mapToSet = false;
            Iterable iterable = $this$mapToSet$iv;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                UserGroupMember userGroupMember = (UserGroupMember)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.getProfileId());
            }
            Iterable list$iv$iv = (Set)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (Set)destination$iv$iv;
    }

    private DbRemovedParticipantProfileForSync createDbRemovedParticipantProfile(ProfileId profileId, ChatId chatId, Instant removedAt) {
        return new DbRemovedParticipantProfileForSync(profileId.toCanonicalId(), chatId.getValue(), removedAt);
    }

    private static final ValidationException validatedChatForParticipantChange$lambda-46(ChatId $chatId) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return new ValidationException("No chat for id " + $chatId);
    }

    public static final /* synthetic */ void access$participantsChanged(ChatParticipantService $this, Diff diff2, ChatId chatId, ProfileId updater, boolean withSystemMessage, boolean isNewChat) {
        $this.participantsChanged(diff2, chatId, updater, withSystemMessage, isNewChat);
    }

    public static final /* synthetic */ PermissionService access$getPermissionService$p(ChatParticipantService $this) {
        return $this.permissionService;
    }
}

