/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatMessageLocalizationService;
import de.justsoftware.chat.business.ChatMessageLocalizationService$localizeDisplayNames$;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.DeletedMessage;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.model.ChatMessagePayload;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0017\u0018\u0000 @2\u00020\u0001:\u0002@AB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J>\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\n*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u000eH\u0012J\u001c\u0010\u001c\u001a\u00020\n*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u000eH\u0012J\u001c\u0010\u001e\u001a\u00020\n*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u000eH\u0012J\f\u0010 \u001a\u00020\n*\u00020\u0019H\u0012J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\n0\"*\u00020\u00192\u0006\u0010#\u001a\u00020\u00172\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0012J\f\u0010'\u001a\u00020\n*\u00020\u0019H\u0012J\u0014\u0010(\u001a\u00020\n*\u00020\u00192\u0006\u0010)\u001a\u00020\u000eH\u0012J \u0010*\u001a\b\u0012\u0004\u0012\u00020\n0\"*\u00020\u00192\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,H\u0012J\u001c\u0010-\u001a\u00020\n*\u00020\u00192\u0006\u0010\u001a\u001a\u00020.2\u0006\u0010\u0014\u001a\u00020\u000eH\u0012J\u001c\u0010/\u001a\u00020\n*\u00020\u00192\u0006\u0010\u001a\u001a\u00020.2\u0006\u0010#\u001a\u00020\u0017H\u0012J\u0014\u00100\u001a\u00020\n*\u00020\u00192\u0006\u00101\u001a\u000202H\u0012J&\u00103\u001a\u00020\n*\u00020\u00192\u0006\u00104\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0012J\u0014\u00105\u001a\u00020\n*\u00020\u00192\u0006\u00106\u001a\u00020\u000eH\u0012J\f\u00107\u001a\u00020\n*\u00020\u0019H\u0012J \u00108\u001a\b\u0012\u0004\u0012\u00020\n0\"*\u00020\u00192\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0,H\u0012J-\u0010;\u001a\u00020\n*\u00020\u00192\u0006\u0010<\u001a\u00020\n2\u0012\u0010=\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010>\"\u00020\u0001H\u0012\u00a2\u0006\u0002\u0010?R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lde/justsoftware/chat/business/ChatMessageLocalizationService;", "", "resourceBundle", "Lorg/springframework/context/support/ResourceBundleMessageSource;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "(Lorg/springframework/context/support/ResourceBundleMessageSource;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/UserGroupService;)V", "localize", "", "message", "Lde/justsoftware/chat/business/model/ChatMessage;", "currentUser", "Lde/justsoftware/chat/model/ProfileId;", "locale", "Ljava/util/Locale;", "localizeTeaser", "chat", "Lde/justsoftware/chat/business/model/Chat;", "author", "Lde/justsoftware/chat/business/model/Profile;", "addMimeTypePrefixToFileNames", "", "localizeAddedToChat", "Lde/justsoftware/chat/business/ChatMessageLocalizationService$Context;", "payload", "Lde/justsoftware/chat/model/ChatMessagePayload$AddedToChat;", "localizeChatCreated", "Lde/justsoftware/chat/model/ChatMessagePayload$ChatCreated;", "localizeChatTitleChanged", "Lde/justsoftware/chat/model/ChatMessagePayload$ChatTitleChanged;", "localizeDeletedMessage", "localizeDisplayNames", "", "currentUserAffected", "participants", "", "Lde/justsoftware/chat/model/ParticipantId;", "localizePersonDeleted", "localizeProfileName", "profileId", "localizeProfileNames", "profileIds", "", "localizeRemovedFromChat", "Lde/justsoftware/chat/model/ChatMessagePayload$RemovedFromChat;", "localizeStaysInChatSuffix", "localizeSystemMessage", "systemMessage", "Lde/justsoftware/chat/business/model/SystemMessage;", "localizeTeaserText", "text", "localizeUpdaterName", "updater", "localizeUserGroupDeleted", "localizeUserGroupNames", "userGroupIds", "Lde/justsoftware/chat/model/UserGroupId;", "resolveMessage", "code", "args", "", "(Lde/justsoftware/chat/business/ChatMessageLocalizationService$Context;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Companion", "Context", "chat-service"})
public class ChatMessageLocalizationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceBundleMessageSource resourceBundle;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    private static final int PROFILE_AND_GROUP_DISPLAY_LIMIT = 5;

    public ChatMessageLocalizationService(@NotNull ResourceBundleMessageSource resourceBundle, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService) {
        Intrinsics.checkNotNullParameter((Object)resourceBundle, (String)"resourceBundle");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        this.resourceBundle = resourceBundle;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
    }

    @Nullable
    public String localizeTeaser(@NotNull ChatMessage message2, @NotNull Chat chat, @Nullable Profile author, @NotNull ProfileId currentUser, @NotNull Locale locale, boolean addMimeTypePrefixToFileNames) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Context $this$localizeTeaser_u24lambda_u2d0 = new Context(currentUser, locale);
        boolean bl = false;
        ChatMessage chatMessage = message2;
        if (chatMessage instanceof SystemMessage) {
            string2 = null;
        } else if (chatMessage instanceof DeletedMessage) {
            string2 = this.localizeTeaserText($this$localizeTeaser_u24lambda_u2d0, this.localizeDeletedMessage($this$localizeTeaser_u24lambda_u2d0), chat, author);
        } else if (chatMessage instanceof UserMessage) {
            string2 = this.localizeTeaserText($this$localizeTeaser_u24lambda_u2d0, UserMessage.Companion.attachmentFileNameOrMessage((UserMessage)message2, addMimeTypePrefixToFileNames), chat, author);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    public static /* synthetic */ String localizeTeaser$default(ChatMessageLocalizationService chatMessageLocalizationService, ChatMessage chatMessage, Chat chat, Profile profile, ProfileId profileId, Locale locale, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: localizeTeaser");
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return chatMessageLocalizationService.localizeTeaser(chatMessage, chat, profile, profileId, locale, bl);
    }

    @NotNull
    public String localize(@NotNull ChatMessage message2, @NotNull ProfileId currentUser, @NotNull Locale locale) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Context $this$localize_u24lambda_u2d1 = new Context(currentUser, locale);
        boolean bl = false;
        ChatMessage chatMessage = message2;
        if (chatMessage instanceof UserMessage) {
            string2 = ((UserMessage)message2).getMessage();
        } else if (chatMessage instanceof SystemMessage) {
            string2 = this.localizeSystemMessage($this$localize_u24lambda_u2d1, (SystemMessage)message2);
        } else if (chatMessage instanceof DeletedMessage) {
            string2 = this.localizeDeletedMessage($this$localize_u24lambda_u2d1);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private String localizeTeaserText(Context $this$localizeTeaserText, String text, Chat chat, Profile author) {
        String string2;
        Profile profile = author;
        if (Intrinsics.areEqual((Object)(profile != null ? profile.getId() : null), (Object)$this$localizeTeaserText.getCurrentUser())) {
            Object[] objectArray = new Object[]{text};
            string2 = this.resolveMessage($this$localizeTeaserText, "chat.teaser.fromMe", objectArray);
        } else if (chat instanceof MultiUserChat && author != null) {
            Object[] objectArray = new Object[]{author.getFullName(), text};
            string2 = this.resolveMessage($this$localizeTeaserText, "chat.teaser.fromOther", objectArray);
        } else {
            string2 = text;
        }
        return string2;
    }

    private String localizeSystemMessage(Context $this$localizeSystemMessage, SystemMessage systemMessage) {
        String string2;
        ChatMessagePayload payload2 = systemMessage.getPayload();
        if (payload2 instanceof ChatMessagePayload.ChatTitleChanged) {
            string2 = this.localizeChatTitleChanged($this$localizeSystemMessage, (ChatMessagePayload.ChatTitleChanged)payload2, systemMessage.getAuthor());
        } else if (payload2 instanceof ChatMessagePayload.ChatCreated) {
            string2 = this.localizeChatCreated($this$localizeSystemMessage, (ChatMessagePayload.ChatCreated)payload2, systemMessage.getAuthor());
        } else if (payload2 instanceof ChatMessagePayload.PersonDeleted) {
            string2 = this.localizePersonDeleted($this$localizeSystemMessage);
        } else if (payload2 instanceof ChatMessagePayload.UserGroupDeleted) {
            string2 = this.localizeUserGroupDeleted($this$localizeSystemMessage);
        } else if (payload2 instanceof ChatMessagePayload.AddedToChat) {
            string2 = this.localizeAddedToChat($this$localizeSystemMessage, (ChatMessagePayload.AddedToChat)payload2, systemMessage.getAuthor());
        } else if (payload2 instanceof ChatMessagePayload.RemovedFromChat) {
            string2 = this.localizeRemovedFromChat($this$localizeSystemMessage, (ChatMessagePayload.RemovedFromChat)payload2, systemMessage.getAuthor());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    private String localizeChatTitleChanged(Context $this$localizeChatTitleChanged, ChatMessagePayload.ChatTitleChanged payload2, ProfileId author) {
        String string2;
        if (Intrinsics.areEqual((Object)$this$localizeChatTitleChanged.getCurrentUser(), (Object)author)) {
            Object[] objectArray = new Object[]{payload2.getOldTitle(), payload2.getNewTitle()};
            string2 = this.resolveMessage($this$localizeChatTitleChanged, "chat.system.message.youChangedTitle", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.localizeProfileName($this$localizeChatTitleChanged, author), payload2.getOldTitle(), payload2.getNewTitle()};
            string2 = this.resolveMessage($this$localizeChatTitleChanged, "chat.system.message.someoneChangedTitle", objectArray);
        }
        return string2;
    }

    private String localizeChatCreated(Context $this$localizeChatCreated, ChatMessagePayload.ChatCreated payload2, ProfileId author) {
        String string2;
        if (Intrinsics.areEqual((Object)$this$localizeChatCreated.getCurrentUser(), (Object)author)) {
            Object[] objectArray = new Object[]{payload2.getTitle()};
            string2 = this.resolveMessage($this$localizeChatCreated, "chat.system.message.youCreatedChat", objectArray);
        } else {
            Object[] objectArray = new Object[]{this.localizeProfileName($this$localizeChatCreated, author), payload2.getTitle()};
            string2 = this.resolveMessage($this$localizeChatCreated, "chat.system.message.someoneCreatedChat", objectArray);
        }
        return string2;
    }

    private String localizePersonDeleted(Context $this$localizePersonDeleted) {
        return this.resolveMessage($this$localizePersonDeleted, "chat.system.message.aDeletedUserWasRemovedFromTheConversation", new Object[0]);
    }

    private String localizeUserGroupDeleted(Context $this$localizeUserGroupDeleted) {
        return this.resolveMessage($this$localizeUserGroupDeleted, "chat.system.message.aDeletedUserGroupWasRemovedFromTheConversation", new Object[0]);
    }

    private String localizeAddedToChat(Context $this$localizeAddedToChat, ChatMessagePayload.AddedToChat payload2, ProfileId author) {
        String string2;
        Set participants = payload2.getParticipants();
        boolean currentUserAffected = participants.contains($this$localizeAddedToChat.getCurrentUser());
        List localizedDisplayNames = this.localizeDisplayNames($this$localizeAddedToChat, currentUserAffected, participants);
        String localizedUpdaterName = this.localizeUpdaterName($this$localizeAddedToChat, author);
        if (participants.size() == 1 && currentUserAffected) {
            Object[] objectArray = new Object[]{localizedUpdaterName};
            string2 = this.resolveMessage($this$localizeAddedToChat, "chat.system.message.youWereAdded", objectArray);
        } else if (participants.size() == 1) {
            Object[] objectArray = new Object[]{CollectionsKt.first((List)localizedDisplayNames), localizedUpdaterName};
            string2 = this.resolveMessage($this$localizeAddedToChat, "chat.system.message.oneWasAdded", objectArray);
        } else if (participants.size() <= 5) {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)localizedDisplayNames, (int)(localizedDisplayNames.size() - 1)), null, null, null, (int)0, null, null, (int)63, null), CollectionsKt.last((List)localizedDisplayNames), localizedUpdaterName};
            string2 = this.resolveMessage($this$localizeAddedToChat, "chat.system.message.someWereAdded", objectArray);
        } else {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)localizedDisplayNames, null, null, null, (int)0, null, null, (int)63, null), participants.size() - 5, localizedUpdaterName};
            string2 = this.resolveMessage($this$localizeAddedToChat, "chat.system.message.someAndNAdditionalWereAdded", objectArray);
        }
        return string2;
    }

    private String localizeRemovedFromChat(Context $this$localizeRemovedFromChat, ChatMessagePayload.RemovedFromChat payload2, ProfileId author) {
        String string2;
        Set participants = payload2.getParticipants();
        boolean currentUserAffected = participants.contains($this$localizeRemovedFromChat.getCurrentUser());
        boolean authorRemovedHerself = participants.contains(author);
        List displayNames = this.localizeDisplayNames($this$localizeRemovedFromChat, currentUserAffected, participants);
        String updaterName = this.localizeUpdaterName($this$localizeRemovedFromChat, author);
        if (participants.size() == 1 && currentUserAffected && authorRemovedHerself) {
            string2 = this.resolveMessage($this$localizeRemovedFromChat, "chat.system.message.youLeft", new Object[0]);
        } else if (participants.size() == 1 && currentUserAffected) {
            Object[] objectArray = new Object[]{updaterName};
            string2 = this.resolveMessage($this$localizeRemovedFromChat, "chat.system.message.youWereRemoved", objectArray);
        } else if (participants.size() == 1 && authorRemovedHerself) {
            Object[] objectArray = new Object[]{CollectionsKt.first((List)displayNames)};
            string2 = this.resolveMessage($this$localizeRemovedFromChat, "chat.system.message.oneLeft", objectArray);
        } else if (participants.size() == 1) {
            Object[] objectArray = new Object[]{CollectionsKt.first((List)displayNames), updaterName};
            string2 = this.resolveMessage($this$localizeRemovedFromChat, "chat.system.message.oneWasRemoved", objectArray);
        } else if (participants.size() <= 5) {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)displayNames, (int)(displayNames.size() - 1)), null, null, null, (int)0, null, null, (int)63, null), CollectionsKt.last((List)displayNames), updaterName};
            string2 = this.resolveMessage($this$localizeRemovedFromChat, "chat.system.message.someWereRemoved", objectArray);
        } else {
            Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)displayNames, null, null, null, (int)0, null, null, (int)63, null), participants.size() - 5, updaterName};
            string2 = this.resolveMessage($this$localizeRemovedFromChat, "chat.system.message.someAndNAdditionalWereRemoved", objectArray);
        }
        return string2 + this.localizeStaysInChatSuffix($this$localizeRemovedFromChat, payload2, currentUserAffected);
    }

    private String localizeStaysInChatSuffix(Context $this$localizeStaysInChatSuffix, ChatMessagePayload.RemovedFromChat payload2, boolean currentUserAffected) {
        boolean oneStaysInChat;
        Set removedProfileIdsStayingInUserGroups = payload2.getRemovedProfileIdsStayingInUserGroups();
        Set participants = payload2.getParticipants();
        boolean currentUserStaysInChat = currentUserAffected && removedProfileIdsStayingInUserGroups.contains($this$localizeStaysInChatSuffix.getCurrentUser());
        boolean bl = oneStaysInChat = !currentUserStaysInChat && participants.size() == 1 && removedProfileIdsStayingInUserGroups.size() == 1;
        boolean someStayInChat = !oneStaysInChat && !((Collection)removedProfileIdsStayingInUserGroups).isEmpty();
        return currentUserStaysInChat ? this.resolveMessage($this$localizeStaysInChatSuffix, "chat.system.message.youStaySuffix", new Object[0]) : (oneStaysInChat ? this.resolveMessage($this$localizeStaysInChatSuffix, "chat.system.message.oneStaysSuffix", new Object[0]) : (someStayInChat ? this.resolveMessage($this$localizeStaysInChatSuffix, "chat.system.message.someStaySuffix", new Object[0]) : ""));
    }

    private String localizeUpdaterName(Context $this$localizeUpdaterName, ProfileId updater) {
        return Intrinsics.areEqual((Object)$this$localizeUpdaterName.getCurrentUser(), (Object)updater) ? this.resolveMessage($this$localizeUpdaterName, "chat.system.message.youDative", new Object[0]) : this.localizeProfileName($this$localizeUpdaterName, updater);
    }

    private String localizeDeletedMessage(Context $this$localizeDeletedMessage) {
        return this.resolveMessage($this$localizeDeletedMessage, "chat.message.deleted", new Object[0]);
    }

    private List<String> localizeDisplayNames(Context $this$localizeDisplayNames, boolean currentUserAffected, Set<? extends ParticipantId> participants) {
        Iterable $this$partitionByType$iv = participants;
        boolean $i$f$partitionByType = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partitionByType$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            ParticipantId it;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (element$iv instanceof ProfileId) {
                it = (ParticipantId)element$iv;
                bl = false;
                if (!Intrinsics.areEqual((Object)it, (Object)$this$localizeDisplayNames.getCurrentUser())) {
                    first$iv.add(element$iv);
                }
            }
            if (!(element$iv instanceof UserGroupId)) continue;
            it = (ParticipantId)element$iv;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)$this$localizeDisplayNames.getCurrentUser()))) continue;
            second$iv.add(element$iv);
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List profileIds = (List)pair.component1();
        List userGroupIds = (List)pair.component2();
        int limit = 5 - (currentUserAffected ? 1 : 0);
        Iterable $this$sortedBy$iv = userGroupIds;
        boolean $i$f$sortedBy = false;
        List userGroupIdsToDisplay = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new localizeDisplayNames$$inlined$sortedBy$1())), (int)limit);
        Iterable $this$sortedBy$iv2 = profileIds;
        boolean $i$f$sortedBy2 = false;
        List profileIdsToDisplay = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)((Comparator)new localizeDisplayNames$$inlined$sortedBy$2())), (int)(limit - userGroupIdsToDisplay.size()));
        List currentUserDisplayName = currentUserAffected ? CollectionsKt.listOf((Object)this.resolveMessage($this$localizeDisplayNames, "chat.system.message.youCapital", new Object[0])) : CollectionsKt.emptyList();
        List userGroupNames = CollectionsKt.sorted((Iterable)this.localizeUserGroupNames($this$localizeDisplayNames, (Collection)userGroupIdsToDisplay));
        List profileNames = CollectionsKt.sorted((Iterable)this.localizeProfileNames($this$localizeDisplayNames, (Collection)profileIdsToDisplay));
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)currentUserDisplayName, (Iterable)userGroupNames), (Iterable)profileNames);
    }

    private String localizeProfileName(Context $this$localizeProfileName, ProfileId profileId) {
        return (String)CollectionsKt.first((List)this.localizeProfileNames($this$localizeProfileName, (Collection)SetsKt.setOf((Object)profileId)));
    }

    /*
     * WARNING - void declaration
     */
    private List<String> localizeProfileNames(Context $this$localizeProfileNames, Collection<ProfileId> profileIds) {
        void $this$mapTo$iv$iv;
        Map profiles = this.profileService.findByIds(CollectionsKt.toSet((Iterable)profileIds));
        boolean bl = false;
        Iterable $this$map$iv = profileIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void profileId;
            ProfileId profileId2 = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object object = (Profile)profiles.get(profileId);
            if (object == null || (object = object.getFullName()) == null) {
                object = this.resolveMessage($this$localizeProfileNames, "chat.user.deleted", new Object[0]);
            }
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private List<String> localizeUserGroupNames(Context $this$localizeUserGroupNames, Collection<UserGroupId> userGroupIds) {
        void $this$mapTo$iv$iv;
        Map userGroups = this.userGroupService.findByIds(CollectionsKt.toSet((Iterable)userGroupIds));
        boolean bl = false;
        Iterable $this$map$iv = userGroupIds;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void userGroupId;
            UserGroupId userGroupId2 = (UserGroupId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            UserGroup userGroup = (UserGroup)userGroups.get(userGroupId);
            collection.add(userGroup == null ? this.resolveMessage($this$localizeUserGroupNames, "chat.group.deleted", new Object[0]) : (userGroup.isAllTenantUsersGroup() ? Companion.access$embedInQuotes((Companion)Companion, (String)this.resolveMessage($this$localizeUserGroupNames, "chat.group.allUsers", new Object[0])) : Companion.access$embedInQuotes((Companion)Companion, (String)userGroup.getName())));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private String resolveMessage(Context $this$resolveMessage, String code, Object ... args) {
        void it;
        Object[] objectArray;
        Object[] objectArray2 = objectArray = args;
        String string2 = code;
        ResourceBundleMessageSource resourceBundleMessageSource = this.resourceBundle;
        boolean bl = false;
        boolean bl2 = !(((void)it).length == 0);
        String string3 = resourceBundleMessageSource.getMessage(string2, (Object[])(bl2 ? objectArray : null), $this$resolveMessage.getLocale());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resourceBundle.getMessag\u2026         locale\n        )");
        return string3;
    }
}

