/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatCleanupService;
import de.justsoftware.chat.business.ConfigService;
import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.kafka.DriveItemIdProducer;
import de.justsoftware.chat.kafka.search.UpdateCommonSearchIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.persistence.ChatDeletionRepository;
import de.justsoftware.chat.persistence.ChatParticipantRepository;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.model.DbChatDeletion;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/chat/business/ChatCleanupService;", "", "chatParticipantRepository", "Lde/justsoftware/chat/persistence/ChatParticipantRepository;", "chatDeletionRepository", "Lde/justsoftware/chat/persistence/ChatDeletionRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "permissionService", "Lde/justsoftware/chat/business/PermissionService;", "updateCommonSearchIndexProducer", "Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexProducer;", "driveItemIdProducer", "Lde/justsoftware/chat/kafka/DriveItemIdProducer;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "configService", "Lde/justsoftware/chat/business/ConfigService;", "(Lde/justsoftware/chat/persistence/ChatParticipantRepository;Lde/justsoftware/chat/persistence/ChatDeletionRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lde/justsoftware/chat/business/PermissionService;Lde/justsoftware/chat/kafka/search/UpdateCommonSearchIndexProducer;Lde/justsoftware/chat/kafka/DriveItemIdProducer;Lde/justsoftware/chat/util/TransactionUtils;Lde/justsoftware/chat/business/ConfigService;)V", "cleanupChats", "", "abandonedBefore", "Ljava/time/Instant;", "startChatCleanup", "Companion", "chat-service"})
public class ChatCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChatParticipantRepository chatParticipantRepository;
    @NotNull
    private final ChatDeletionRepository chatDeletionRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final UpdateCommonSearchIndexProducer updateCommonSearchIndexProducer;
    @NotNull
    private final DriveItemIdProducer driveItemIdProducer;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ConfigService configService;
    @NotNull
    private static final Logger LOG;

    public ChatCleanupService(@NotNull ChatParticipantRepository chatParticipantRepository, @NotNull ChatDeletionRepository chatDeletionRepository, @NotNull ChatRepository chatRepository, @NotNull PermissionService permissionService, @NotNull UpdateCommonSearchIndexProducer updateCommonSearchIndexProducer, @NotNull DriveItemIdProducer driveItemIdProducer, @NotNull TransactionUtils transactionUtils, @NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)chatParticipantRepository, (String)"chatParticipantRepository");
        Intrinsics.checkNotNullParameter((Object)chatDeletionRepository, (String)"chatDeletionRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)updateCommonSearchIndexProducer, (String)"updateCommonSearchIndexProducer");
        Intrinsics.checkNotNullParameter((Object)driveItemIdProducer, (String)"driveItemIdProducer");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.chatParticipantRepository = chatParticipantRepository;
        this.chatDeletionRepository = chatDeletionRepository;
        this.chatRepository = chatRepository;
        this.permissionService = permissionService;
        this.updateCommonSearchIndexProducer = updateCommonSearchIndexProducer;
        this.driveItemIdProducer = driveItemIdProducer;
        this.transactionUtils = transactionUtils;
        this.configService = configService;
    }

    @Scheduled(fixedRate=60L, initialDelay=1L, timeUnit=TimeUnit.MINUTES)
    @Transactional
    public void startChatCleanup() {
        long abandonedForSeconds = TimeUnit.SECONDS.convert(this.configService.chatCleanupAfterExpression());
        if (abandonedForSeconds <= 0L) {
            LOG.info("ChatCleanup is deactivated via Superoperty");
            return;
        }
        LOG.info("Starting ChatCleanup job with abandonedForSeconds: {}...", (Object)abandonedForSeconds);
        Instant instant = Instant.now().minusSeconds(abandonedForSeconds);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now().minusSeconds(abandonedForSeconds)");
        this.cleanupChats(instant);
        LOG.info("ChatCleanup job finished.");
    }

    /*
     * WARNING - void declaration
     */
    public void cleanupChats(@NotNull Instant abandonedBefore) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)abandonedBefore, (String)"abandonedBefore");
        Iterable $this$mapToSet$iv = this.chatDeletionRepository.findByCreatedAtBefore(abandonedBefore);
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator it;
            DbChatDeletion dbChatDeletion = (DbChatDeletion)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getChatId());
        }
        Set deletedChats = (Set)destination$iv$iv;
        Set orphanedChats = CollectionsKt.toSet((Iterable)this.chatParticipantRepository.findOrphanedChatsWithSyncDateBefore(abandonedBefore));
        Iterable $this$mapToSet$iv2 = SetsKt.plus((Set)deletedChats, (Iterable)orphanedChats);
        boolean $i$f$mapToSet2 = false;
        Iterable $i$f$mapTo22 = $this$mapToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UUID uUID = (UUID)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(new ChatId((UUID)it));
        }
        Set chatIdsToCleanup = (Set)destination$iv$iv2;
        this.chatDeletionRepository.deleteAllById((Iterable)SetsKt.plus((Set)deletedChats, (Iterable)orphanedChats));
        Iterable $this$forEach$iv = chatIdsToCleanup;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId it = (ChatId)element$iv;
            boolean bl = false;
            this.chatParticipantRepository.deleteParticipantFromDeleted(it.getValue());
        }
        this.chatRepository.deleteAllById((Iterable)SetsKt.plus((Set)deletedChats, (Iterable)orphanedChats));
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static final /* synthetic */ UpdateCommonSearchIndexProducer access$getUpdateCommonSearchIndexProducer$p(ChatCleanupService $this) {
        return $this.updateCommonSearchIndexProducer;
    }

    public static final /* synthetic */ PermissionService access$getPermissionService$p(ChatCleanupService $this) {
        return $this.permissionService;
    }

    public static final /* synthetic */ DriveItemIdProducer access$getDriveItemIdProducer$p(ChatCleanupService $this) {
        return $this.driveItemIdProducer;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

