/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChangesService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.Changes;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserGroup;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.LimitOffset;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 @2\u00020\u0001:\u0001@B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0012J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0012J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0012J$\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\u0006\u0010\u0014\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012J\"\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0014\u001a\u00020\u0013H\u0012J8\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0012J \u0010.\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\u0006\u0010 \u001a\u00020\u00132\b\u0010'\u001a\u0004\u0018\u00010(H\u0012J<\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0014\u001a\u00020\u00132\f\u00100\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012JD\u00102\u001a\b\u0012\u0004\u0012\u00020-0\u00162\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0014\u001a\u00020\u00132\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012J:\u00105\u001a\b\u0012\u0004\u0012\u00020-0\u00162\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00132\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012J&\u00106\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\b\u0010'\u001a\u0004\u0018\u00010(2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012Jf\u00107\u001a\b\u0012\u0004\u0012\u0002080\u00162\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u0014\u001a\u00020\u00132\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00122\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0012Jd\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00132\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00122\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u00122\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0012JJ\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u00162\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00122\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012J@\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010'\u001a\u00020(2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00122\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u00020\"0\u0012H\u0012J\u000e\u0010>\u001a\u0004\u0018\u00010\u0013*\u00020\u0017H\u0012J\u000e\u0010?\u001a\u0004\u0018\u00010\u001b*\u00020\u0017H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lde/justsoftware/chat/business/ChangesService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/ChatSettingsService;Lde/justsoftware/chat/business/ChatReadDateService;)V", "collectProfileIds", "", "Lde/justsoftware/chat/model/ProfileId;", "currentProfileId", "chatParticipants", "", "Lde/justsoftware/chat/business/model/ChatParticipant;", "updatedMessages", "Lde/justsoftware/chat/business/model/ChatMessage;", "collectUserGroupIdsAndAllUsersGroup", "Lde/justsoftware/chat/model/UserGroupId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "defaultChatSettings", "Lde/justsoftware/chat/business/model/ChatSettings;", "profileId", "chatId", "Lde/justsoftware/chat/model/ChatId;", "getAllChatSettings", "chatIds", "getChanges", "Lde/justsoftware/chat/business/model/Changes;", "since", "Ljava/time/Instant;", "getDeletedChatIds", "getNonDirectParticipantAuthorIds", "participants", "updatedChats", "Lde/justsoftware/chat/business/model/Chat;", "getRecentlyJoinedChats", "getUpdatedChatSettings", "updatedChatIds", "recentlyJoinedChats", "getUpdatedChats", "currentUserParticipantIds", "Lde/justsoftware/chat/model/ParticipantId;", "getUpdatedChatsSince", "getUpdatedMessages", "getUpdatedProfiles", "Lde/justsoftware/chat/business/model/Profile;", "updatedChatsParticipants", "getUpdatedProfilesSince", "getUpdatedUserGroups", "Lde/justsoftware/chat/business/model/UserGroup;", "getUpdatedUserGroupsSince", "toProfileId", "toUserGroupId", "Companion", "chat-service"})
public class ChangesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    private static final int MAX_CHATS_IN_CHANGES = 500;
    private static final int MAX_MESSAGES_IN_CHANGES = 2000;

    public ChangesService(@NotNull ChatService chatService, @NotNull ChatMessageService chatMessageService, @NotNull ChatParticipantService chatParticipantService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull ChatSettingsService chatSettingsService, @NotNull ChatReadDateService chatReadDateService) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        this.chatService = chatService;
        this.chatMessageService = chatMessageService;
        this.chatParticipantService = chatParticipantService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.chatSettingsService = chatSettingsService;
        this.chatReadDateService = chatReadDateService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Changes getChanges(@Nullable Instant since, @NotNull ProfileId currentProfileId, @NotNull TenantId tenantId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)currentProfileId, (String)"currentProfileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Set currentUserParticipantIds = SetsKt.plus((Set)this.userGroupService.getUserGroupIdsByProfileId(currentProfileId), (Object)currentProfileId);
        Set recentlyJoinedChats = this.getRecentlyJoinedChats(currentProfileId, since);
        List updatedChats = this.getUpdatedChats(since, currentProfileId, currentUserParticipantIds, tenantId, recentlyJoinedChats);
        Iterable $this$mapToSet$iv = updatedChats;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Chat chat = (Chat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set updatedChatIds = (Set)destination$iv$iv;
        List updatedMessages = this.getUpdatedMessages(since, updatedChatIds);
        List updatedChatsParticipants = CollectionUtilsKt.flattenValues((Map)this.chatParticipantService.findByChatIds((Iterable)updatedChatIds));
        List updatedProfiles = this.getUpdatedProfiles(since, currentProfileId, currentUserParticipantIds, updatedChatsParticipants, recentlyJoinedChats, updatedChats, updatedMessages);
        List updatedUserGroups = this.getUpdatedUserGroups(since, tenantId, currentUserParticipantIds, updatedChatsParticipants, recentlyJoinedChats);
        List updatedChatSettings = this.getUpdatedChatSettings(since, currentProfileId, updatedChatIds, recentlyJoinedChats);
        Set deletedChatIds = this.getDeletedChatIds(since, currentProfileId);
        return new Changes(updatedChats, updatedMessages, updatedProfiles, updatedUserGroups, updatedChatSettings, deletedChatIds);
    }

    private Set<ChatId> getRecentlyJoinedChats(ProfileId profileId, Instant since) {
        return since != null ? this.chatParticipantService.findRecentlyJoinedChatIds(profileId, since) : SetsKt.emptySet();
    }

    private List<Chat> getUpdatedChats(Instant since, ProfileId currentProfileId, Set<? extends ParticipantId> currentUserParticipantIds, TenantId tenantId, Set<ChatId> recentlyJoinedChats) {
        List list;
        if (since != null) {
            list = this.getUpdatedChatsSince(since, currentProfileId, currentUserParticipantIds, recentlyJoinedChats);
        } else {
            List list2 = this.chatService.getRecentChats(currentProfileId, tenantId, (Offset)new LimitOffset(0L, 500, 1, null)).getContent();
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"{\n            chatServic\u2026       .content\n        }");
        }
        return list;
    }

    private List<Chat> getUpdatedChatsSince(Instant since, ProfileId currentProfileId, Set<? extends ParticipantId> currentUserParticipantIds, Set<ChatId> recentlyJoinedChats) {
        Set chatsWithUpdatedSyncDate = this.chatService.findIdsByUpdatedSyncDate((Iterable)currentUserParticipantIds, since);
        Set chatsRecentlyRead = this.chatReadDateService.findChatIdsReadSince(currentUserParticipantIds, since);
        Set oneOnOneChatsWithUpdatedPartnerProfile = this.chatService.findOneOnOneIdsWithUpdatedPartnerProfile(currentProfileId, since);
        Set[] setArray = new Set[]{recentlyJoinedChats, chatsWithUpdatedSyncDate, chatsRecentlyRead, oneOnOneChatsWithUpdatedPartnerProfile};
        Set allUpdatedChatIds = CollectionUtilsKt.union((Set[])setArray);
        return CollectionsKt.toList((Iterable)this.chatService.findByIds(allUpdatedChatIds).values());
    }

    private List<ChatMessage> getUpdatedMessages(Instant since, Set<ChatId> chatIds) {
        List list = this.chatMessageService.getRecentMessages((Collection)chatIds, since, 2000).getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"chatMessageService\n     \u2026   )\n            .content");
        return list;
    }

    private List<Profile> getUpdatedProfiles(Instant since, ProfileId currentProfileId, Set<? extends ParticipantId> currentUserParticipantIds, List<ChatParticipant> updatedChatsParticipants, Set<ChatId> recentlyJoinedChats, List<? extends Chat> updatedChats, List<? extends ChatMessage> updatedMessages) {
        Set profileIds = since != null ? this.getUpdatedProfilesSince(since, currentProfileId, currentUserParticipantIds, updatedChatsParticipants, recentlyJoinedChats, updatedChats, updatedMessages) : this.collectProfileIds(currentProfileId, updatedChatsParticipants, updatedMessages);
        return CollectionsKt.toList((Iterable)this.profileService.findByIds(profileIds).values());
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> getUpdatedProfilesSince(Instant since, ProfileId currentProfileId, Set<? extends ParticipantId> currentUserParticipantIds, List<ChatParticipant> updatedChatsParticipants, Set<ChatId> recentlyJoinedChats, List<? extends Chat> updatedChats, List<? extends ChatMessage> updatedMessages) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = updatedChatsParticipants;
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant participant = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!recentlyJoinedChats.contains(participant.getChatId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNullToSet = false;
        $this$filterTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl2 = false;
            ParticipantId participantId = it.getParticipantId();
            if ((participantId instanceof ProfileId ? (ProfileId)participantId : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set directParticipantsOfRecentlyJoinedChats = (Set)destination$iv$iv;
        Set nonDirectParticipantAuthorIds = this.getNonDirectParticipantAuthorIds(updatedChatsParticipants, updatedChats, updatedMessages);
        Set updatedDirectParticipants = this.chatParticipantService.findUpdatedDirectParticipants((Iterable)currentUserParticipantIds, since);
        Set updatedAuthors = this.chatMessageService.findUpdatedAuthors((Iterable)currentUserParticipantIds, since);
        Profile currentProfile = this.profileService.getById(currentProfileId);
        Set currentProfileIfUpdated = currentProfile.getUpdatedAt().compareTo(since) > 0 ? SetsKt.setOf((Object)currentProfileId) : SetsKt.emptySet();
        Set[] setArray = new Set[]{directParticipantsOfRecentlyJoinedChats, nonDirectParticipantAuthorIds, updatedDirectParticipants, updatedAuthors, currentProfileIfUpdated};
        return CollectionUtilsKt.union((Set[])setArray);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> getNonDirectParticipantAuthorIds(List<ChatParticipant> participants, List<? extends Chat> updatedChats, List<? extends ChatMessage> updatedMessages) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$mapToSet$iv = updatedChats;
        boolean $i$f$mapToSet22 = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Chat chat = (Chat)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Set updatedChatIds = (Set)destination$iv$iv;
        Iterable $i$f$mapToSet22 = participants;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable<ProfileId> destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant participant = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!updatedChatIds.contains(participant.getChatId())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$mapNotNullToSet = false;
        $this$filterTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator participant = $this$forEach$iv$iv$iv.iterator();
        while (participant.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = participant.next();
            boolean bl = false;
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl2 = false;
            ParticipantId participantId = it.getParticipantId();
            if ((participantId instanceof ProfileId ? (ProfileId)participantId : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set directParticipantsOfUpdatedChats = (Set)destination$iv$iv2;
        Iterable $this$mapToSet$iv2 = updatedMessages;
        boolean $i$f$mapToSet = false;
        destination$iv$iv2 = $this$mapToSet$iv2;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatMessage element$iv$iv$iv = (ChatMessage)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            collection.add(p0.getAuthor());
        }
        Set messageAuthorIds = (Set)destination$iv$iv3;
        return SetsKt.minus((Set)messageAuthorIds, (Iterable)directParticipantsOfUpdatedChats);
    }

    /*
     * WARNING - void declaration
     */
    private Set<ProfileId> collectProfileIds(ProfileId currentProfileId, List<ChatParticipant> chatParticipants, List<? extends ChatMessage> updatedMessages) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = chatParticipants;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<ProfileId> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl2 = false;
            if (this.toProfileId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List participantProfileIds = (List)destination$iv$iv;
        Iterable $this$map$iv = updatedMessages;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            element$iv$iv$iv = (ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getAuthor());
        }
        List authorProfileIds = (List)destination$iv$iv2;
        return SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.setOf((Object)currentProfileId), (Iterable)participantProfileIds), (Iterable)authorProfileIds);
    }

    private List<UserGroup> getUpdatedUserGroups(Instant since, TenantId tenantId, Set<? extends ParticipantId> currentUserParticipantIds, List<ChatParticipant> updatedChatsParticipants, Set<ChatId> recentlyJoinedChats) {
        Set userGroupIds = since != null ? this.getUpdatedUserGroupsSince(since, currentUserParticipantIds, updatedChatsParticipants, recentlyJoinedChats) : this.collectUserGroupIdsAndAllUsersGroup(tenantId, updatedChatsParticipants);
        return CollectionsKt.toList((Iterable)this.userGroupService.findByIds(userGroupIds).values());
    }

    /*
     * WARNING - void declaration
     */
    private Set<UserGroupId> getUpdatedUserGroupsSince(Instant since, Set<? extends ParticipantId> currentUserParticipantIds, List<ChatParticipant> updatedChatsParticipants, Set<ChatId> recentlyJoinedChats) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = updatedChatsParticipants;
        boolean $i$f$filter = false;
        void var8_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ChatParticipant participant = (ChatParticipant)element$iv$iv;
            boolean bl = false;
            if (!recentlyJoinedChats.contains(participant.getChatId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNullToSet = false;
        $this$filterTo$iv$iv = $this$mapNotNullToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl2 = false;
            ParticipantId participantId = it.getParticipantId();
            if ((participantId instanceof UserGroupId ? (UserGroupId)participantId : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set userGroupParticipantsOfRecentlyJoinedChats = (Set)destination$iv$iv;
        Set updatedUserGroups = this.chatParticipantService.findUpdatedGroupParticipants((Iterable)currentUserParticipantIds, since);
        return SetsKt.plus((Set)userGroupParticipantsOfRecentlyJoinedChats, (Iterable)updatedUserGroups);
    }

    /*
     * WARNING - void declaration
     */
    private Set<UserGroupId> collectUserGroupIdsAndAllUsersGroup(TenantId tenantId, List<ChatParticipant> chatParticipants) {
        void $this$mapNotNullTo$iv$iv;
        UserGroup userGroup = this.userGroupService.findAllUsersGroup(tenantId);
        UserGroupId allUsersGroupId = userGroup != null ? userGroup.getId() : null;
        Iterable $this$mapNotNull$iv = chatParticipants;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            UserGroupId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatParticipant it = (ChatParticipant)element$iv$iv;
            boolean bl2 = false;
            if (this.toUserGroupId(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List participantUserGroupIds = (List)destination$iv$iv;
        return SetsKt.plus((Set)SetsKt.setOfNotNull((Object)allUsersGroupId), (Iterable)participantUserGroupIds);
    }

    private List<ChatSettings> getUpdatedChatSettings(Instant since, ProfileId currentProfileId, Set<ChatId> updatedChatIds, Set<ChatId> recentlyJoinedChats) {
        return since != null ? this.chatSettingsService.findUpdatedAndSpecificSettings(currentProfileId, (Iterable)recentlyJoinedChats, since) : this.getAllChatSettings(currentProfileId, updatedChatIds);
    }

    /*
     * WARNING - void declaration
     */
    private List<ChatSettings> getAllChatSettings(ProfileId currentProfileId, Set<ChatId> chatIds) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map chatSettingsMap = this.chatSettingsService.getSettings(currentProfileId, chatIds);
        Set missingChatIds = CollectionsKt.subtract((Iterable)chatIds, (Iterable)chatSettingsMap.keySet());
        Iterable iterable = missingChatIds;
        boolean $i$f$map = false;
        void var8_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void missingChatId;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.defaultChatSettings(currentProfileId, (ChatId)missingChatId));
        }
        List defaultChatSettingsForMissingChatIds = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)chatSettingsMap.values()), (Iterable)defaultChatSettingsForMissingChatIds);
    }

    private ChatSettings defaultChatSettings(ProfileId profileId, ChatId chatId) {
        return new ChatSettings(chatId, profileId, false, null, 12, null);
    }

    private Set<ChatId> getDeletedChatIds(Instant since, ProfileId currentProfileId) {
        return since != null ? this.chatService.findChatsEffectivelyRemovedFromSince(currentProfileId, since) : SetsKt.emptySet();
    }

    private ProfileId toProfileId(ChatParticipant $this$toProfileId) {
        ParticipantId participantId = $this$toProfileId.getId().getParticipantId();
        return participantId instanceof ProfileId ? (ProfileId)participantId : null;
    }

    private UserGroupId toUserGroupId(ChatParticipant $this$toUserGroupId) {
        ParticipantId participantId = $this$toUserGroupId.getId().getParticipantId();
        return participantId instanceof UserGroupId ? (UserGroupId)participantId : null;
    }
}

