/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.authorization;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PermissionAction;
import de.justsoftware.chat.model.PermissionRole;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0012J<\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u000e0\u0006\"\b\b\u0000\u0010\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0012J*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\fH\u0012J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u000e0\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\n2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u001e\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/chat/authorization/AuthorizationService;", "", "permissionRequestConnector", "Lde/justsoftware/permission/client/rest/PermissionRequestConnector;", "(Lde/justsoftware/permission/client/rest/PermissionRequestConnector;)V", "hasRoles", "", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "rolesToCheck", "", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "may", "", "roleToCheck", "T", "Lde/justsoftware/chat/model/PermissionRole;", "itemsToCheck", "permissionAction", "Lde/justsoftware/chat/model/PermissionAction;", "userId", "mayProfileReadTenant", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "mayReadParticipants", "Lde/justsoftware/chat/model/ParticipantId;", "participantIds", "reader", "searchRolesBy", "searchBy", "chat-service"})
public class AuthorizationService {
    @NotNull
    private final PermissionRequestConnector permissionRequestConnector;

    public AuthorizationService(@NotNull PermissionRequestConnector permissionRequestConnector) {
        Intrinsics.checkNotNullParameter((Object)permissionRequestConnector, (String)"permissionRequestConnector");
        this.permissionRequestConnector = permissionRequestConnector;
    }

    public boolean mayProfileReadTenant(@NotNull TenantId tenantId, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Role role = Role.tenantRead((UUID)tenantId.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)role, (String)"tenantRead(tenantId.value)");
        return this.may(role, profileId);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<Role, AuthorizationResult> hasRoles(@NotNull Set<Role> rolesToCheck, @NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter(rolesToCheck, (String)"rolesToCheck");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        if (rolesToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        ImmutableMap immutableMap = this.permissionRequestConnector.hasRoles((Iterable)rolesToCheck, (Iterable)SetsKt.setOf((Object)profileId.toRole()));
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"permissionRequestConnect\u2026etOf(profileId.toRole()))");
        ImmutableMap authResults = immutableMap;
        Iterable $this$associateWith$iv = rolesToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Role role = (Role)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            AuthorizationResult authorizationResult = (AuthorizationResult)authResults.get((Object)it);
            if (authorizationResult == null) {
                authorizationResult = AuthorizationResult.NOT_FOUND;
            }
            AuthorizationResult authorizationResult2 = authorizationResult;
            map.put(t, authorizationResult2);
        }
        return result$iv;
    }

    @NotNull
    public Map<ParticipantId, Boolean> mayReadParticipants(@NotNull Set<? extends ParticipantId> participantIds, @NotNull ProfileId reader) {
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return this.may(participantIds, PermissionAction.READ, reader);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends PermissionRole> Map<T, Boolean> may(Set<? extends T> itemsToCheck, PermissionAction permissionAction, ProfileId userId) {
        Object object;
        void $this$mapTo$iv$iv;
        if (itemsToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $this$mapToSet$iv = itemsToCheck;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionRole permissionRole = (PermissionRole)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.toActionRole(permissionAction));
        }
        Set rolesToCheck = (Set)destination$iv$iv;
        Map authResults = this.hasRoles(rolesToCheck, userId);
        Iterable $this$associateWith$iv = itemsToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            PermissionRole bl = (PermissionRole)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            Boolean bl3 = authResults.get(it.toActionRole(permissionAction)) == AuthorizationResult.OK;
            object.put(t, bl3);
        }
        return result$iv;
    }

    @NotNull
    public Set<Role> searchRolesBy(@NotNull ProfileId searchBy) {
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        ImmutableSet immutableSet = this.permissionRequestConnector.searchRoles(searchBy.toRole());
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"permissionRequestConnect\u2026hRoles(searchBy.toRole())");
        return (Set)immutableSet;
    }

    private boolean may(Role roleToCheck, ProfileId profileId) {
        Object v = this.may(SetsKt.setOf((Object)roleToCheck), profileId).get(roleToCheck);
        if (v == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        return (Boolean)v;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Role, Boolean> may(Set<Role> rolesToCheck, ProfileId profileId) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.hasRoles(rolesToCheck, profileId);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Boolean bl3 = it.getValue() == AuthorizationResult.OK;
            map3.put(k, bl3);
        }
        return destination$iv$iv;
    }
}

