/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.authorization;

import de.justsoftware.chat.application.model.AllowedActions;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.PermissionAction;
import de.justsoftware.chat.model.PermissionRole;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ;2\u00020\u0001:\u0001;B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\u001e\u001a\u00020\u0012J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0014J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0014\u0010%\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0014J\u000e\u0010&\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003J\u0014\u0010'\u001a\u00020\u00122\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J\u0006\u0010)\u001a\u00020\u0012J\u000e\u0010*\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!J\u0014\u0010+\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0014J4\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020/0-\"\b\b\u0000\u0010.*\u00020\u00152\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H.0\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u00100\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020/0-2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0014J \u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020/0-2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014J \u00102\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020/0-2\f\u00104\u001a\b\u0012\u0004\u0012\u0002030\u0014J \u00105\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020/0-2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0014J@\u00106\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002070-2\f\u00108\u001a\b\u0012\u0004\u0012\u00020!0\u00142\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020!0\u00142\u000e\b\u0002\u0010:\u001a\b\u0012\u0004\u0012\u00020!0\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006<"}, d2={"Lde/justsoftware/chat/authorization/AuthorizationContext;", "", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "locale", "Ljava/util/Locale;", "authService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "(Lde/justsoftware/chat/model/ProfileId;Lde/justsoftware/chat/model/TenantId;Ljava/util/Locale;Lde/justsoftware/chat/authorization/AuthorizationService;)V", "getLocale", "()Ljava/util/Locale;", "getProfileId", "()Lde/justsoftware/chat/model/ProfileId;", "getTenantId", "()Lde/justsoftware/chat/model/TenantId;", "check", "", "itemsToCheck", "", "Lde/justsoftware/chat/model/PermissionRole;", "permissionAction", "Lde/justsoftware/chat/model/PermissionAction;", "rolesToCheck", "Lde/justsoftware/permission/client/model/Role;", "checkAuthorizationResult", "checkedRole", "authResult", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "checkCreateChat", "checkManageChat", "chatId", "Lde/justsoftware/chat/model/ChatId;", "checkManageChats", "chatIds", "checkReadChat", "checkReadChats", "checkReadProfile", "checkReadProfiles", "profileIds", "checkRestoreChats", "checkWriteChat", "checkWriteChats", "may", "", "T", "", "mayManageChats", "mayReadProfiles", "mayReadUserGroups", "Lde/justsoftware/chat/model/UserGroupId;", "userGroupIds", "mayWriteChats", "toMultiUserChatsAllowedActions", "Lde/justsoftware/chat/application/model/AllowedActions;", "multiUserChatIds", "chatsWithoutWriter", "chatsWithoutManager", "Companion", "chat-service"})
public final class AuthorizationContext {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ProfileId profileId;
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final Locale locale;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private static final Logger LOG;

    public AuthorizationContext(@NotNull ProfileId profileId, @NotNull TenantId tenantId, @NotNull Locale locale, @NotNull AuthorizationService authService) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        this.profileId = profileId;
        this.tenantId = tenantId;
        this.locale = locale;
        this.authService = authService;
    }

    @NotNull
    public final ProfileId getProfileId() {
        return this.profileId;
    }

    @NotNull
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    @NotNull
    public final Locale getLocale() {
        return this.locale;
    }

    public final void checkCreateChat() {
        this.check(SetsKt.setOf((Object)Role.writeApp((CoreApp)CoreApp.CHAT, (UUID)this.tenantId.getValue())));
    }

    public final void checkReadChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.checkReadChats(SetsKt.setOf((Object)chatId));
    }

    public final void checkWriteChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.checkWriteChats(SetsKt.setOf((Object)chatId));
    }

    public final void checkManageChat(@NotNull ChatId chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        this.checkManageChats(SetsKt.setOf((Object)chatId));
    }

    public final void checkRestoreChats() {
        this.check(SetsKt.setOf((Object)this.tenantId), PermissionAction.MANAGE);
    }

    public final void checkReadChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        this.check(chatIds, PermissionAction.READ);
    }

    public final void checkWriteChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        this.check(chatIds, PermissionAction.WRITE);
    }

    public final void checkManageChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        this.check(chatIds, PermissionAction.MANAGE);
    }

    public final void checkReadProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.checkReadProfiles(SetsKt.setOf((Object)profileId));
    }

    public final void checkReadProfiles(@NotNull Set<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        this.check(profileIds, PermissionAction.READ);
    }

    @NotNull
    public final Map<ProfileId, Boolean> mayReadProfiles(@NotNull Set<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.may(profileIds, PermissionAction.READ);
    }

    @NotNull
    public final Map<UserGroupId, Boolean> mayReadUserGroups(@NotNull Set<UserGroupId> userGroupIds) {
        Intrinsics.checkNotNullParameter(userGroupIds, (String)"userGroupIds");
        return this.may(userGroupIds, PermissionAction.READ);
    }

    @NotNull
    public final Map<ChatId, Boolean> mayManageChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        return this.may(chatIds, PermissionAction.MANAGE);
    }

    @NotNull
    public final Map<ChatId, Boolean> mayWriteChats(@NotNull Set<ChatId> chatIds) {
        Intrinsics.checkNotNullParameter(chatIds, (String)"chatIds");
        return this.may(chatIds, PermissionAction.WRITE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ChatId, AllowedActions> toMultiUserChatsAllowedActions(@NotNull Set<ChatId> multiUserChatIds, @NotNull Set<ChatId> chatsWithoutWriter, @NotNull Set<ChatId> chatsWithoutManager) {
        Intrinsics.checkNotNullParameter(multiUserChatIds, (String)"multiUserChatIds");
        Intrinsics.checkNotNullParameter(chatsWithoutWriter, (String)"chatsWithoutWriter");
        Intrinsics.checkNotNullParameter(chatsWithoutManager, (String)"chatsWithoutManager");
        Map mayManage = this.mayManageChats(multiUserChatIds);
        Map mayWrite = this.mayWriteChats(multiUserChatIds);
        Iterable $this$associateWith$iv = multiUserChatIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            ChatId chatId = (ChatId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            boolean manage = mayManage.getOrDefault(it, false);
            boolean write = mayWrite.getOrDefault(it, false);
            boolean chatHasNoManager = chatsWithoutManager.contains(it) ? (chatsWithoutWriter.contains(it) ? true : write) : false;
            AllowedActions allowedActions = new AllowedActions(manage, chatHasNoManager, manage, manage, write);
            map.put(t, allowedActions);
        }
        return result$iv;
    }

    public static /* synthetic */ Map toMultiUserChatsAllowedActions$default(AuthorizationContext authorizationContext, Set set, Set set2, Set set3, int n, Object object) {
        if ((n & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            set3 = SetsKt.emptySet();
        }
        return authorizationContext.toMultiUserChatsAllowedActions(set, set2, set3);
    }

    /*
     * WARNING - void declaration
     */
    private final void check(Set<? extends PermissionRole> itemsToCheck, PermissionAction permissionAction) {
        void $this$mapTo$iv$iv;
        if (itemsToCheck.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = itemsToCheck;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionRole permissionRole = (PermissionRole)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toActionRole(permissionAction));
        }
        Set rolesToCheck = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.check(rolesToCheck);
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends PermissionRole> Map<T, Boolean> may(Set<? extends T> itemsToCheck, PermissionAction permissionAction) {
        Object object;
        void $this$mapTo$iv$iv;
        if (itemsToCheck.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Iterable $this$map$iv = itemsToCheck;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PermissionRole permissionRole = (PermissionRole)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.toActionRole(permissionAction));
        }
        Set rolesToCheck = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Map authResults = this.authService.hasRoles(rolesToCheck, this.profileId);
        Iterable $this$associateWith$iv = itemsToCheck;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            PermissionRole bl = (PermissionRole)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            Boolean bl3 = authResults.get(it.toActionRole(permissionAction)) == AuthorizationResult.OK;
            object.put(t, bl3);
        }
        return result$iv;
    }

    private final void check(Set<Role> rolesToCheck) {
        Map $this$forEach$iv = this.authService.hasRoles(rolesToCheck, this.profileId);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Role role = (Role)entry.getKey();
            AuthorizationResult authResult = (AuthorizationResult)entry.getValue();
            this.checkAuthorizationResult(role, authResult);
        }
    }

    private final void checkAuthorizationResult(Role checkedRole, AuthorizationResult authResult) {
        switch (WhenMappings.$EnumSwitchMapping$0[authResult.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(checkedRole + " does not exist");
                }
                throw new NotFoundException("Failed permission check on " + checkedRole);
            }
            case 3: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.profileId + " is not allowed to " + checkedRole);
                }
                throw new NotAllowedException("Failed permission check on " + checkedRole);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

