/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.SearchApplicationService;
import de.justsoftware.chat.application.model.AllowedActions;
import de.justsoftware.chat.application.model.ChatSearchResultDto;
import de.justsoftware.chat.application.model.ChatSettingsDto;
import de.justsoftware.chat.application.model.CommonCoreSearchResultDto;
import de.justsoftware.chat.application.model.MultiUserChatDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.ProfileSearchResultDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.SearchService;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.CommonCoreSearchModelType;
import de.justsoftware.chat.model.CommonCoreSearchResult;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.PageOffset;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.SearchSortType;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJF\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J0\u0010\u0015\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b0\u0016*\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/chat/application/SearchApplicationService;", "", "searchService", "Lde/justsoftware/chat/business/SearchService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "(Lde/justsoftware/chat/business/SearchService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/ChatParticipantService;)V", "suggestChat", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/application/model/CommonCoreSearchResultDto;", "query", "", "sortType", "Lde/justsoftware/chat/model/SearchSortType;", "page", "", "pageSize", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "toCommonCoreSearchResultDtos", "", "", "Lde/justsoftware/chat/model/CommonCoreSearchResult;", "chat-service"})
public class SearchApplicationService {
    @NotNull
    private final SearchService searchService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatParticipantService chatParticipantService;

    public SearchApplicationService(@NotNull SearchService searchService, @NotNull ProfileService profileService, @NotNull ChatParticipantService chatParticipantService) {
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        this.searchService = searchService;
        this.profileService = profileService;
        this.chatParticipantService = chatParticipantService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<CommonCoreSearchResultDto<? extends Object, ? extends Object>> suggestChat(@NotNull String query, @NotNull SearchSortType sortType, int page, int pageSize, @NotNull AuthorizationContext authContext) {
        void $this$mapContent$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page page2 = new Page[]{CommonCoreSearchModelType.CHAT, CommonCoreSearchModelType.PERSON};
        page2 = this.searchService.suggestChat(query, (CommonCoreSearchModelType[])page2, sortType, authContext.getProfileId(), (Offset)new PageOffset(page, pageSize));
        boolean $i$f$mapContent = false;
        Iterable it = (Iterable)$this$mapContent$iv;
        boolean bl = false;
        long l = $this$mapContent$iv.getTotalElements();
        Pageable pageable = $this$mapContent$iv.getPageable();
        List list = this.toCommonCoreSearchResultDtos(it, authContext);
        return (Page)new PageImpl(list, pageable, l);
    }

    /*
     * WARNING - void declaration
     */
    private List<CommonCoreSearchResultDto<? extends Object, ? extends Object>> toCommonCoreSearchResultDtos(Iterable<CommonCoreSearchResult> $this$toCommonCoreSearchResultDtos, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        Iterable<CommonCoreSearchResult> $this$mapNotNullToSet$iv = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNullToSet = false;
        Iterable<CommonCoreSearchResult> iterable = $this$mapNotNullToSet$iv;
        Iterable<Object> destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            CommonCoreSearchResult p0 = (CommonCoreSearchResult)element$iv$iv;
            boolean bl2 = false;
            if (p0.getProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv;
        Iterable<CommonCoreSearchResult> $this$mapNotNullToSet$iv2 = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNullToSet22 = false;
        destination$iv$iv = $this$mapNotNullToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv2));
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            ChatId it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            CommonCoreSearchResult p0 = (CommonCoreSearchResult)element$iv$iv;
            boolean bl4 = false;
            if (p0.getChatId() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set chatIds = (Set)destination$iv$iv2;
        Map $i$f$mapNotNullToSet22 = this.profileService.findByIds(profileIds);
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv4 : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv4;
            Map p0 = destination$iv$iv3;
            boolean bl6 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv4;
            Object k = it$iv$iv.getKey();
            object = p0;
            boolean bl7 = false;
            Profile profile = (Profile)entry.getValue();
            ProfileDto profileDto = ProfileDto.Companion.toProfileDto(profile);
            object.put(k, profileDto);
        }
        Map profileDtos = destination$iv$iv3;
        Map allowedActions = AuthorizationContext.toMultiUserChatsAllowedActions$default((AuthorizationContext)authContext, (Set)chatIds, null, null, (int)6, null);
        Map oneOnOneChatIdByChatPartnerIds = this.chatParticipantService.getOneOnOneChatIdByChatPartnerIds(profileIds, authContext.getProfileId());
        Iterable<CommonCoreSearchResult> $this$map$iv = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$map = false;
        Iterable<CommonCoreSearchResult> $i$f$mapValuesTo22 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CommonCoreSearchResultDto commonCoreSearchResultDto;
            void searchResult;
            CommonCoreSearchResult it$iv$iv = (CommonCoreSearchResult)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[searchResult.getModelType().ordinal()]) {
                case 1: {
                    ProfileId profileId = ProfileId.Companion.fromCanonicalId(searchResult.getId());
                    ProfileSearchResultDto.Companion companion = ProfileSearchResultDto.Companion;
                    void v1 = searchResult;
                    Object v = profileDtos.get(profileId);
                    if (v == null) {
                        void var18_47 = v1;
                        ProfileSearchResultDto.Companion companion2 = companion;
                        boolean bl8 = false;
                        String string2 = "Could not load Profile with id " + profileId;
                        ProfileSearchResultDto.Companion companion3 = companion2;
                        void v4 = var18_47;
                        String string3 = string2;
                        throw new IllegalStateException(string3.toString());
                    }
                    commonCoreSearchResultDto = (CommonCoreSearchResultDto)companion.toProfileSearchResultDto((CommonCoreSearchResult)v1, (ProfileDto)v, (ChatId)oneOnOneChatIdByChatPartnerIds.get(profileId));
                    break;
                }
                case 2: {
                    Object object2;
                    ChatId chatId = ChatId.Companion.fromCanonicalId(searchResult.getId());
                    String string4 = searchResult.getChatType();
                    if (string4 == null) {
                        boolean $i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$22 = false;
                        String $i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$22 = "ChatType is null for a chat searchResult";
                        throw new IllegalStateException($i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$22.toString());
                    }
                    ChatType chatType = ChatType.valueOf((String)string4);
                    if (!(chatType == ChatType.MULTI_USER_CHAT)) {
                        boolean bl9 = false;
                        String string5 = "OneOnOne Chats should be filtered by search queries, since oneOnOne chats should be handled as a person (chat partner)";
                        throw new IllegalStateException(string5.toString());
                    }
                    String string6 = searchResult.getName();
                    Object v = allowedActions.get(chatId);
                    if (v == null) {
                        object2 = "Required value was null.";
                        throw new IllegalStateException(object2.toString());
                    }
                    AllowedActions allowedActions2 = (AllowedActions)v;
                    Instant instant = searchResult.getModifyDate().toInstant();
                    object2 = searchResult.getModifyDate().toInstant();
                    ChatSettingsDto chatSettingsDto = ChatSettingsDto.Companion.toChatSettingsDto(new ChatSettings(chatId, authContext.getProfileId(), false, null, 12, null));
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant()");
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toInstant()");
                    commonCoreSearchResultDto = (CommonCoreSearchResultDto)ChatSearchResultDto.Companion.toChatSearchResultDto((CommonCoreSearchResult)searchResult, new MultiUserChatDto(chatId, string6, allowedActions2, null, 0L, instant, (Instant)object2, chatSettingsDto));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object.add(commonCoreSearchResultDto);
        }
        return (List)destination$iv$iv4;
    }
}

