/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher.producer;

import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.TenantProducer;
import de.justsoftware.admin.model.itemid.impl.DocumentId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minidev.json.JSONObject;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

@Component
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J*\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0012J<\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0012J5\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0010\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "log", "Lorg/slf4j/Logger;", "(Lorg/springframework/kafka/core/KafkaTemplate;Lorg/slf4j/Logger;)V", "generateTheme", "", "allAppSettings", "", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "getTenantInformation", "tenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "tenantInvitationCode", "publish", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "publish$admin_service", "publishDeletedTenant", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "Companion", "admin-service"})
public class TenantProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaTemplate<String, Object> kafkaTemplate;
    @NotNull
    private final Logger log;
    @NotNull
    private static final String TENANT_TOPIC = "just.tenants";

    public TenantProducer(@NotNull KafkaTemplate<String, Object> kafkaTemplate, @NotNull Logger log) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.kafkaTemplate = kafkaTemplate;
        this.log = log;
    }

    public /* synthetic */ TenantProducer(KafkaTemplate kafkaTemplate, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Logger logger2 = LoggerFactory.getLogger(TenantProducer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(TenantProducer::class.java)");
            logger = logger2;
        }
        this(kafkaTemplate, logger);
    }

    @NotNull
    public KafkaPublishOperation publishDeletedTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.log.debug("Sending key '" + tenantId + "' to kafka topic just.tenants with null message.");
        ListenableFuture listenableFuture = this.kafkaTemplate.send(TENANT_TOPIC, (Object)tenantId.asItemId(), null);
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"kafkaTemplate.send(TENAN\u2026enantId.asItemId(), null)");
        ListenableFuture listenable = listenableFuture;
        return new KafkaPublishOperation(listenable);
    }

    @NotNull
    public KafkaPublishOperation publish$admin_service(@NotNull Tenant tenant, @NotNull Set<AppSettings> allAppSettings, @NotNull TenantSettings tenantSettings, @Nullable String tenantInvitationCode) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(allAppSettings, (String)"allAppSettings");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        String tenantItemId = tenant.getId().asItemId();
        this.log.debug("Sending tenant to Kafka topic just.tenants with the message : " + tenantItemId + ")");
        Map tenantInformation = this.getTenantInformation(allAppSettings, tenantSettings, tenant, tenantInvitationCode);
        ListenableFuture listenableFuture = this.kafkaTemplate.send(new ProducerRecord(TENANT_TOPIC, (Object)tenantItemId, (Object)new JSONObject(tenantInformation).toString()));
        Intrinsics.checkNotNullExpressionValue((Object)listenableFuture, (String)"kafkaTemplate.send(\n    \u2026)\n            )\n        )");
        ListenableFuture listenableFuture2 = listenableFuture;
        return new KafkaPublishOperation(listenableFuture2);
    }

    private Map<String, Object> getTenantInformation(Set<AppSettings> allAppSettings, TenantSettings tenantSettings, Tenant tenant, String tenantInvitationCode) {
        JSONObject tenantTheme = new JSONObject(this.generateTheme(allAppSettings, tenantSettings));
        Object[] objectArray = new Pair[]{tenantInvitationCode != null ? TuplesKt.to((Object)"invitationCode", (Object)tenantInvitationCode) : null, tenantSettings.getDeeplKey() != null ? TuplesKt.to((Object)"deeplKey", (Object)tenantSettings.getDeeplKey()) : null, TuplesKt.to((Object)"id", (Object)tenant.getId().asItemId()), TuplesKt.to((Object)"name", (Object)tenant.getName()), TuplesKt.to((Object)"theme", (Object)tenantTheme)};
        return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> generateTheme(Set<AppSettings> allAppSettings, TenantSettings tenantSettings) {
        String string;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable iterable = allAppSettings;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var7_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            AppSettings it = (AppSettings)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)("APP_COLOR_" + it.getApp().name()), (Object)it.getColor().toString());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map tenantTheme = MapsKt.toMutableMap((Map)destination$iv$iv);
        tenantTheme.put("GLOBAL_HIGHLIGHT_COLOR", tenantSettings.getGlobalHighlightColor().toString());
        DocumentId documentId = tenantSettings.getLogoId();
        if (documentId == null) {
            string = "";
        } else {
            UUID uUID = documentId.getId();
            if (uUID == null) {
                string = "";
            } else {
                string = uUID.toString();
                if (string == null) {
                    string = "";
                }
            }
        }
        tenantTheme.put("TENANT_LOGO_ID", string);
        return tenantTheme;
    }
}

