/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher;

import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.tenant.model.IdpConfiguration;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.OauthClientProducer;
import de.justsoftware.admin.kafka.publisher.producer.PermissionConfigProducer;
import de.justsoftware.admin.kafka.publisher.producer.PermissionProducer;
import de.justsoftware.admin.kafka.publisher.producer.TenantProducer;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.ItemId;
import de.justsoftware.admin.model.itemid.impl.ClientRegistrationId;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.generated.proto.ClientRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0012J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0012J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000fH\u0016J.\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0\u000f2\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0016J\u001e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0016J\u001e\u0010#\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0016J&\u0010%\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010(\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\rH\u0016J>\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u000f2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001aH\u0016J\u0010\u00104\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u0014H\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u000209H\u0016J$\u0010:\u001a\u00020\u001c2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00180\u000f2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00180\u000fH\u0016J0\u0010=\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u00100\u001a\u0004\u0018\u0001012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J,\u0010>\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020/0\u000f2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020/0\u000fH\u0016J\u0010\u0010A\u001a\u00020\u001c2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u001cH\u0013R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lde/justsoftware/admin/kafka/publisher/Publisher;", "", "permissionConfigProducer", "Lde/justsoftware/admin/kafka/publisher/producer/PermissionConfigProducer;", "permissionProducer", "Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;", "tenantProducer", "Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;", "oauthClientProducer", "Lde/justsoftware/admin/kafka/publisher/producer/OauthClientProducer;", "(Lde/justsoftware/admin/kafka/publisher/producer/PermissionConfigProducer;Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;Lde/justsoftware/admin/kafka/publisher/producer/OauthClientProducer;)V", "getAppsWithDefaultWriters", "", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "allAppSettings", "", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "idpConfigToClientRegistration", "Lde/justsoftware/generated/proto/ClientRegistration;", "conf", "Lde/justsoftware/admin/domain/tenant/model/IdpConfiguration;", "publishDeletedProfile", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "appPermissions", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "tenantManagerPermission", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "publishDeletedTenant", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "tenantPermissions", "publishDeletedUserGroup", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "publishDisabledManualPeopleExporters", "deletedPermissions", "publishDisabledManualPermissions", "app", "publishEnabledManualPeopleExporters", "publishEnabledManualPermissions", "publishNewTenant", "tenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "tenantManagers", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "tenantInvitation", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "publishNewTenantPermission", "tenantPermission", "publishNewUserGroup", "publishOAuthClientChange", "idpConfig", "publishOAuthClientDeletion", "id", "Lde/justsoftware/admin/model/itemid/impl/ClientRegistrationId;", "publishUpdatedAppPermissions", "addedAppPermissions", "removedAppPermissions", "publishUpdatedTenant", "publishUpdatedTenantManagers", "add", "remove", "republishOAuthClients", "doRepublish", "Ljava/lang/Runnable;", "runAfterStartup", "admin-service"})
public class Publisher {
    @NotNull
    private final PermissionConfigProducer permissionConfigProducer;
    @NotNull
    private final PermissionProducer permissionProducer;
    @NotNull
    private final TenantProducer tenantProducer;
    @NotNull
    private final OauthClientProducer oauthClientProducer;

    public Publisher(@NotNull PermissionConfigProducer permissionConfigProducer, @NotNull PermissionProducer permissionProducer, @NotNull TenantProducer tenantProducer, @NotNull OauthClientProducer oauthClientProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionConfigProducer, (String)"permissionConfigProducer");
        Intrinsics.checkNotNullParameter((Object)permissionProducer, (String)"permissionProducer");
        Intrinsics.checkNotNullParameter((Object)tenantProducer, (String)"tenantProducer");
        Intrinsics.checkNotNullParameter((Object)oauthClientProducer, (String)"oauthClientProducer");
        this.permissionConfigProducer = permissionConfigProducer;
        this.permissionProducer = permissionProducer;
        this.tenantProducer = tenantProducer;
        this.oauthClientProducer = oauthClientProducer;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    private void runAfterStartup() {
        this.permissionConfigProducer.sendAppConfig$admin_service();
        this.permissionConfigProducer.sendTenantConfig$admin_service();
    }

    @NotNull
    public KafkaPublishOperation publishNewTenant(@NotNull Tenant tenant, @NotNull TenantSettings tenantSettings, @NotNull List<AppSettings> allAppSettings, @NotNull List<? extends GranteeId> tenantManagers, @Nullable TenantInvitation tenantInvitation) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        Intrinsics.checkNotNullParameter(allAppSettings, (String)"allAppSettings");
        Intrinsics.checkNotNullParameter(tenantManagers, (String)"tenantManagers");
        Set appsWithDefaultWrite = this.getAppsWithDefaultWriters(allAppSettings);
        Object[] objectArray = new KafkaPublishOperation[6];
        TenantInvitation tenantInvitation2 = tenantInvitation;
        objectArray[0] = this.tenantProducer.publish$admin_service(tenant, CollectionsKt.toSet((Iterable)allAppSettings), tenantSettings, (String)(tenantInvitation2 == null ? null : tenantInvitation2.getTenantInvitationCode()));
        objectArray[1] = this.permissionProducer.registerTenant$admin_service(tenant.getId());
        objectArray[2] = this.permissionProducer.registerAllAppsForTenant$admin_service(tenant.getId());
        objectArray[3] = this.permissionProducer.allowMembersToReadTenant$admin_service(tenant.getId());
        objectArray[4] = this.permissionProducer.allowTenantReadersToWriteApps$admin_service(tenant.getId(), appsWithDefaultWrite);
        objectArray[5] = this.permissionProducer.applyTenantManagerPermissions$admin_service(tenant.getId(), tenantManagers);
        List operations = CollectionsKt.listOf((Object[])objectArray);
        return new KafkaPublishOperation(operations);
    }

    public void publishNewTenantPermission(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        this.permissionProducer.applyTenantPermission$admin_service(tenantPermission);
    }

    public void publishNewUserGroup(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.permissionProducer.allowUserGroupToReadTenant$admin_service(userGroup);
    }

    /*
     * WARNING - void declaration
     */
    public void publishDeletedTenant(@NotNull TenantId tenantId, @NotNull List<TenantPermission> tenantPermissions, @NotNull List<AppPermission> appPermissions) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
            Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
            Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
            Iterable $this$any$iv = tenantPermissions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    TenantPermission it = (TenantPermission)element$iv2;
                    boolean bl2 = false;
                    if (!(it.getRole() != Role.MANAGER)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new NotImplementedError("handle TenantPermissions for other Roles than MANAGER!");
        }
        Iterable $this$map$iv = tenantPermissions;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(it.getGranteeId());
        }
        List tenantManagerIds = (List)destination$iv$iv;
        this.tenantProducer.publishDeletedTenant(tenantId);
        this.permissionProducer.deleteAllAppsForTenant$admin_service(tenantId);
        this.permissionProducer.disallowMembersToReadTenant$admin_service(tenantId);
        this.permissionProducer.disallowTenantReadersToWriteApps$admin_service(tenantId, ArraysKt.toSet((Object[])CoreApp.values()));
        this.permissionProducer.revokeAppPermissions$admin_service(appPermissions);
        this.permissionProducer.revokeTenantManagerPermissions$admin_service(tenantId, tenantManagerIds);
        this.permissionProducer.deleteItem$admin_service((ItemId)tenantId);
    }

    public static /* synthetic */ void publishDeletedTenant$default(Publisher publisher, TenantId tenantId, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishDeletedTenant");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        publisher.publishDeletedTenant(tenantId, list, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation publishDeletedProfile(@NotNull List<AppPermission> appPermissions, @NotNull List<TenantPermission> tenantManagerPermission) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
        Intrinsics.checkNotNullParameter(tenantManagerPermission, (String)"tenantManagerPermission");
        KafkaPublishOperation appPermissionOp = this.permissionProducer.revokeAppPermissions$admin_service(appPermissions);
        Iterable $this$map$iv = tenantManagerPermission;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.permissionProducer.revokeTenantManagerPermission$admin_service(it.getTenantId(), it.getGranteeId()));
        }
        List tenantManagerOps = (List)destination$iv$iv;
        return new KafkaPublishOperation(CollectionsKt.plus((Collection)tenantManagerOps, (Object)appPermissionOp));
    }

    @NotNull
    public KafkaPublishOperation publishDeletedUserGroup(@NotNull UserGroup userGroup, @NotNull List<AppPermission> appPermissions) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
        Object[] objectArray = new KafkaPublishOperation[]{this.permissionProducer.disallowUserGroupToReadTenant$admin_service(userGroup), this.permissionProducer.revokeAppPermissions$admin_service(appPermissions)};
        return new KafkaPublishOperation(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public KafkaPublishOperation publishEnabledManualPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        return this.permissionProducer.disallowTenantReadersToWriteApps$admin_service(tenantId, SetsKt.setOf((Object)app));
    }

    public void publishDisabledManualPermissions(@NotNull TenantId tenantId, @NotNull CoreApp app, @NotNull List<AppPermission> deletedPermissions) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter(deletedPermissions, (String)"deletedPermissions");
        this.permissionProducer.revokeAppPermissions$admin_service(deletedPermissions);
        this.permissionProducer.allowTenantReadersToWriteApps$admin_service(tenantId, SetsKt.setOf((Object)app));
    }

    @NotNull
    public KafkaPublishOperation publishEnabledManualPeopleExporters(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.permissionProducer.disallowTenantReadersToExport$admin_service(tenantId, SetsKt.setOf((Object)CoreApp.PEOPLE));
    }

    @NotNull
    public KafkaPublishOperation publishDisabledManualPeopleExporters(@NotNull TenantId tenantId, @NotNull List<AppPermission> deletedPermissions) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(deletedPermissions, (String)"deletedPermissions");
        KafkaPublishOperation[] kafkaPublishOperationArray = new KafkaPublishOperation[]{this.permissionProducer.revokeAppPermissions$admin_service(deletedPermissions), this.permissionProducer.allowTenantReadersToExport$admin_service(tenantId, SetsKt.setOf((Object)CoreApp.PEOPLE))};
        return new KafkaPublishOperation(kafkaPublishOperationArray);
    }

    @NotNull
    public KafkaPublishOperation publishUpdatedTenant(@NotNull Tenant tenant, @NotNull TenantSettings tenantSettings, @Nullable TenantInvitation tenantInvitation, @NotNull List<AppSettings> allAppSettings) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        Intrinsics.checkNotNullParameter(allAppSettings, (String)"allAppSettings");
        TenantInvitation tenantInvitation2 = tenantInvitation;
        return this.tenantProducer.publish$admin_service(tenant, CollectionsKt.toSet((Iterable)allAppSettings), tenantSettings, (String)(tenantInvitation2 == null ? null : tenantInvitation2.getTenantInvitationCode()));
    }

    public void publishUpdatedAppPermissions(@NotNull List<AppPermission> addedAppPermissions, @NotNull List<AppPermission> removedAppPermissions) {
        Intrinsics.checkNotNullParameter(addedAppPermissions, (String)"addedAppPermissions");
        Intrinsics.checkNotNullParameter(removedAppPermissions, (String)"removedAppPermissions");
        this.permissionProducer.applyAppPermissions$admin_service(addedAppPermissions);
        this.permissionProducer.revokeAppPermissions$admin_service(removedAppPermissions);
    }

    public void publishUpdatedTenantManagers(@NotNull TenantId tenantId, @NotNull List<? extends GranteeId> add, @NotNull List<? extends GranteeId> remove) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(add, (String)"add");
        Intrinsics.checkNotNullParameter(remove, (String)"remove");
        this.permissionProducer.applyTenantManagerPermissions$admin_service(tenantId, add);
        this.permissionProducer.revokeTenantManagerPermissions$admin_service(tenantId, remove);
    }

    /*
     * WARNING - void declaration
     */
    private Set<CoreApp> getAppsWithDefaultWriters(List<AppSettings> allAppSettings) {
        void $this$mapTo$iv$iv;
        AppSettings it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = allAppSettings;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AppSettings)element$iv$iv;
            boolean bl = false;
            if (!(!it.getHasManualAppWriterPermissions())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AppSettings)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getApp());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public void publishOAuthClientChange(@NotNull IdpConfiguration idpConfig) {
        Intrinsics.checkNotNullParameter((Object)idpConfig, (String)"idpConfig");
        if (idpConfig.getEnabled()) {
            this.oauthClientProducer.publish$admin_service(this.idpConfigToClientRegistration(idpConfig));
        } else {
            this.oauthClientProducer.publishDeletion$admin_service(idpConfig.getConfigId());
        }
    }

    public void publishOAuthClientDeletion(@NotNull ClientRegistrationId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.oauthClientProducer.publishDeletion$admin_service(id);
    }

    public void republishOAuthClients(@NotNull Runnable doRepublish) {
        Intrinsics.checkNotNullParameter((Object)doRepublish, (String)"doRepublish");
        this.oauthClientProducer.republish$admin_service(doRepublish);
    }

    /*
     * WARNING - void declaration
     */
    private ClientRegistration idpConfigToClientRegistration(IdpConfiguration conf) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string;
        Object object;
        String[] $this$idpConfigToClientRegistration_u24lambda_u2d5 = object = ClientRegistration.newBuilder();
        boolean $i$a$-apply-Publisher$idpConfigToClientRegistration$22 = false;
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setRegistrationId(conf.getConfigId().toString());
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setTenantId(conf.getTenantId().asItemId());
        String string2 = conf.getClientId();
        if (string2 == null) {
            string2 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setClientId(string2);
        String string3 = conf.getClientSecret();
        if (string3 == null) {
            string3 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setClientSecret(string3);
        String string4 = conf.getIdpName();
        if (string4 == null) {
            string4 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setClientName(string4);
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setAuthorizationGrantType(conf.getAuthorizationGrantType().getValue());
        String string5 = conf.getScope();
        if (string5 == null) {
            string = "";
        } else {
            Regex regex = new Regex("\\s");
            CharSequence charSequence = string5;
            String string6 = "";
            string = regex.replace(charSequence, string6);
            if (string == null) {
                string = "";
            }
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setScope(string);
        String string7 = conf.getAuthorizationUri();
        if (string7 == null) {
            string7 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setAuthorizationUri(string7);
        String string8 = conf.getTokenUri();
        if (string8 == null) {
            string8 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setTokenUri(string8);
        String string9 = conf.getUserInfoUri();
        if (string9 == null) {
            string9 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setUserInfoUri(string9);
        String string10 = conf.getIssuerUri();
        if (string10 == null) {
            string10 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setIssuerUri(string10);
        String string11 = conf.getJwkSetUri();
        if (string11 == null) {
            string11 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setJwkSetUri(string11);
        String string12 = conf.getUserNameAttribute();
        if (string12 == null) {
            string12 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setUserNameAttribute(string12);
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setAutomaticMode(conf.getAutomaticMode());
        $this$idpConfigToClientRegistration_u24lambda_u2d5.setDefaultProvider(conf.getDefaultProvider());
        String[] stringArray = object;
        object = new String[]{","};
        object = StringsKt.split$default((CharSequence)conf.getTargets(), (String[])object, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = stringArray;
        boolean $i$f$map = false;
        void $i$a$-apply-Publisher$idpConfigToClientRegistration$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string13 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ClientRegistration.Target.valueOf((String)it));
        }
        ClientRegistration clientRegistration = stringArray2.addAllTargets((Iterable)((List)destination$iv$iv)).build();
        Intrinsics.checkNotNullExpressionValue((Object)clientRegistration, (String)"newBuilder().apply {\n   \u2026et.valueOf(it) }).build()");
        return clientRegistration;
    }
}

